/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;

class RangeSliceCommandSerializer
implements IVersionedSerializer<RangeSliceCommand> {
    RangeSliceCommandSerializer() {
    }

    @Override
    public void serialize(RangeSliceCommand sliceCommand, DataOutputPlus out, int version) throws IOException {
        out.writeUTF(sliceCommand.keyspace);
        out.writeUTF(sliceCommand.columnFamily);
        out.writeLong(sliceCommand.timestamp);
        CFMetaData metadata = Schema.instance.getCFMetaData(sliceCommand.keyspace, sliceCommand.columnFamily);
        metadata.comparator.diskAtomFilterSerializer().serialize(sliceCommand.predicate, out, version);
        if (sliceCommand.rowFilter == null) {
            out.writeInt(0);
        } else {
            out.writeInt(sliceCommand.rowFilter.size());
            for (IndexExpression expr : sliceCommand.rowFilter) {
                expr.writeTo(out);
            }
        }
        AbstractBounds.serializer.serialize(sliceCommand.keyRange, out, version);
        out.writeInt(sliceCommand.maxResults);
        out.writeBoolean(sliceCommand.countCQL3Rows);
        out.writeBoolean(sliceCommand.isPaging);
    }

    @Override
    public RangeSliceCommand deserialize(DataInput in, int version) throws IOException {
        String keyspace = in.readUTF();
        String columnFamily = in.readUTF();
        long timestamp = in.readLong();
        CFMetaData metadata = Schema.instance.getCFMetaData(keyspace, columnFamily);
        if (metadata == null) {
            String message = String.format("Got range slice command for nonexistent table %s.%s.  If the table was just created, this is likely due to the schema not being fully propagated.  Please wait for schema agreement on table creation.", keyspace, columnFamily);
            throw new UnknownColumnFamilyException(message, null);
        }
        IDiskAtomFilter predicate = metadata.comparator.diskAtomFilterSerializer().deserialize(in, version);
        int filterCount = in.readInt();
        ArrayList<IndexExpression> rowFilter = new ArrayList<IndexExpression>(filterCount);
        for (int i = 0; i < filterCount; ++i) {
            rowFilter.add(IndexExpression.readFrom(in));
        }
        AbstractBounds<RowPosition> range = ((AbstractBounds)AbstractBounds.serializer.deserialize(in, version)).toRowBounds();
        int maxResults = in.readInt();
        boolean countCQL3Rows = in.readBoolean();
        boolean isPaging = in.readBoolean();
        return new RangeSliceCommand(keyspace, columnFamily, timestamp, predicate, range, rowFilter, maxResults, countCQL3Rows, isPaging);
    }

    @Override
    public long serializedSize(RangeSliceCommand rsc, int version) {
        long size = TypeSizes.NATIVE.sizeof(rsc.keyspace);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.columnFamily);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.timestamp);
        CFMetaData metadata = Schema.instance.getCFMetaData(rsc.keyspace, rsc.columnFamily);
        IDiskAtomFilter filter = rsc.predicate;
        size += metadata.comparator.diskAtomFilterSerializer().serializedSize(filter, version);
        if (rsc.rowFilter == null) {
            size += (long)TypeSizes.NATIVE.sizeof(0);
        } else {
            size += (long)TypeSizes.NATIVE.sizeof(rsc.rowFilter.size());
            for (IndexExpression expr : rsc.rowFilter) {
                size += (long)TypeSizes.NATIVE.sizeofWithShortLength(expr.column);
                size += (long)TypeSizes.NATIVE.sizeof(expr.operator.ordinal());
                size += (long)TypeSizes.NATIVE.sizeofWithShortLength(expr.value);
            }
        }
        size += AbstractBounds.serializer.serializedSize(rsc.keyRange, version);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.maxResults);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.countCQL3Rows);
        return size += (long)TypeSizes.NATIVE.sizeof(rsc.isPaging);
    }
}

