/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.io.util.AbstractDataOutput;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.io.util.SafeMemory;

public class SafeMemoryWriter
extends AbstractDataOutput
implements DataOutputPlus {
    private ByteOrder order = ByteOrder.BIG_ENDIAN;
    private SafeMemory buffer;
    private long length;

    public SafeMemoryWriter(long initialCapacity) {
        this.buffer = new SafeMemory(initialCapacity);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) {
        long newLength = this.ensureCapacity(count);
        this.buffer.setBytes(this.length, buffer, offset, count);
        this.length = newLength;
    }

    @Override
    public void write(int oneByte) {
        long newLength = this.ensureCapacity(1L);
        this.buffer.setByte(this.length++, (byte)oneByte);
        this.length = newLength;
    }

    @Override
    public void writeShort(int val) throws IOException {
        if (this.order != ByteOrder.nativeOrder()) {
            val = Short.reverseBytes((short)val);
        }
        long newLength = this.ensureCapacity(2L);
        this.buffer.setShort(this.length, (short)val);
        this.length = newLength;
    }

    @Override
    public void writeInt(int val) {
        if (this.order != ByteOrder.nativeOrder()) {
            val = Integer.reverseBytes(val);
        }
        long newLength = this.ensureCapacity(4L);
        this.buffer.setInt(this.length, val);
        this.length = newLength;
    }

    @Override
    public void writeLong(long val) {
        if (this.order != ByteOrder.nativeOrder()) {
            val = Long.reverseBytes(val);
        }
        long newLength = this.ensureCapacity(8L);
        this.buffer.setLong(this.length, val);
        this.length = newLength;
    }

    @Override
    public void write(ByteBuffer buffer) {
        long newLength = this.ensureCapacity(buffer.remaining());
        this.buffer.setBytes(this.length, buffer);
        this.length = newLength;
    }

    public void write(Memory memory) {
        long newLength = this.ensureCapacity(memory.size());
        this.buffer.put(this.length, memory, 0L, memory.size());
        this.length = newLength;
    }

    private long ensureCapacity(long size) {
        long newLength = this.length + size;
        if (newLength > this.buffer.size()) {
            this.setCapacity(Math.max(newLength, this.buffer.size() + this.buffer.size() / 2L));
        }
        return newLength;
    }

    public SafeMemory currentBuffer() {
        return this.buffer;
    }

    public void setCapacity(long newCapacity) {
        if (newCapacity != this.capacity()) {
            SafeMemory oldBuffer = this.buffer;
            this.buffer = this.buffer.copy(newCapacity);
            oldBuffer.free();
        }
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public long length() {
        return this.length;
    }

    public long capacity() {
        return this.buffer.size();
    }

    public SafeMemoryWriter withByteOrder(ByteOrder order) {
        this.order = order;
        return this;
    }
}

