/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.iterator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;

public final class ArrayIterator<T>
implements Iterator<T>,
Serializable {
    private final T[] array;
    private int current = 0;

    public ArrayIterator(T[] array) {
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.array.length;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            ++this.current;
            return this.array[this.current - 1];
        }
        throw FastNoSuchElementException.instance();
    }

    public String toString() {
        return Arrays.asList(this.array).toString();
    }
}

