/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.text.ParseException;
import java.util.Date;
import org.apache.tinkerpop.shaded.jackson.databind.util.StdDateFormat;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.LongSerializer;

public class DateSerializer
implements OrderPreservingSerializer<Date> {
    private final LongSerializer ls = LongSerializer.INSTANCE;
    private final StdDateFormat dateFormat = StdDateFormat.instance;

    @Override
    public Date read(ScanBuffer buffer) {
        long utc = this.ls.read(buffer);
        return new Date(utc);
    }

    @Override
    public void write(WriteBuffer out, Date attribute) {
        long utc = attribute.getTime();
        this.ls.write(out, utc);
    }

    @Override
    public Date readByteOrder(ScanBuffer buffer) {
        return this.read(buffer);
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, Date attribute) {
        this.write(buffer, attribute);
    }

    @Override
    public Date convert(Object value) {
        if (value instanceof Number && !(value instanceof Float) && !(value instanceof Double)) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            try {
                return this.dateFormat.parse((String)value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }
}

