/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.util.CloseableAbstractIterator;

public class SubqueryIterator
extends CloseableAbstractIterator<JanusGraphElement> {
    private final JointIndexQuery.Subquery subQuery;
    private final Cache<JointIndexQuery.Subquery, List<Object>> indexCache;
    private Iterator<? extends JanusGraphElement> elementIterator;
    private List<Object> currentIds;
    private QueryProfiler profiler;
    private boolean isTimerRunning;

    public SubqueryIterator(JointIndexQuery.Subquery subQuery, IndexSerializer indexSerializer, BackendTransaction tx, Cache<JointIndexQuery.Subquery, List<Object>> indexCache, int limit, Function<Object, ? extends JanusGraphElement> function, List<Object> otherResults) {
        Stream<Object> stream;
        this.subQuery = subQuery;
        this.indexCache = indexCache;
        List cacheResponse = (List)indexCache.getIfPresent((Object)subQuery);
        if (cacheResponse != null) {
            stream = cacheResponse.stream();
        } else {
            try {
                this.currentIds = new ArrayList<Object>();
                this.profiler = QueryProfiler.startProfile(subQuery.getProfiler(), subQuery);
                this.isTimerRunning = true;
                stream = indexSerializer.query(subQuery, tx).peek(r -> this.currentIds.add(r));
            }
            catch (Exception e2) {
                throw new JanusGraphException("Could not call index", e2.getCause());
            }
        }
        this.elementIterator = stream.filter(e -> otherResults == null || otherResults.contains(e)).limit(limit).map(function).map(r -> r).iterator();
    }

    protected JanusGraphElement computeNext() {
        if (this.elementIterator.hasNext()) {
            return this.elementIterator.next();
        }
        this.close();
        return (JanusGraphElement)this.endOfData();
    }

    public void close() {
        if (this.isTimerRunning) {
            assert (this.currentIds != null);
            if (!this.elementIterator.hasNext()) {
                this.indexCache.put((Object)this.subQuery, this.currentIds);
            }
            this.profiler.setResultSize(this.currentIds.size());
            this.profiler.stopTimer();
            this.isTimerRunning = false;
        }
    }
}

