/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics.reporter.config;

import com.addthis.metrics.reporter.config.AbstractHostPortReporterConfig;
import com.addthis.metrics.reporter.config.HostPort;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricPredicate;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.reporting.GraphiteReporter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteReporterConfig
extends AbstractHostPortReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(GraphiteReporterConfig.class);
    @NotNull
    private String prefix = "";

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public List<HostPort> getFullHostList() {
        return this.getHostListAndStringList();
    }

    @Override
    public boolean enable() {
        String className = "com.yammer.metrics.reporting.GraphiteReporter";
        if (!this.isClassAvailable(className)) {
            log.error("Tried to enable GraphiteReporter, but class {} was not found", (Object)className);
            return false;
        }
        List<HostPort> hosts = this.getFullHostList();
        if (hosts == null || hosts.isEmpty()) {
            log.error("No hosts specified, cannot enable GraphiteReporter");
            return false;
        }
        for (HostPort hostPort : hosts) {
            try {
                log.info("Enabling GraphiteReporter to {}:{}", new Object[]{hostPort.getHost(), hostPort.getPort()});
                GraphiteReporter.enable((MetricsRegistry)Metrics.defaultRegistry(), (long)this.getPeriod(), (TimeUnit)this.getRealTimeunit(), (String)hostPort.getHost(), (int)hostPort.getPort(), (String)this.prefix, (MetricPredicate)this.getMetricPredicate());
            }
            catch (Exception e) {
                log.error("Failed to enable GraphiteReporter", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

