/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.IOException;

public class ZstdDictCompress
implements Closeable {
    private long nativePtr = 0L;

    private native void init(byte[] var1, int var2, int var3, int var4);

    private native void free();

    public ZstdDictCompress(byte[] byArray, int n) {
        this(byArray, 0, byArray.length, n);
    }

    public ZstdDictCompress(byte[] byArray, int n, int n2, int n3) {
        if (byArray.length - n < 0) {
            throw new IllegalArgumentException("Dictionary buffer is to short");
        }
        this.init(byArray, n, n2, n3);
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCDict failed");
        }
    }

    @Override
    public void close() throws IOException {
        this.free();
        this.nativePtr = 0L;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        Native.load();
    }
}

