/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.concurrent;

import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.JMXConfigurableThreadPoolExecutor;
import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.NamedThreadFactory;
import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.Stage;
import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.TracingAwareExecutorService;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.tracing.TraceState;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import java.util.EnumMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageManager {
    private static final Logger logger = LoggerFactory.getLogger(StageManager.class);
    private static final EnumMap<Stage, TracingAwareExecutorService> stages = new EnumMap(Stage.class);
    public static final long KEEPALIVE = 60L;
    public static final int MAX_REPLICATE_ON_WRITE_TASKS = 1024 * FBUtilities.getAvailableProcessors();

    private static ExecuteOnlyExecutor tracingExecutor() {
        RejectedExecutionHandler reh = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                MessagingService.instance().incrementDroppedMessages(MessagingService.Verb._TRACE);
            }
        };
        return new ExecuteOnlyExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new NamedThreadFactory(Stage.TRACING.getJmxName()), reh);
    }

    private static JMXEnabledThreadPoolExecutor multiThreadedStage(Stage stage, int numThreads) {
        return new JMXEnabledThreadPoolExecutor(numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(stage.getJmxName()), stage.getJmxType());
    }

    private static JMXConfigurableThreadPoolExecutor multiThreadedConfigurableStage(Stage stage, int numThreads) {
        return new JMXConfigurableThreadPoolExecutor(numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(stage.getJmxName()), stage.getJmxType());
    }

    private static JMXConfigurableThreadPoolExecutor multiThreadedConfigurableStage(Stage stage, int numThreads, int maxTasksBeforeBlock) {
        return new JMXConfigurableThreadPoolExecutor(numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxTasksBeforeBlock), new NamedThreadFactory(stage.getJmxName()), stage.getJmxType());
    }

    public static TracingAwareExecutorService getStage(Stage stage) {
        return stages.get((Object)stage);
    }

    public static void shutdownNow() {
        for (Stage stage : Stage.values()) {
            stages.get((Object)stage).shutdownNow();
        }
    }

    static {
        stages.put(Stage.MUTATION, StageManager.multiThreadedConfigurableStage(Stage.MUTATION, DatabaseDescriptor.getConcurrentWriters()));
        stages.put(Stage.READ, StageManager.multiThreadedConfigurableStage(Stage.READ, DatabaseDescriptor.getConcurrentReaders()));
        stages.put(Stage.REQUEST_RESPONSE, StageManager.multiThreadedStage(Stage.REQUEST_RESPONSE, FBUtilities.getAvailableProcessors()));
        stages.put(Stage.INTERNAL_RESPONSE, StageManager.multiThreadedStage(Stage.INTERNAL_RESPONSE, FBUtilities.getAvailableProcessors()));
        stages.put(Stage.REPLICATE_ON_WRITE, StageManager.multiThreadedConfigurableStage(Stage.REPLICATE_ON_WRITE, DatabaseDescriptor.getConcurrentReplicators(), MAX_REPLICATE_ON_WRITE_TASKS));
        stages.put(Stage.GOSSIP, new JMXEnabledThreadPoolExecutor(Stage.GOSSIP));
        stages.put(Stage.ANTI_ENTROPY, new JMXEnabledThreadPoolExecutor(Stage.ANTI_ENTROPY));
        stages.put(Stage.MIGRATION, new JMXEnabledThreadPoolExecutor(Stage.MIGRATION));
        stages.put(Stage.MISC, new JMXEnabledThreadPoolExecutor(Stage.MISC));
        stages.put(Stage.READ_REPAIR, StageManager.multiThreadedStage(Stage.READ_REPAIR, FBUtilities.getAvailableProcessors()));
        stages.put(Stage.TRACING, StageManager.tracingExecutor());
    }

    private static class ExecuteOnlyExecutor
    extends ThreadPoolExecutor
    implements TracingAwareExecutorService {
        public ExecuteOnlyExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        @Override
        public void execute(Runnable command, TraceState state) {
            assert (state == null);
            super.execute(command);
        }

        @Override
        public Future<?> submit(Runnable task) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            throw new UnsupportedOperationException();
        }
    }
}

