/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Auth;
import com.netflix.astyanax.shaded.org.apache.cassandra.auth.AuthenticatedUser;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.AuthenticationStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestExecutionException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;

public class DropUserStatement
extends AuthenticationStatement {
    private final String username;
    private final boolean ifExists;

    public DropUserStatement(String username, boolean ifExists) {
        this.username = username;
        this.ifExists = ifExists;
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        state.ensureNotAnonymous();
        if (!this.ifExists && !Auth.isExistingUser(this.username)) {
            throw new InvalidRequestException(String.format("User %s doesn't exist", this.username));
        }
        AuthenticatedUser user = state.getUser();
        if (user != null && user.getName().equals(this.username)) {
            throw new InvalidRequestException("Users aren't allowed to DROP themselves");
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        if (!state.getUser().isSuper()) {
            throw new UnauthorizedException("Only superusers are allowed to perform DROP USER queries");
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        if (this.ifExists && !Auth.isExistingUser(this.username)) {
            return null;
        }
        DatabaseDescriptor.getAuthorizer().revokeAll(this.username);
        Auth.deleteUser(this.username);
        DatabaseDescriptor.getAuthenticator().drop(this.username);
        return null;
    }
}

