/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.BlacklistedDirectoriesMBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistedDirectories
implements BlacklistedDirectoriesMBean {
    public static final String MBEAN_NAME = "com.netflix.astyanax.shaded.org.apache.cassandra.db:type=BlacklistedDirectories";
    private static final Logger logger = LoggerFactory.getLogger(BlacklistedDirectories.class);
    private static final BlacklistedDirectories instance = new BlacklistedDirectories();
    private final Set<File> unreadableDirectories = new CopyOnWriteArraySet<File>();
    private final Set<File> unwritableDirectories = new CopyOnWriteArraySet<File>();

    private BlacklistedDirectories() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            logger.error("error registering MBean org.apache.cassandra.db:type=BlacklistedDirectories", (Throwable)e);
        }
    }

    @Override
    public Set<File> getUnreadableDirectories() {
        return Collections.unmodifiableSet(this.unreadableDirectories);
    }

    @Override
    public Set<File> getUnwritableDirectories() {
        return Collections.unmodifiableSet(this.unwritableDirectories);
    }

    public static File maybeMarkUnreadable(File path) {
        File directory = BlacklistedDirectories.getDirectory(path);
        if (BlacklistedDirectories.instance.unreadableDirectories.add(directory)) {
            logger.warn("Blacklisting {} for reads", (Object)directory);
            return directory;
        }
        return null;
    }

    public static File maybeMarkUnwritable(File path) {
        File directory = BlacklistedDirectories.getDirectory(path);
        if (BlacklistedDirectories.instance.unwritableDirectories.add(directory)) {
            logger.warn("Blacklisting {} for writes", (Object)directory);
            return directory;
        }
        return null;
    }

    public static boolean isUnreadable(File directory) {
        return BlacklistedDirectories.instance.unreadableDirectories.contains(directory);
    }

    public static boolean isUnwritable(File directory) {
        return BlacklistedDirectories.instance.unwritableDirectories.contains(directory);
    }

    private static File getDirectory(File file) {
        if (file.isDirectory()) {
            return file;
        }
        if (file.isFile()) {
            return file.getParentFile();
        }
        if (file.getPath().endsWith(".db")) {
            return file.getParentFile();
        }
        return file;
    }
}

