/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ArrayBackedSortedColumns;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Memtable;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.OnDiskAtom;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.NamesQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.QueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CounterColumnType;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTable;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileUtils;
import com.netflix.astyanax.shaded.org.apache.cassandra.tracing.Tracing;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.HeapAllocator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;

public class CollationController {
    private final ColumnFamilyStore cfs;
    private final QueryFilter filter;
    private final int gcBefore;
    private int sstablesIterated = 0;

    public CollationController(ColumnFamilyStore cfs, QueryFilter filter, int gcBefore) {
        this.cfs = cfs;
        this.filter = filter;
        this.gcBefore = gcBefore;
    }

    public ColumnFamily getTopLevelColumns() {
        return this.filter.filter instanceof NamesQueryFilter && this.cfs.metadata.getDefaultValidator() != CounterColumnType.instance ? this.collectTimeOrderedData() : this.collectAllData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily collectTimeOrderedData() {
        ArrayBackedSortedColumns container = ArrayBackedSortedColumns.factory.create(this.cfs.metadata, this.filter.filter.isReversed());
        ArrayList<OnDiskAtomIterator> iterators = new ArrayList<OnDiskAtomIterator>();
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = this.cfs.markReferenced(this.filter.key);
        ArrayBackedSortedColumns temp = ArrayBackedSortedColumns.factory.create(this.cfs.metadata, this.filter.filter.isReversed());
        try {
            Tracing.trace("Merging memtable contents");
            long mostRecentRowTombstone = Long.MIN_VALUE;
            for (Memtable memtable : view.memtables) {
                OnDiskAtomIterator iter = this.filter.getMemtableColumnIterator(memtable);
                if (iter != null) {
                    iterators.add(iter);
                    temp.delete(iter.getColumnFamily());
                    while (iter.hasNext()) {
                        temp.addAtom((OnDiskAtom)iter.next());
                    }
                }
                container.addAll(temp, HeapAllocator.instance);
                mostRecentRowTombstone = ((ColumnFamily)container).deletionInfo().getTopLevelDeletion().markedForDeleteAt;
                ((ColumnFamily)temp).clear();
            }
            NamesQueryFilter namesFilter = (NamesQueryFilter)this.filter.filter;
            TreeSet<ByteBuffer> filterColumns = new TreeSet<ByteBuffer>(namesFilter.columns);
            QueryFilter reducedFilter = new QueryFilter(this.filter.key, this.filter.cfName, namesFilter.withUpdatedColumns(filterColumns), this.filter.timestamp);
            Collections.sort(view.sstables, SSTable.maxTimestampComparator);
            for (SSTableReader sstable : view.sstables) {
                if (sstable.getMaxTimestamp() < mostRecentRowTombstone) break;
                long currentMaxTs = sstable.getMaxTimestamp();
                this.reduceNameFilter(reducedFilter, container, currentMaxTs);
                if (((NamesQueryFilter)reducedFilter.filter).columns.isEmpty()) break;
                Tracing.trace("Merging data from sstable {}", sstable.descriptor.generation);
                OnDiskAtomIterator iter = reducedFilter.getSSTableColumnIterator(sstable);
                iterators.add(iter);
                if (iter.getColumnFamily() != null) {
                    ColumnFamily cf = iter.getColumnFamily();
                    temp.delete(cf);
                    ++this.sstablesIterated;
                    while (iter.hasNext()) {
                        temp.addAtom((OnDiskAtom)iter.next());
                    }
                }
                container.addAll(temp, HeapAllocator.instance);
                mostRecentRowTombstone = ((ColumnFamily)container).deletionInfo().getTopLevelDeletion().markedForDeleteAt;
                ((ColumnFamily)temp).clear();
            }
            if (iterators.isEmpty()) {
                Iterator<SSTableReader> i$ = null;
                return i$;
            }
            ColumnFamily returnCF = container.cloneMeShallow();
            Tracing.trace("Collating all results");
            this.filter.collateOnDiskAtom(returnCF, ((ColumnFamily)container).iterator(), this.gcBefore);
            if (this.sstablesIterated > this.cfs.getMinimumCompactionThreshold() && !this.cfs.isAutoCompactionDisabled() && this.cfs.getCompactionStrategy() instanceof SizeTieredCompactionStrategy) {
                Tracing.trace("Defragmenting requested data");
                RowMutation rm = new RowMutation(this.cfs.keyspace.getName(), this.filter.key.key, returnCF.cloneMe());
                Keyspace.open(rm.getKeyspaceName()).apply(rm, false, false);
            }
            ColumnFamily columnFamily = returnCF;
            return columnFamily;
        }
        finally {
            for (OnDiskAtomIterator iter : iterators) {
                FileUtils.closeQuietly(iter);
            }
            SSTableReader.releaseReferences(view.sstables);
        }
    }

    private void reduceNameFilter(QueryFilter filter, ColumnFamily container, long sstableTimestamp) {
        if (container == null) {
            return;
        }
        Iterator iterator = ((NamesQueryFilter)filter.filter).columns.iterator();
        while (iterator.hasNext()) {
            ByteBuffer filterColumn = (ByteBuffer)iterator.next();
            Column column = container.getColumn(filterColumn);
            if (column == null || column.timestamp() <= sstableTimestamp) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily collectAllData() {
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = this.cfs.markReferenced(this.filter.key);
        ArrayList<OnDiskAtomIterator> iterators = new ArrayList<OnDiskAtomIterator>(Iterables.size(view.memtables) + view.sstables.size());
        ArrayBackedSortedColumns returnCF = ArrayBackedSortedColumns.factory.create(this.cfs.metadata, this.filter.filter.isReversed());
        try {
            ArrayBackedSortedColumns arrayBackedSortedColumns;
            Tracing.trace("Merging memtable tombstones");
            for (Memtable memtable : view.memtables) {
                OnDiskAtomIterator iter = this.filter.getMemtableColumnIterator(memtable);
                if (iter == null) continue;
                returnCF.delete(iter.getColumnFamily());
                iterators.add(iter);
            }
            Collections.sort(view.sstables, SSTable.maxTimestampComparator);
            ArrayList<SSTableReader> skippedSSTables = null;
            long mostRecentRowTombstone = Long.MIN_VALUE;
            long minTimestamp = Long.MAX_VALUE;
            int nonIntersectingSSTables = 0;
            for (SSTableReader sstable : view.sstables) {
                minTimestamp = Math.min(minTimestamp, sstable.getMinTimestamp());
                if (sstable.getMaxTimestamp() < mostRecentRowTombstone) break;
                if (!this.filter.shouldInclude(sstable)) {
                    ++nonIntersectingSSTables;
                    if (sstable.getSSTableMetadata().maxLocalDeletionTime == Integer.MAX_VALUE) continue;
                    if (skippedSSTables == null) {
                        skippedSSTables = new ArrayList<SSTableReader>();
                    }
                    skippedSSTables.add(sstable);
                    continue;
                }
                sstable.incrementReadCount();
                OnDiskAtomIterator iter = this.filter.getSSTableColumnIterator(sstable);
                iterators.add(iter);
                if (iter.getColumnFamily() == null) continue;
                ColumnFamily cf = iter.getColumnFamily();
                if (cf.isMarkedForDelete()) {
                    mostRecentRowTombstone = cf.deletionInfo().getTopLevelDeletion().markedForDeleteAt;
                }
                returnCF.delete(cf);
                ++this.sstablesIterated;
            }
            int includedDueToTombstones = 0;
            if (skippedSSTables != null) {
                for (SSTableReader sstable : skippedSSTables) {
                    if (sstable.getMaxTimestamp() <= minTimestamp) continue;
                    sstable.incrementReadCount();
                    OnDiskAtomIterator iter = this.filter.getSSTableColumnIterator(sstable);
                    ColumnFamily cf = iter.getColumnFamily();
                    if (cf != null && cf.deletionInfo().getTopLevelDeletion().markedForDeleteAt > minTimestamp) {
                        ++includedDueToTombstones;
                        iterators.add(iter);
                        ((ColumnFamily)returnCF).delete(cf.deletionInfo().getTopLevelDeletion());
                        ++this.sstablesIterated;
                        continue;
                    }
                    FileUtils.closeQuietly(iter);
                }
            }
            if (Tracing.isTracing()) {
                Tracing.trace("Skipped {}/{} non-slice-intersecting sstables, included {} due to tombstones", new Object[]{nonIntersectingSSTables, view.sstables.size(), includedDueToTombstones});
            }
            if (iterators.isEmpty()) {
                arrayBackedSortedColumns = null;
                return arrayBackedSortedColumns;
            }
            Tracing.trace("Merging data from memtables and {} sstables", this.sstablesIterated);
            this.filter.collateOnDiskAtom((ColumnFamily)returnCF, iterators, this.gcBefore);
            arrayBackedSortedColumns = returnCF;
            return arrayBackedSortedColumns;
        }
        finally {
            for (OnDiskAtomIterator iter : iterators) {
                FileUtils.closeQuietly(iter);
            }
            SSTableReader.releaseReferences(view.sstables);
        }
    }

    public int getSstablesIterated() {
        return this.sstablesIterated;
    }
}

