/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQL3Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.DateType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TimestampType;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.LongSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;

public class LongType
extends AbstractType<Long> {
    public static final LongType instance = new LongType();

    LongType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return LongType.compareLongs(o1, o2);
    }

    public static int compareLongs(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        int diff = o1.get(o1.position()) - o2.get(o2.position());
        if (diff != 0) {
            return diff;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        long longType;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            longType = Long.parseLong(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make long from '%s'", source), e);
        }
        return this.decompose(longType);
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || otherType == DateType.instance || otherType == TimestampType.instance;
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.BIGINT;
    }

    @Override
    public TypeSerializer<Long> getSerializer() {
        return LongSerializer.instance;
    }
}

