/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CollectionType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TypeParser;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.SyntaxException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MapSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapType<K, V>
extends CollectionType<Map<K, V>> {
    private static final Map<Pair<AbstractType<?>, AbstractType<?>>, MapType> instances = new HashMap();
    public final AbstractType<K> keys;
    public final AbstractType<V> values;
    private final MapSerializer<K, V> serializer;

    public static MapType<?, ?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 2) {
            throw new ConfigurationException("MapType takes exactly 2 type parameters");
        }
        return MapType.getInstance(l.get(0), l.get(1));
    }

    public static synchronized <K, V> MapType<K, V> getInstance(AbstractType<K> keys, AbstractType<V> values) {
        Pair<AbstractType<K>, AbstractType<V>> p = Pair.create(keys, values);
        MapType<K, V> t = instances.get(p);
        if (t == null) {
            t = new MapType<K, V>(keys, values);
            instances.put(p, t);
        }
        return t;
    }

    private MapType(AbstractType<K> keys, AbstractType<V> values) {
        super(CollectionType.Kind.MAP);
        this.keys = keys;
        this.values = values;
        this.serializer = MapSerializer.getInstance(keys.getSerializer(), values.getSerializer());
    }

    @Override
    public AbstractType<K> nameComparator() {
        return this.keys;
    }

    @Override
    public AbstractType<V> valueComparator() {
        return this.values;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1 == null || !o1.hasRemaining()) {
            return o2 == null || !o2.hasRemaining() ? 0 : -1;
        }
        if (o2 == null || !o2.hasRemaining()) {
            return 1;
        }
        ByteBuffer bb1 = o1.duplicate();
        ByteBuffer bb2 = o2.duplicate();
        int size1 = ByteBufferUtil.readShortLength(bb1);
        int size2 = ByteBufferUtil.readShortLength(bb2);
        for (int i = 0; i < Math.min(size1, size2); ++i) {
            ByteBuffer v2;
            ByteBuffer k2;
            ByteBuffer k1 = ByteBufferUtil.readBytesWithShortLength(bb1);
            int cmp = this.keys.compare(k1, k2 = ByteBufferUtil.readBytesWithShortLength(bb2));
            if (cmp != 0) {
                return cmp;
            }
            ByteBuffer v1 = ByteBufferUtil.readBytesWithShortLength(bb1);
            cmp = this.values.compare(v1, v2 = ByteBufferUtil.readBytesWithShortLength(bb2));
            if (cmp == 0) continue;
            return cmp;
        }
        return size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
    }

    @Override
    public TypeSerializer<Map<K, V>> getSerializer() {
        return this.serializer;
    }

    @Override
    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Arrays.asList(this.keys, this.values)));
    }

    @Override
    public ByteBuffer serialize(CFDefinition.Name name, List<Pair<ByteBuffer, Column>> columns) {
        columns = this.enforceLimit(name, columns);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(2 * columns.size());
        int size = 0;
        for (Pair<ByteBuffer, Column> p : columns) {
            bbs.add((ByteBuffer)p.left);
            bbs.add(((Column)p.right).value());
            size += 4 + ((ByteBuffer)p.left).remaining() + ((Column)p.right).value().remaining();
        }
        return MapType.pack(bbs, columns.size(), size);
    }
}

