/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.gms;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.ApplicationState;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.EndpointState;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.Gossiper;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.HeartBeatState;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.VersionedValue;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

class EndpointStateSerializer
implements IVersionedSerializer<EndpointState> {
    EndpointStateSerializer() {
    }

    @Override
    public void serialize(EndpointState epState, DataOutput out, int version) throws IOException {
        HeartBeatState hbState = epState.getHeartBeatState();
        HeartBeatState.serializer.serialize(hbState, out, version);
        int size = epState.applicationState.size();
        out.writeInt(size);
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.applicationState.entrySet()) {
            VersionedValue value = entry.getValue();
            out.writeInt(entry.getKey().ordinal());
            VersionedValue.serializer.serialize(value, out, version);
        }
    }

    @Override
    public EndpointState deserialize(DataInput in, int version) throws IOException {
        HeartBeatState hbState = HeartBeatState.serializer.deserialize(in, version);
        EndpointState epState = new EndpointState(hbState);
        int appStateSize = in.readInt();
        for (int i = 0; i < appStateSize; ++i) {
            int key = in.readInt();
            VersionedValue value = VersionedValue.serializer.deserialize(in, version);
            epState.addApplicationState(Gossiper.STATES[key], value);
        }
        return epState;
    }

    @Override
    public long serializedSize(EndpointState epState, int version) {
        long size = HeartBeatState.serializer.serializedSize(epState.getHeartBeatState(), version);
        size += (long)TypeSizes.NATIVE.sizeof(epState.applicationState.size());
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.applicationState.entrySet()) {
            VersionedValue value = entry.getValue();
            size += (long)TypeSizes.NATIVE.sizeof(entry.getKey().ordinal());
            size += VersionedValue.serializer.serializedSize(value, version);
        }
        return size;
    }
}

