/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.graphson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.janus.graphson.AtlasElementPropertyConfig;
import org.apache.atlas.repository.graphdb.janus.graphson.AtlasGraphSONMode;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;

public final class AtlasGraphSONUtility {
    private static final JsonNodeFactory JSON_NODE_FACTORY = JsonNodeFactory.instance;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final AtlasGraphSONMode mode;
    private final List<String> vertexPropertyKeys;
    private final List<String> edgePropertyKeys;
    private final AtlasElementPropertyConfig.ElementPropertiesRule vertexPropertiesRule;
    private final AtlasElementPropertyConfig.ElementPropertiesRule edgePropertiesRule;
    private final boolean normalized;
    private final boolean includeReservedVertexId;
    private final boolean includeReservedEdgeId;
    private final boolean includeReservedVertexType;
    private final boolean includeReservedEdgeType;
    private final boolean includeReservedEdgeLabel;
    private final boolean includeReservedEdgeOutV;
    private final boolean includeReservedEdgeInV;

    private AtlasGraphSONUtility(AtlasGraphSONMode mode, Set<String> vertexPropertyKeySet, Set<String> edgePropertyKeySet) {
        AtlasElementPropertyConfig config = AtlasElementPropertyConfig.includeProperties(vertexPropertyKeySet, edgePropertyKeySet);
        this.vertexPropertyKeys = config.getVertexPropertyKeys();
        this.edgePropertyKeys = config.getEdgePropertyKeys();
        this.vertexPropertiesRule = config.getVertexPropertiesRule();
        this.edgePropertiesRule = config.getEdgePropertiesRule();
        this.normalized = config.isNormalized();
        this.mode = mode;
        this.includeReservedVertexId = AtlasGraphSONUtility.includeReservedKey(mode, "_id", this.vertexPropertyKeys, this.vertexPropertiesRule);
        this.includeReservedEdgeId = AtlasGraphSONUtility.includeReservedKey(mode, "_id", this.edgePropertyKeys, this.edgePropertiesRule);
        this.includeReservedVertexType = AtlasGraphSONUtility.includeReservedKey(mode, "_type", this.vertexPropertyKeys, this.vertexPropertiesRule);
        this.includeReservedEdgeType = AtlasGraphSONUtility.includeReservedKey(mode, "_type", this.edgePropertyKeys, this.edgePropertiesRule);
        this.includeReservedEdgeLabel = AtlasGraphSONUtility.includeReservedKey(mode, "_label", this.edgePropertyKeys, this.edgePropertiesRule);
        this.includeReservedEdgeOutV = AtlasGraphSONUtility.includeReservedKey(mode, "_outV", this.edgePropertyKeys, this.edgePropertiesRule);
        this.includeReservedEdgeInV = AtlasGraphSONUtility.includeReservedKey(mode, "_inV", this.edgePropertyKeys, this.edgePropertiesRule);
    }

    private JSONObject jsonFromElement(AtlasElement element) throws JSONException {
        ObjectNode objectNode = this.objectNodeFromElement(element);
        try {
            return new JSONObject(new JSONTokener(MAPPER.writeValueAsString((Object)objectNode)));
        }
        catch (IOException ioe) {
            throw new JSONException((Throwable)ioe);
        }
    }

    private ObjectNode objectNodeFromElement(AtlasElement element) {
        boolean isEdge = element instanceof AtlasEdge;
        boolean showTypes = this.mode == AtlasGraphSONMode.EXTENDED;
        List<String> propertyKeys = isEdge ? this.edgePropertyKeys : this.vertexPropertyKeys;
        AtlasElementPropertyConfig.ElementPropertiesRule elementPropertyConfig = isEdge ? this.edgePropertiesRule : this.vertexPropertiesRule;
        ObjectNode jsonElement = AtlasGraphSONUtility.createJSONMap(AtlasGraphSONUtility.createPropertyMap(element, propertyKeys, elementPropertyConfig, this.normalized), propertyKeys, showTypes);
        if (isEdge && this.includeReservedEdgeId || !isEdge && this.includeReservedVertexId) {
            AtlasGraphSONUtility.putObject(jsonElement, "_id", element.getId());
        }
        if (element instanceof AtlasEdge) {
            AtlasEdge edge = (AtlasEdge)element;
            if (this.includeReservedEdgeId) {
                AtlasGraphSONUtility.putObject(jsonElement, "_id", element.getId());
            }
            if (this.includeReservedEdgeType) {
                jsonElement.put("_type", "edge");
            }
            if (this.includeReservedEdgeOutV) {
                AtlasGraphSONUtility.putObject(jsonElement, "_outV", edge.getOutVertex().getId());
            }
            if (this.includeReservedEdgeInV) {
                AtlasGraphSONUtility.putObject(jsonElement, "_inV", edge.getInVertex().getId());
            }
            if (this.includeReservedEdgeLabel) {
                jsonElement.put("_label", edge.getLabel());
            }
        } else if (element instanceof AtlasVertex) {
            if (this.includeReservedVertexId) {
                AtlasGraphSONUtility.putObject(jsonElement, "_id", element.getId());
            }
            if (this.includeReservedVertexType) {
                jsonElement.put("_type", "vertex");
            }
        }
        return jsonElement;
    }

    public static JSONObject jsonFromElement(AtlasElement element, Set<String> propertyKeys, AtlasGraphSONMode mode) throws JSONException {
        AtlasGraphSONUtility graphson = element instanceof AtlasEdge ? new AtlasGraphSONUtility(mode, null, propertyKeys) : new AtlasGraphSONUtility(mode, propertyKeys, null);
        return graphson.jsonFromElement(element);
    }

    private static ObjectNode objectNodeFromElement(AtlasElement element, List<String> propertyKeys, AtlasGraphSONMode mode) {
        AtlasGraphSONUtility graphson = element instanceof AtlasEdge ? new AtlasGraphSONUtility(mode, null, new HashSet<String>(propertyKeys)) : new AtlasGraphSONUtility(mode, new HashSet<String>(propertyKeys), null);
        return graphson.objectNodeFromElement(element);
    }

    private static boolean includeReservedKey(AtlasGraphSONMode mode, String key, List<String> propertyKeys, AtlasElementPropertyConfig.ElementPropertiesRule rule) {
        return mode != AtlasGraphSONMode.COMPACT || AtlasGraphSONUtility.includeKey(key, propertyKeys, rule);
    }

    private static boolean includeKey(String key, List<String> propertyKeys, AtlasElementPropertyConfig.ElementPropertiesRule rule) {
        if (propertyKeys == null) {
            return true;
        }
        boolean keySituation = rule == AtlasElementPropertyConfig.ElementPropertiesRule.INCLUDE;
        switch (rule) {
            case INCLUDE: {
                keySituation = propertyKeys.contains(key);
                break;
            }
            case EXCLUDE: {
                keySituation = !propertyKeys.contains(key);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled rule: " + (Object)((Object)rule));
            }
        }
        return keySituation;
    }

    private static ArrayNode createJSONList(List<Object> list, List<String> propertyKeys, boolean showTypes) {
        ArrayNode jsonList = JSON_NODE_FACTORY.arrayNode();
        for (Object item : list) {
            if (item instanceof AtlasElement) {
                jsonList.add((JsonNode)AtlasGraphSONUtility.objectNodeFromElement((AtlasElement)item, propertyKeys, showTypes ? AtlasGraphSONMode.EXTENDED : AtlasGraphSONMode.NORMAL));
                continue;
            }
            if (item instanceof List) {
                jsonList.add((JsonNode)AtlasGraphSONUtility.createJSONList((List)item, propertyKeys, showTypes));
                continue;
            }
            if (item instanceof Map) {
                jsonList.add((JsonNode)AtlasGraphSONUtility.createJSONMap((Map)item, propertyKeys, showTypes));
                continue;
            }
            if (item != null && item.getClass().isArray()) {
                jsonList.add((JsonNode)AtlasGraphSONUtility.createJSONList(AtlasGraphSONUtility.convertArrayToList(item), propertyKeys, showTypes));
                continue;
            }
            AtlasGraphSONUtility.addObject(jsonList, item);
        }
        return jsonList;
    }

    private static ObjectNode createJSONMap(Map<String, Object> map, List<String> propertyKeys, boolean showTypes) {
        ObjectNode jsonMap = JSON_NODE_FACTORY.objectNode();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value != null) {
                if (value instanceof List) {
                    value = AtlasGraphSONUtility.createJSONList((List)value, propertyKeys, showTypes);
                } else if (value instanceof Map) {
                    value = AtlasGraphSONUtility.createJSONMap((Map)value, propertyKeys, showTypes);
                } else if (value instanceof AtlasElement) {
                    value = AtlasGraphSONUtility.objectNodeFromElement((AtlasElement)value, propertyKeys, showTypes ? AtlasGraphSONMode.EXTENDED : AtlasGraphSONMode.NORMAL);
                } else if (value.getClass().isArray()) {
                    value = AtlasGraphSONUtility.createJSONList(AtlasGraphSONUtility.convertArrayToList(value), propertyKeys, showTypes);
                }
            }
            AtlasGraphSONUtility.putObject(jsonMap, key.toString(), AtlasGraphSONUtility.getValue(value, showTypes));
        }
        return jsonMap;
    }

    private static void addObject(ArrayNode jsonList, Object value) {
        if (value == null) {
            jsonList.add((JsonNode)null);
        } else if (value.getClass() == Boolean.class) {
            jsonList.add((Boolean)value);
        } else if (value.getClass() == Long.class) {
            jsonList.add((Long)value);
        } else if (value.getClass() == Integer.class) {
            jsonList.add((Integer)value);
        } else if (value.getClass() == Float.class) {
            jsonList.add((Float)value);
        } else if (value.getClass() == Double.class) {
            jsonList.add((Double)value);
        } else if (value.getClass() == Byte.class) {
            jsonList.add((int)((Byte)value).byteValue());
        } else if (value.getClass() == Short.class) {
            jsonList.add((int)((Short)value).shortValue());
        } else if (value.getClass() == String.class) {
            jsonList.add((String)value);
        } else if (value instanceof ObjectNode) {
            jsonList.add((JsonNode)((ObjectNode)value));
        } else if (value instanceof ArrayNode) {
            jsonList.add((JsonNode)((ArrayNode)value));
        } else {
            jsonList.add(value.toString());
        }
    }

    private static void putObject(ObjectNode jsonMap, String key, Object value) {
        if (value == null) {
            jsonMap.put(key, (JsonNode)null);
        } else if (value.getClass() == Boolean.class) {
            jsonMap.put(key, (Boolean)value);
        } else if (value.getClass() == Long.class) {
            jsonMap.put(key, (Long)value);
        } else if (value.getClass() == Integer.class) {
            jsonMap.put(key, (Integer)value);
        } else if (value.getClass() == Float.class) {
            jsonMap.put(key, (Float)value);
        } else if (value.getClass() == Double.class) {
            jsonMap.put(key, (Double)value);
        } else if (value.getClass() == Short.class) {
            jsonMap.put(key, (Short)value);
        } else if (value.getClass() == Byte.class) {
            jsonMap.put(key, (short)((Byte)value).byteValue());
        } else if (value.getClass() == String.class) {
            jsonMap.put(key, (String)value);
        } else if (value instanceof ObjectNode) {
            jsonMap.put(key, (JsonNode)((ObjectNode)value));
        } else if (value instanceof ArrayNode) {
            jsonMap.put(key, (JsonNode)((ArrayNode)value));
        } else {
            jsonMap.put(key, value.toString());
        }
    }

    private static Map<String, Object> createPropertyMap(AtlasElement element, List<String> propertyKeys, AtlasElementPropertyConfig.ElementPropertiesRule rule, boolean normalized) {
        ArrayList propertyKeyList;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (normalized) {
            ArrayList sorted = new ArrayList(element.getPropertyKeys());
            Collections.sort(sorted);
            propertyKeyList = sorted;
        } else {
            propertyKeyList = new ArrayList(element.getPropertyKeys());
        }
        if (propertyKeys == null) {
            for (String key : propertyKeyList) {
                Object valToPutInMap = element.getProperty(key, Object.class);
                if (valToPutInMap == null) continue;
                map.put(key, valToPutInMap);
            }
        } else if (rule == AtlasElementPropertyConfig.ElementPropertiesRule.INCLUDE) {
            for (String key : propertyKeys) {
                Object valToPutInMap = element.getProperty(key, Object.class);
                if (valToPutInMap == null) continue;
                map.put(key, valToPutInMap);
            }
        } else {
            for (String key : propertyKeyList) {
                Object valToPutInMap;
                if (propertyKeys.contains(key) || (valToPutInMap = element.getProperty(key, Object.class)) == null) continue;
                map.put(key, valToPutInMap);
            }
        }
        return map;
    }

    private static Object getValue(Object value, boolean includeType) {
        Object returnValue = value;
        if (includeType) {
            String type = AtlasGraphSONUtility.determineType(value);
            ObjectNode valueAndType = JSON_NODE_FACTORY.objectNode();
            valueAndType.put("type", type);
            if (type.equals("list")) {
                ArrayNode list = (ArrayNode)value;
                ArrayNode valueArray = valueAndType.putArray("value");
                for (int ix = 0; ix < list.size(); ++ix) {
                    AtlasGraphSONUtility.addObject(valueArray, AtlasGraphSONUtility.getValue(AtlasGraphSONUtility.getTypedValueFromJsonNode(list.get(ix)), includeType));
                }
            } else if (type.equals("map")) {
                ObjectNode convertedMap = JSON_NODE_FACTORY.objectNode();
                ObjectNode jsonObject = (ObjectNode)value;
                Iterator keyIterator = jsonObject.fieldNames();
                while (keyIterator.hasNext()) {
                    Object key = keyIterator.next();
                    convertedMap.put(key.toString(), jsonObject.get(key.toString()));
                }
                valueAndType.put("value", (JsonNode)convertedMap);
            } else {
                AtlasGraphSONUtility.putObject(valueAndType, "value", value);
            }
            returnValue = valueAndType;
        }
        return returnValue;
    }

    private static Object getTypedValueFromJsonNode(JsonNode node) {
        Object theValue = null;
        if (node != null && !node.isNull()) {
            theValue = node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : (node.isDouble() ? Double.valueOf(node.doubleValue()) : (node.isFloatingPointNumber() ? Float.valueOf(node.floatValue()) : (node.isInt() ? Integer.valueOf(node.intValue()) : (node.isLong() ? Long.valueOf(node.longValue()) : (node.isTextual() ? node.textValue() : (node.isArray() ? node : (node.isObject() ? node : node.textValue())))))));
        }
        return theValue;
    }

    private static List<Object> convertArrayToList(Object value) {
        ArrayList<Object> list = new ArrayList<Object>();
        int arrlength = Array.getLength(value);
        for (int i = 0; i < arrlength; ++i) {
            Object object = Array.get(value, i);
            list.add(object);
        }
        return list;
    }

    private static String determineType(Object value) {
        String type = "string";
        if (value == null) {
            type = "unknown";
        } else if (value.getClass() == Double.class) {
            type = "double";
        } else if (value.getClass() == Float.class) {
            type = "float";
        } else if (value.getClass() == Byte.class) {
            type = "byte";
        } else if (value.getClass() == Short.class) {
            type = "short";
        } else if (value.getClass() == Integer.class) {
            type = "integer";
        } else if (value.getClass() == Long.class) {
            type = "long";
        } else if (value.getClass() == Boolean.class) {
            type = "boolean";
        } else if (value instanceof ArrayNode) {
            type = "list";
        } else if (value instanceof ObjectNode) {
            type = "map";
        }
        return type;
    }

    static class ElementFactory {
        ElementFactory() {
        }
    }
}

