/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.serializer;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.atlas.repository.graphdb.janus.serializer.BigIntegerSerializer;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;

public class BigDecimalSerializer
implements AttributeSerializer<BigDecimal> {
    private final BigIntegerSerializer bigIntegerDelegate = new BigIntegerSerializer();

    public BigDecimal read(ScanBuffer buffer) {
        BigInteger unscaledVal = this.bigIntegerDelegate.read(buffer);
        int scale = buffer.getInt();
        return new BigDecimal(unscaledVal, scale);
    }

    public void write(WriteBuffer buffer, BigDecimal attribute) {
        BigInteger unscaledVal = attribute.unscaledValue();
        int scale = attribute.scale();
        this.bigIntegerDelegate.write(buffer, unscaledVal);
        buffer.putInt(scale);
    }
}

