/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextSearchProcessor
extends SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FullTextSearchProcessor.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"FullTextSearchProcessor");
    private final AtlasIndexQuery indexQuery;

    public FullTextSearchProcessor(SearchContext context) {
        super(context);
        SearchParameters searchParameters = context.getSearchParameters();
        StringBuilder queryString = new StringBuilder();
        queryString.append(INDEX_SEARCH_PREFIX + "\"").append(Constants.ENTITY_TEXT_PROPERTY_KEY).append("\":(").append(searchParameters.getQuery());
        if (CollectionUtils.isNotEmpty(context.getEntityTypes())) {
            String typeAndSubTypeNamesQryStr = context.getEntityTypesQryStr();
            if (typeAndSubTypeNamesQryStr.length() <= MAX_QUERY_STR_LENGTH_TYPES) {
                queryString.append(" AND ").append(typeAndSubTypeNamesQryStr);
            } else {
                LOG.warn("'{}' has too many subtypes (query-string-length={}) to include in index-query; might cause poor performance", (Object)searchParameters.getTypeName(), (Object)typeAndSubTypeNamesQryStr.length());
            }
        }
        if (CollectionUtils.isNotEmpty(context.getClassificationTypes()) && context.getClassificationTypes().iterator().next() != SearchContext.MATCH_ALL_NOT_CLASSIFIED) {
            String typeAndSubTypeNamesStr = context.getClassificationTypesQryStr();
            if (typeAndSubTypeNamesStr.length() <= MAX_QUERY_STR_LENGTH_TAGS) {
                queryString.append(" AND ").append(typeAndSubTypeNamesStr);
            } else {
                LOG.warn("'{}' has too many subtypes (query-string-length={}) to include in index-query; might cause poor performance", (Object)searchParameters.getClassification(), (Object)typeAndSubTypeNamesStr.length());
            }
        }
        queryString.append(")");
        this.indexQuery = context.getGraph().indexQuery("fulltext_index", queryString.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AtlasVertex> execute() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> FullTextSearchProcessor.execute({})", (Object)this.context);
        }
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("FullTextSearchProcessor.execute(" + this.context + ")"));
        }
        try {
            int qryOffset;
            int limit = this.context.getSearchParameters().getLimit();
            boolean activeOnly = this.context.getSearchParameters().getExcludeDeletedEntities();
            Integer marker = this.context.getMarker();
            int startIdx = marker != null ? marker.intValue() : this.context.getSearchParameters().getOffset();
            int resultIdx = qryOffset = marker != null ? marker : 0;
            LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap = new LinkedHashMap<Integer, AtlasVertex>();
            while (ret.size() < limit) {
                offsetEntityVertexMap.clear();
                if (this.context.terminateSearch()) {
                    LOG.warn("query terminated: {}", (Object)this.context.getSearchParameters());
                    break;
                }
                Iterator idxQueryResult = this.indexQuery.vertices(qryOffset, limit);
                int resultCount = 0;
                while (idxQueryResult.hasNext()) {
                    AtlasVertex vertex = ((AtlasIndexQuery.Result)idxQueryResult.next()).getVertex();
                    ++resultCount;
                    if (!AtlasGraphUtilsV2.isEntityVertex(vertex)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("FullTextSearchProcessor.execute(): ignoring non-entity vertex (id={})", vertex.getId());
                        continue;
                    }
                    if (activeOnly && AtlasGraphUtilsV2.getState((AtlasElement)vertex) != AtlasEntity.Status.ACTIVE) continue;
                    offsetEntityVertexMap.put(qryOffset + resultCount - 1, vertex);
                }
                boolean isLastResultPage = resultCount < limit;
                offsetEntityVertexMap = super.filter(offsetEntityVertexMap);
                resultIdx = this.collectResultVertices(ret, startIdx, limit, resultIdx, offsetEntityVertexMap, marker);
                if (isLastResultPage) {
                    resultIdx = -2;
                    break;
                }
                qryOffset += limit;
            }
            if (marker != null) {
                this.nextOffset = resultIdx + 1;
            }
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== FullTextSearchProcessor.execute({}): ret.size()={}", (Object)this.context, (Object)ret.size());
        }
        return ret;
    }

    @Override
    public long getResultCount() {
        return this.indexQuery.vertexTotals();
    }
}

