/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.discovery.ClassificationSearchProcessor;
import org.apache.atlas.discovery.EntitySearchProcessor;
import org.apache.atlas.discovery.FreeTextSearchProcessor;
import org.apache.atlas.discovery.FullTextSearchProcessor;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.discovery.TermSearchProcessor;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasRepositoryConfiguration;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchContext {
    private static final Logger LOG = LoggerFactory.getLogger(SearchContext.class);
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasGraph graph;
    private final Set<AtlasEntityType> entityTypes;
    private final Set<String> indexedKeys;
    private final Set<String> entityAttributes;
    private final SearchParameters searchParameters;
    private final Set<AtlasClassificationType> classificationTypes;
    private final Set<String> classificationNames;
    private final Set<String> typeAndSubTypes;
    private final Set<String> classificationTypeAndSubTypes;
    private final String typeAndSubTypesQryStr;
    private final String classificationTypeAndSubTypesQryStr;
    private boolean terminateSearch = false;
    private SearchProcessor searchProcessor;
    private Integer marker;
    public static final AtlasClassificationType MATCH_ALL_WILDCARD_CLASSIFICATION = new AtlasClassificationType(new AtlasClassificationDef("*"));
    public static final AtlasClassificationType MATCH_ALL_CLASSIFIED = new AtlasClassificationType(new AtlasClassificationDef("_CLASSIFIED"));
    public static final AtlasClassificationType MATCH_ALL_NOT_CLASSIFIED = new AtlasClassificationType(new AtlasClassificationDef("_NOT_CLASSIFIED"));
    public static final AtlasClassificationType MATCH_ALL_CLASSIFICATION_TYPES = AtlasClassificationType.getClassificationRoot();
    public static final AtlasEntityType MATCH_ALL_ENTITY_TYPES = AtlasEntityType.getEntityRoot();
    public static final String TYPENAME_DELIMITER = ",";

    public SearchContext(SearchParameters searchParameters, AtlasTypeRegistry typeRegistry, AtlasGraph graph, Set<String> indexedKeys) throws AtlasBaseException {
        this.searchParameters = searchParameters;
        this.typeRegistry = typeRegistry;
        this.graph = graph;
        this.indexedKeys = indexedKeys;
        this.entityAttributes = new HashSet<String>();
        this.entityTypes = this.getEntityTypes(searchParameters.getTypeName());
        this.classificationNames = this.getClassificationNames(searchParameters.getClassification());
        this.classificationTypes = this.getClassificationTypes(this.classificationNames);
        AtlasVertex glossaryTermVertex = this.getGlossaryTermVertex(searchParameters.getTermName());
        if (StringUtils.isNotEmpty((CharSequence)searchParameters.getTermName()) && glossaryTermVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_GLOSSARY_TERM, new String[]{searchParameters.getTermName()});
        }
        if (CollectionUtils.isNotEmpty(this.entityTypes)) {
            for (AtlasEntityType entityType : this.entityTypes) {
                this.validateAttributes((AtlasStructType)entityType, searchParameters.getEntityFilters());
                this.validateAttributes((AtlasStructType)entityType, searchParameters.getSortBy());
            }
        }
        if (CollectionUtils.isNotEmpty(this.classificationNames) && this.hasAttributeFilter(searchParameters.getTagFilters())) {
            for (String classificationName : this.classificationNames) {
                if (!classificationName.contains("*") || classificationName.equals("*")) continue;
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"TagFilters specified with wildcard tag name"});
            }
        }
        if (CollectionUtils.isNotEmpty(this.classificationTypes)) {
            for (AtlasClassificationType classificationType : this.classificationTypes) {
                this.validateAttributes((AtlasStructType)classificationType, searchParameters.getTagFilters());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)searchParameters.getMarker())) {
            this.marker = MarkerUtil.decodeMarker(searchParameters);
        }
        this.filterStructTypes();
        Set<Object> classificationTypeAndSubTypes = new HashSet();
        String classificationTypeAndSubTypesQryStr = null;
        if (CollectionUtils.isNotEmpty(this.classificationTypes) && this.classificationTypes.iterator().next() != MATCH_ALL_NOT_CLASSIFIED) {
            for (AtlasClassificationType classificationType : this.classificationTypes) {
                if (classificationType == MATCH_ALL_CLASSIFICATION_TYPES) {
                    classificationTypeAndSubTypes = Collections.emptySet();
                    classificationTypeAndSubTypesQryStr = "[* TO *]";
                    break;
                }
                Set<String> allTypes = searchParameters.getIncludeSubClassifications() ? classificationType.getTypeAndAllSubTypes() : Collections.singleton(classificationType.getTypeName());
                classificationTypeAndSubTypes.addAll(allTypes);
            }
            if (CollectionUtils.isNotEmpty(classificationTypeAndSubTypes)) {
                classificationTypeAndSubTypesQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(classificationTypeAndSubTypes, (boolean)true);
            }
        } else {
            classificationTypeAndSubTypes = Collections.emptySet();
            classificationTypeAndSubTypesQryStr = "";
        }
        this.classificationTypeAndSubTypes = classificationTypeAndSubTypes;
        this.classificationTypeAndSubTypesQryStr = classificationTypeAndSubTypesQryStr;
        Set<Object> typeAndSubTypes = new HashSet();
        String typeAndSubTypesQryStr = null;
        if (CollectionUtils.isNotEmpty(this.entityTypes)) {
            for (AtlasEntityType entityType : this.entityTypes) {
                if (entityType.equals(MATCH_ALL_ENTITY_TYPES)) {
                    typeAndSubTypes = Collections.emptySet();
                    typeAndSubTypesQryStr = "[* TO *]";
                    break;
                }
                Set<String> allTypes = searchParameters.getIncludeSubTypes() ? entityType.getTypeAndAllSubTypes() : Collections.singleton(entityType.getTypeName());
                typeAndSubTypes.addAll(allTypes);
            }
            if (CollectionUtils.isNotEmpty(typeAndSubTypes)) {
                typeAndSubTypesQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(typeAndSubTypes, (boolean)true);
            }
        } else {
            typeAndSubTypes = Collections.emptySet();
            typeAndSubTypesQryStr = "";
        }
        this.typeAndSubTypes = typeAndSubTypes;
        this.typeAndSubTypesQryStr = typeAndSubTypesQryStr;
        if (glossaryTermVertex != null) {
            this.addProcessor(new TermSearchProcessor(this, this.getAssignedEntities(glossaryTermVertex)));
        }
        if (this.needFullTextProcessor()) {
            if (AtlasRepositoryConfiguration.isFreeTextSearchEnabled()) {
                LOG.debug("Using Free Text index based search.");
                this.addProcessor(new FreeTextSearchProcessor(this));
            } else {
                LOG.debug("Using Full Text index based search.");
                this.addProcessor(new FullTextSearchProcessor(this));
            }
        }
        if (this.needClassificationProcessor()) {
            this.addProcessor(new ClassificationSearchProcessor(this));
        }
        if (this.needEntityProcessor()) {
            this.addProcessor(new EntitySearchProcessor(this));
        }
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public AtlasTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public AtlasGraph getGraph() {
        return this.graph;
    }

    public Set<String> getIndexedKeys() {
        return this.indexedKeys;
    }

    public Set<String> getEntityAttributes() {
        return this.entityAttributes;
    }

    public Set<AtlasClassificationType> getClassificationTypes() {
        return this.classificationTypes;
    }

    public Set<String> getEntityTypeNames() {
        return this.typeAndSubTypes;
    }

    public Set<String> getClassificationTypeNames() {
        return this.classificationTypeAndSubTypes;
    }

    public String getEntityTypesQryStr() {
        return this.typeAndSubTypesQryStr;
    }

    public String getClassificationTypesQryStr() {
        return this.classificationTypeAndSubTypesQryStr;
    }

    public Set<AtlasEntityType> getEntityTypes() {
        return this.entityTypes;
    }

    public SearchProcessor getSearchProcessor() {
        return this.searchProcessor;
    }

    public Set<String> getClassificationNames() {
        return this.classificationNames;
    }

    public Integer getMarker() {
        return this.marker;
    }

    public boolean includeEntityType(String entityType) {
        return this.typeAndSubTypes.isEmpty() || this.typeAndSubTypes.contains(entityType);
    }

    public boolean includeClassificationTypes(Collection<String> traitNames) {
        boolean ret = this.classificationTypes.iterator().next() == MATCH_ALL_NOT_CLASSIFIED ? CollectionUtils.isEmpty(traitNames) : (this.classificationTypes.iterator().next() == MATCH_ALL_CLASSIFICATION_TYPES ? CollectionUtils.isNotEmpty(traitNames) : CollectionUtils.containsAny(this.classificationTypeAndSubTypes, traitNames));
        return ret;
    }

    public boolean terminateSearch() {
        return this.terminateSearch;
    }

    public void terminateSearch(boolean terminateSearch) {
        this.terminateSearch = terminateSearch;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("searchParameters=");
        if (this.searchParameters != null) {
            this.searchParameters.toString(sb);
        }
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    boolean needFullTextProcessor() {
        return StringUtils.isNotEmpty((CharSequence)this.searchParameters.getQuery());
    }

    boolean needClassificationProcessor() {
        return CollectionUtils.isNotEmpty(this.classificationTypes) && (CollectionUtils.isEmpty(this.entityTypes) || this.hasAttributeFilter(this.searchParameters.getTagFilters())) || this.isWildCardSearch();
    }

    boolean isWildCardSearch() {
        if (CollectionUtils.isNotEmpty(this.classificationNames)) {
            return this.classificationNames.stream().anyMatch(classification -> classification.contains("*"));
        }
        return false;
    }

    boolean needEntityProcessor() {
        return CollectionUtils.isNotEmpty(this.entityTypes);
    }

    private void validateAttributes(AtlasStructType structType, SearchParameters.FilterCriteria filterCriteria) throws AtlasBaseException {
        if (filterCriteria != null) {
            SearchParameters.FilterCriteria.Condition condition = filterCriteria.getCondition();
            if (condition != null && CollectionUtils.isNotEmpty((Collection)filterCriteria.getCriterion())) {
                for (SearchParameters.FilterCriteria criteria : filterCriteria.getCriterion()) {
                    this.validateAttributes(structType, criteria);
                }
            } else {
                String attributeName = filterCriteria.getAttributeName();
                this.validateAttributes(structType, attributeName);
            }
        }
    }

    private void validateAttributes(AtlasStructType structType, String ... attributeNames) throws AtlasBaseException {
        for (String attributeName : attributeNames) {
            if (!StringUtils.isNotEmpty((CharSequence)attributeName) || structType != null && structType.getAttributeType(attributeName) != null) continue;
            if (structType == null) {
                throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[]{"NULL"});
            }
            String name = structType.getTypeName();
            if (name.equals(MATCH_ALL_ENTITY_TYPES.getTypeName())) {
                name = "_ALL_ENTITY_TYPES";
            } else if (name.equals(MATCH_ALL_CLASSIFICATION_TYPES.getTypeName())) {
                name = "_ALL_CLASSIFICATION_TYPES";
            }
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, new String[]{attributeName, name});
        }
    }

    public boolean hasAttributeFilter(SearchParameters.FilterCriteria filterCriteria) {
        return filterCriteria != null && (CollectionUtils.isNotEmpty((Collection)filterCriteria.getCriterion()) || StringUtils.isNotEmpty((CharSequence)filterCriteria.getAttributeName()));
    }

    private void addProcessor(SearchProcessor processor) {
        if (this.searchProcessor == null) {
            this.searchProcessor = processor;
        } else {
            this.searchProcessor.addProcessor(processor);
        }
    }

    private AtlasClassificationType getClassificationType(String classificationName) {
        AtlasClassificationType ret = StringUtils.equals((CharSequence)classificationName, (CharSequence)MATCH_ALL_WILDCARD_CLASSIFICATION.getTypeName()) ? MATCH_ALL_WILDCARD_CLASSIFICATION : (StringUtils.equals((CharSequence)classificationName, (CharSequence)MATCH_ALL_CLASSIFIED.getTypeName()) ? MATCH_ALL_CLASSIFIED : (StringUtils.equals((CharSequence)classificationName, (CharSequence)MATCH_ALL_NOT_CLASSIFIED.getTypeName()) ? MATCH_ALL_NOT_CLASSIFIED : (StringUtils.equals((CharSequence)classificationName, (CharSequence)"_ALL_CLASSIFICATION_TYPES") ? MATCH_ALL_CLASSIFICATION_TYPES : this.typeRegistry.getClassificationTypeByName(classificationName))));
        return ret;
    }

    private Set<AtlasClassificationType> getClassificationTypes(Set<String> classificationNames) {
        if (CollectionUtils.isNotEmpty(classificationNames)) {
            return classificationNames.stream().map(n -> this.getClassificationType((String)n)).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return null;
    }

    private Set<String> getClassificationNames(String classification) throws AtlasBaseException {
        HashSet<String> classificationNames = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)classification)) {
            String[] types = classification.split(TYPENAME_DELIMITER);
            HashSet<String> names = new HashSet<String>(Arrays.asList(types));
            names.forEach(name -> {
                AtlasClassificationType type = this.getClassificationType((String)name);
                if (type != null || name.contains("*")) {
                    classificationNames.add((String)name);
                }
            });
            if (CollectionUtils.isEmpty(classificationNames)) {
                throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_CLASSIFICATION, new String[]{classification});
            }
            if (classificationNames.size() != names.size()) {
                names.removeAll(classificationNames);
                LOG.info("Could not search for {} , invalid classifications", (Object)String.join((CharSequence)TYPENAME_DELIMITER, names));
            }
        }
        return classificationNames;
    }

    private AtlasEntityType getEntityType(String entityName) {
        return StringUtils.equals((CharSequence)entityName, (CharSequence)"_ALL_ENTITY_TYPES") ? MATCH_ALL_ENTITY_TYPES : this.typeRegistry.getEntityTypeByName(entityName);
    }

    private Set<AtlasEntityType> getEntityTypes(String typeName) throws AtlasBaseException {
        Set entityTypes = null;
        if (StringUtils.isNotEmpty((CharSequence)typeName)) {
            String[] types = typeName.split(TYPENAME_DELIMITER);
            HashSet<String> typeNames = new HashSet<String>(Arrays.asList(types));
            entityTypes = typeNames.stream().map(n -> this.getEntityType((String)n)).filter(Objects::nonNull).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(entityTypes)) {
                throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[]{typeName});
            }
            if (entityTypes.size() != typeNames.size()) {
                HashSet<String> validEntityTypes = new HashSet<String>();
                for (AtlasEntityType entityType : entityTypes) {
                    String name = entityType.getTypeName();
                    if (name.equals(MATCH_ALL_ENTITY_TYPES.getTypeName())) {
                        validEntityTypes.add("_ALL_ENTITY_TYPES");
                        continue;
                    }
                    validEntityTypes.add(entityType.getTypeName());
                }
                typeNames.removeAll(validEntityTypes);
                LOG.info("Could not search for {} , invalid typeNames", (Object)String.join((CharSequence)TYPENAME_DELIMITER, typeNames));
            }
        }
        return entityTypes;
    }

    private void filterStructTypes() {
        if (CollectionUtils.isNotEmpty(this.entityTypes) && this.entityTypes.contains(MATCH_ALL_ENTITY_TYPES)) {
            this.entityTypes.clear();
            this.entityTypes.add(MATCH_ALL_ENTITY_TYPES);
        }
        if (CollectionUtils.isNotEmpty(this.classificationTypes)) {
            if (this.classificationTypes.contains(MATCH_ALL_NOT_CLASSIFIED)) {
                this.classificationTypes.clear();
                this.classificationTypes.add(MATCH_ALL_NOT_CLASSIFIED);
                this.classificationNames.clear();
                this.classificationNames.add(MATCH_ALL_NOT_CLASSIFIED.getTypeName());
            } else if (this.classificationTypes.contains(MATCH_ALL_WILDCARD_CLASSIFICATION) || this.classificationTypes.contains(MATCH_ALL_CLASSIFICATION_TYPES) || this.classificationTypes.contains(MATCH_ALL_CLASSIFIED)) {
                this.classificationTypes.clear();
                this.classificationTypes.add(MATCH_ALL_CLASSIFICATION_TYPES);
                this.classificationNames.clear();
                this.classificationNames.add("_ALL_CLASSIFICATION_TYPES");
            }
        }
    }

    private AtlasVertex getGlossaryTermVertex(String termName) {
        AtlasVertex ret = null;
        if (StringUtils.isNotEmpty((CharSequence)termName)) {
            AtlasEntityType termType = this.getTermEntityType();
            AtlasStructType.AtlasAttribute attrName = termType.getAttribute("qualifiedName");
            AtlasGraphQuery query = this.graph.query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)termType.getTypeName()).has(attrName.getVertexPropertyName(), (Object)termName).has(Constants.STATE_PROPERTY_KEY, (Object)AtlasEntity.Status.ACTIVE.name());
            Iterator results = query.vertices().iterator();
            ret = results.hasNext() ? (AtlasVertex)results.next() : null;
        }
        return ret;
    }

    private List<AtlasVertex> getAssignedEntities(AtlasVertex glossaryTerm) {
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        AtlasEntityType termType = this.getTermEntityType();
        AtlasStructType.AtlasAttribute attr = termType.getRelationshipAttribute("assignedEntities", "AtlasGlossarySemanticAssignment");
        Iterator<AtlasEdge> edges = GraphHelper.getEdgesForLabel(glossaryTerm, attr.getRelationshipEdgeLabel(), attr.getRelationshipEdgeDirection());
        boolean excludeDeletedEntities = this.searchParameters.getExcludeDeletedEntities();
        if (edges != null) {
            while (edges.hasNext()) {
                AtlasEdge edge = edges.next();
                AtlasVertex inVertex = edge.getInVertex();
                if (excludeDeletedEntities && AtlasGraphUtilsV2.getState((AtlasElement)inVertex) == AtlasEntity.Status.DELETED) continue;
                ret.add(inVertex);
            }
        }
        return ret;
    }

    private AtlasEntityType getTermEntityType() {
        return this.typeRegistry.getEntityTypeByName("AtlasGlossaryTerm");
    }

    public static class MarkerUtil {
        private static final int IDX_HASH_CODE = 0;
        private static final int IDX_OFFSET = 1;
        private static final String MARKER_DELIMITER = ":";
        @VisibleForTesting
        static final String MARKER_START = "*";
        @VisibleForTesting
        static final int MARKER_END = -1;

        public static String getNextEncMarker(SearchParameters searchParameters, Integer nextOffset) {
            if (nextOffset == null) {
                return null;
            }
            if (nextOffset == -1) {
                return String.valueOf(nextOffset);
            }
            String value = searchParameters.hashCode() + MARKER_DELIMITER + nextOffset;
            return Base64.getEncoder().encodeToString(value.getBytes());
        }

        public static Integer decodeMarker(SearchParameters searchParameters) throws AtlasBaseException {
            if (searchParameters == null || searchParameters.getOffset() > 0) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Marker can be used only if offset=0."});
            }
            String encodedMarker = searchParameters.getMarker();
            if (StringUtils.equals((CharSequence)encodedMarker, (CharSequence)MARKER_START)) {
                return 0;
            }
            try {
                int currentHashCode;
                byte[] inputMarkerBytes = Base64.getDecoder().decode(encodedMarker);
                String inputMarker = new String(inputMarkerBytes);
                if (StringUtils.isEmpty((CharSequence)inputMarker) || !inputMarker.contains(MARKER_DELIMITER)) {
                    throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Invalid marker found! Marker does not contain delimiter: :"});
                }
                String[] str = inputMarker.split(MARKER_DELIMITER);
                if (str == null || str.length != 2) {
                    throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Invalid marker found! Decoding using delimiter did not yield correct result!"});
                }
                int hashCode = Integer.parseInt(str[0]);
                if (hashCode == (currentHashCode = searchParameters.hashCode()) && Integer.parseInt(str[1]) >= 0) {
                    return Integer.parseInt(str[1]);
                }
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Invalid Marker! Parsing resulted in error."});
            }
            catch (Exception e) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Invalid marker!"});
            }
        }
    }
}

