/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query.executors;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.query.GremlinQuery;
import org.apache.atlas.query.SelectClauseComposer;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectClauseProjections {
    private static final Logger LOG = LoggerFactory.getLogger(SelectClauseProjections.class);

    public static AtlasSearchResult usingList(GremlinQuery queryInfo, EntityGraphRetriever entityRetriever, Collection<AtlasVertex> resultList) throws AtlasBaseException {
        AtlasSearchResult ret = new AtlasSearchResult();
        SelectClauseComposer selectClauseInfo = queryInfo.getSelectComposer();
        AtlasSearchResult.AttributeSearchResult attributeSearchResult = new AtlasSearchResult.AttributeSearchResult();
        attributeSearchResult.setName(Arrays.stream(selectClauseInfo.getLabels()).collect(Collectors.toList()));
        Collection<List<Object>> values = SelectClauseProjections.getProjectionRows(resultList, selectClauseInfo, entityRetriever);
        if (values instanceof List) {
            attributeSearchResult.setValues((List)values);
        } else if (values instanceof Set) {
            attributeSearchResult.setValues(new ArrayList<List<Object>>(values));
        }
        ret.setAttributes(attributeSearchResult);
        return ret;
    }

    public static AtlasSearchResult usingMap(GremlinQuery gremlinQuery, EntityGraphRetriever entityRetriever, Map<String, Collection<AtlasVertex>> resultMap) throws AtlasBaseException {
        AtlasSearchResult ret = new AtlasSearchResult();
        SelectClauseComposer selectClauseInfo = gremlinQuery.getSelectComposer();
        AtlasSearchResult.AttributeSearchResult attributeSearchResult = new AtlasSearchResult.AttributeSearchResult();
        attributeSearchResult.setName(Arrays.stream(selectClauseInfo.getLabels()).collect(Collectors.toList()));
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        for (Collection<AtlasVertex> value : resultMap.values()) {
            Collection<List<Object>> projectionRows = SelectClauseProjections.getProjectionRows(value, selectClauseInfo, entityRetriever);
            values.addAll(projectionRows);
        }
        attributeSearchResult.setValues(SelectClauseProjections.getSublistForGroupBy(gremlinQuery, values));
        ret.setAttributes(attributeSearchResult);
        return ret;
    }

    private static List<List<Object>> getSublistForGroupBy(GremlinQuery gremlinQuery, List<List<Object>> values) {
        int startIndex = gremlinQuery.getQueryMetadata().getResolvedOffset() - 1;
        if (startIndex < 0) {
            startIndex = 0;
        }
        int endIndex = startIndex + gremlinQuery.getQueryMetadata().getResolvedLimit();
        if (startIndex >= values.size()) {
            endIndex = 0;
            startIndex = 0;
        }
        if (endIndex >= values.size()) {
            endIndex = values.size();
        }
        return values.subList(startIndex, endIndex);
    }

    private static Collection<List<Object>> getProjectionRows(Collection<AtlasVertex> vertices, SelectClauseComposer selectClauseComposer, EntityGraphRetriever entityRetriever) throws AtlasBaseException {
        HashSet<List<Object>> values = new HashSet<List<Object>>();
        for (AtlasVertex vertex : vertices) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int idx = 0; idx < selectClauseComposer.getLabels().length; ++idx) {
                if (selectClauseComposer.isMinIdx(idx)) {
                    row.add(SelectClauseProjections.computeMin(vertices, selectClauseComposer, idx));
                    continue;
                }
                if (selectClauseComposer.isMaxIdx(idx)) {
                    row.add(SelectClauseProjections.computeMax(vertices, selectClauseComposer, idx));
                    continue;
                }
                if (selectClauseComposer.isCountIdx(idx)) {
                    row.add(vertices.size());
                    continue;
                }
                if (selectClauseComposer.isSumIdx(idx)) {
                    row.add(SelectClauseProjections.computeSum(vertices, selectClauseComposer, idx));
                    continue;
                }
                if (selectClauseComposer.isPrimitiveAttribute(idx)) {
                    String propertyName = selectClauseComposer.getAttribute(idx);
                    Object value = vertex.getProperty(propertyName, Object.class);
                    row.add(value != null ? value : "");
                    continue;
                }
                row.add(entityRetriever.toAtlasEntityHeaderWithClassifications(vertex));
            }
            values.add(row);
        }
        return values;
    }

    private static Number computeSum(Collection<AtlasVertex> vertices, SelectClauseComposer selectClauseComposer, int idx) {
        if (!selectClauseComposer.isNumericAggregator(idx)) {
            return 0;
        }
        String propertyName = selectClauseComposer.getAttribute(idx);
        double sum = 0.0;
        for (AtlasVertex vertex : vertices) {
            Number value = (Number)vertex.getProperty(propertyName, Number.class);
            if (value != null) {
                sum += value.doubleValue();
                continue;
            }
            LOG.warn("Property: {} for vertex: {} not found!", (Object)propertyName, vertex.getId());
        }
        return sum;
    }

    private static Object computeMax(Collection<AtlasVertex> vertices, SelectClauseComposer selectClauseComposer, int idx) {
        String propertyName = selectClauseComposer.getAttribute(idx);
        if (selectClauseComposer.isNumericAggregator(idx)) {
            AtlasVertex maxV = Collections.max(vertices, new VertexPropertyComparator(propertyName));
            return maxV.getProperty(propertyName, Object.class);
        }
        return Collections.max(vertices.stream().map(v -> (String)v.getProperty(propertyName, String.class)).filter(Objects::nonNull).collect(Collectors.toList()), String.CASE_INSENSITIVE_ORDER);
    }

    private static Object computeMin(Collection<AtlasVertex> vertices, SelectClauseComposer selectClauseComposer, int idx) {
        String propertyName = selectClauseComposer.getAttribute(idx);
        if (selectClauseComposer.isNumericAggregator(idx)) {
            AtlasVertex minV = Collections.min(vertices, new VertexPropertyComparator(propertyName));
            return minV.getProperty(propertyName, Object.class);
        }
        return Collections.min(vertices.stream().map(v -> (String)v.getProperty(propertyName, String.class)).filter(Objects::nonNull).collect(Collectors.toList()), String.CASE_INSENSITIVE_ORDER);
    }

    static class VertexPropertyComparator
    implements Comparator<AtlasVertex> {
        private String propertyName;

        public VertexPropertyComparator(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public int compare(AtlasVertex o1, AtlasVertex o2) {
            Object p2;
            Object p1 = o1 == null ? null : o1.getProperty(this.propertyName, Object.class);
            Object object = p2 = o2 == null ? null : o2.getProperty(this.propertyName, Object.class);
            if (p1 == null && p2 == null) {
                return 0;
            }
            if (p1 == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            if (p1 instanceof String) {
                return p2 instanceof String ? ((String)p1).compareTo((String)p2) : 0;
            }
            if (p1 instanceof Integer) {
                return p2 instanceof Integer ? ((Integer)p1).compareTo((Integer)p2) : 0;
            }
            if (p1 instanceof Long) {
                return p2 instanceof Long ? ((Long)p1).compareTo((Long)p2) : 0;
            }
            if (p1 instanceof Short) {
                return p2 instanceof Short ? ((Short)p1).compareTo((Short)p2) : 0;
            }
            if (p1 instanceof Float) {
                return p2 instanceof Float ? ((Float)p1).compareTo((Float)p2) : 0;
            }
            if (p1 instanceof Double) {
                return p2 instanceof Double ? ((Double)p1).compareTo((Double)p2) : 0;
            }
            if (p1 instanceof Byte) {
                return p2 instanceof Byte ? ((Byte)p1).compareTo((Byte)p2) : 0;
            }
            if (p1 instanceof BigInteger) {
                return p2 instanceof BigInteger ? ((BigInteger)p1).compareTo((BigInteger)p2) : 0;
            }
            if (p1 instanceof BigDecimal) {
                return p2 instanceof BigDecimal ? ((BigDecimal)p1).compareTo((BigDecimal)p2) : 0;
            }
            return 0;
        }
    }
}

