/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.impexp.ImportTransformer;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTransforms {
    private static final Logger LOG = LoggerFactory.getLogger(ImportTransforms.class);
    private static final String ALL_ATTRIBUTES = "*";
    private Map<String, Map<String, List<ImportTransformer>>> transforms = new HashMap<String, Map<String, List<ImportTransformer>>>();

    public static ImportTransforms fromJson(String jsonString) {
        if (StringUtils.isEmpty((String)jsonString)) {
            return null;
        }
        return new ImportTransforms(jsonString);
    }

    public Map<String, Map<String, List<ImportTransformer>>> getTransforms() {
        return this.transforms;
    }

    public Map<String, List<ImportTransformer>> getTransforms(String typeName) {
        return this.transforms.get(typeName);
    }

    public Set<String> getTypes() {
        return this.getTransforms().keySet();
    }

    public void addParentTransformsToSubTypes(String parentType, Set<String> subTypes) {
        Map<String, List<ImportTransformer>> attribtueTransformMap = this.getTransforms().get(parentType);
        for (String subType : subTypes) {
            if (!this.getTransforms().containsKey(subType)) {
                this.getTransforms().put(subType, attribtueTransformMap);
                continue;
            }
            for (Map.Entry<String, List<ImportTransformer>> entry : attribtueTransformMap.entrySet()) {
                if (this.getTransforms().get(subType).containsKey(entry.getKey())) {
                    this.getTransforms().get(subType).get(entry.getKey()).addAll((Collection<ImportTransformer>)entry.getValue());
                    continue;
                }
                LOG.warn("Attribute {} does not exist for Type : {}", (Object)entry.getKey(), (Object)parentType);
            }
        }
    }

    public AtlasEntity.AtlasEntityWithExtInfo apply(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) throws AtlasBaseException {
        if (entityWithExtInfo == null) {
            return entityWithExtInfo;
        }
        this.apply(entityWithExtInfo.getEntity());
        if (MapUtils.isNotEmpty((Map)entityWithExtInfo.getReferredEntities())) {
            for (AtlasEntity e : entityWithExtInfo.getReferredEntities().values()) {
                this.apply(e);
            }
        }
        return entityWithExtInfo;
    }

    public AtlasEntity apply(AtlasEntity entity) throws AtlasBaseException {
        if (entity == null) {
            return entity;
        }
        Map<String, List<ImportTransformer>> entityTransforms = this.getTransforms(entity.getTypeName());
        if (MapUtils.isEmpty(entityTransforms)) {
            return entity;
        }
        this.applyEntitySpecific(entity, entityTransforms);
        this.applyAttributeSpecific(entity, entityTransforms);
        return entity;
    }

    private void applyAttributeSpecific(AtlasEntity entity, Map<String, List<ImportTransformer>> entityTransforms) throws AtlasBaseException {
        for (Map.Entry<String, List<ImportTransformer>> entry : entityTransforms.entrySet()) {
            String attributeName = entry.getKey();
            List<ImportTransformer> attrTransforms = entry.getValue();
            if (!entity.hasAttribute(attributeName)) continue;
            Object attributeValue = entity.getAttribute(attributeName);
            for (ImportTransformer attrTransform : attrTransforms) {
                attributeValue = attrTransform.apply(attributeValue);
            }
            entity.setAttribute(attributeName, attributeValue);
        }
    }

    private void applyEntitySpecific(AtlasEntity entity, Map<String, List<ImportTransformer>> entityTransforms) throws AtlasBaseException {
        if (entityTransforms.containsKey(ALL_ATTRIBUTES)) {
            for (ImportTransformer attrTransform : entityTransforms.get(ALL_ATTRIBUTES)) {
                attrTransform.apply(entity);
            }
        }
    }

    private ImportTransforms() {
    }

    private ImportTransforms(String jsonString) {
        this();
        if (StringUtils.isEmpty((String)jsonString)) {
            return;
        }
        Map typeTransforms = (Map)AtlasType.fromJson((String)jsonString, Map.class);
        if (MapUtils.isEmpty((Map)typeTransforms)) {
            return;
        }
        this.addOuterMap(typeTransforms);
    }

    private void addOuterMap(Map typeTransforms) {
        for (Object key : typeTransforms.keySet()) {
            Object value = typeTransforms.get(key);
            String entityType = (String)key;
            Map attributeTransforms = (Map)value;
            if (MapUtils.isEmpty((Map)attributeTransforms)) continue;
            this.addInnerMap(entityType, attributeTransforms);
        }
    }

    private void addInnerMap(String entityType, Map<String, Object> attributeTransforms) {
        for (Map.Entry<String, Object> e : attributeTransforms.entrySet()) {
            String attributeName = e.getKey();
            List transforms = (List)e.getValue();
            if (CollectionUtils.isEmpty((Collection)transforms)) continue;
            this.addTransforms(entityType, attributeName, transforms);
        }
    }

    private void addTransforms(String entityType, String attributeName, List<String> transforms) {
        for (String transform : transforms) {
            ImportTransformer transformers = null;
            try {
                transformers = ImportTransformer.getTransformer(transform);
                if (transformers == null) continue;
                this.add(entityType, attributeName, transformers);
            }
            catch (AtlasBaseException ex) {
                LOG.error("Error converting string to ImportTransformer: {}", (Object)transform, (Object)ex);
            }
        }
    }

    private void add(String typeName, String attributeName, ImportTransformer transformer) {
        Map<Object, Object> attrMap;
        if (!this.transforms.containsKey(typeName)) {
            attrMap = new HashMap();
            this.transforms.put(typeName, attrMap);
        }
        if (!(attrMap = this.transforms.get(typeName)).containsKey(attributeName)) {
            attrMap.put(attributeName, new ArrayList());
        }
        ((List)attrMap.get(attributeName)).add(transformer);
    }
}

