/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.impexp.ZipExportFileNames;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSink {
    private static final Logger LOG = LoggerFactory.getLogger(ZipSink.class);
    private static String FILE_EXTENSION_JSON = ".json";
    private ZipOutputStream zipOutputStream;
    final Set<String> guids = new HashSet<String>();

    public ZipSink(OutputStream outputStream) {
        this.zipOutputStream = new ZipOutputStream(outputStream);
    }

    public void add(AtlasEntity entity) throws AtlasBaseException {
        String jsonData = this.convertToJSON(entity);
        this.saveToZip(entity.getGuid(), jsonData);
        this.recordAddedEntityGuids(entity);
    }

    public void add(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) throws AtlasBaseException {
        String jsonData = this.convertToJSON(entityWithExtInfo);
        this.saveToZip(entityWithExtInfo.getEntity().getGuid(), jsonData);
        this.recordAddedEntityGuids(entityWithExtInfo);
    }

    public void setResult(AtlasExportResult result) throws AtlasBaseException {
        String jsonData = this.convertToJSON(result);
        this.saveToZip(ZipExportFileNames.ATLAS_EXPORT_INFO_NAME, jsonData);
    }

    public void setTypesDef(AtlasTypesDef typesDef) throws AtlasBaseException {
        String jsonData = this.convertToJSON(typesDef);
        this.saveToZip(ZipExportFileNames.ATLAS_TYPESDEF_NAME, jsonData);
    }

    public void setExportOrder(List<String> result) throws AtlasBaseException {
        String jsonData = this.convertToJSON(result);
        this.saveToZip(ZipExportFileNames.ATLAS_EXPORT_ORDER_NAME, jsonData);
    }

    public void close() {
        try {
            if (this.zipOutputStream != null) {
                this.zipOutputStream.close();
                this.zipOutputStream = null;
            }
        }
        catch (IOException e) {
            LOG.error("Error closing Zip file", (Throwable)e);
        }
    }

    private String convertToJSON(Object entity) {
        return AtlasType.toJson((Object)entity);
    }

    private void saveToZip(ZipExportFileNames fileName, String jsonData) throws AtlasBaseException {
        this.saveToZip(fileName.toString(), jsonData);
    }

    private void saveToZip(String fileName, String jsonData) throws AtlasBaseException {
        try {
            this.addToZipStream(fileName.toString() + FILE_EXTENSION_JSON, jsonData);
        }
        catch (IOException e) {
            throw new AtlasBaseException(String.format("Error writing file %s.", fileName), (Throwable)e);
        }
    }

    private void addToZipStream(String entryName, String payload) throws IOException {
        ZipEntry e = new ZipEntry(entryName);
        this.zipOutputStream.putNextEntry(e);
        this.writeBytes(payload);
        this.zipOutputStream.closeEntry();
    }

    private void writeBytes(String payload) throws IOException {
        IOUtils.copy((InputStream)IOUtils.toInputStream((String)payload, (Charset)StandardCharsets.UTF_8), (OutputStream)this.zipOutputStream);
    }

    public boolean hasEntity(String guid) {
        return this.guids.contains(guid);
    }

    private void recordAddedEntityGuids(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        this.guids.add(entityWithExtInfo.getEntity().getGuid());
        if (entityWithExtInfo.getReferredEntities() != null) {
            this.guids.addAll(entityWithExtInfo.getReferredEntities().keySet());
        }
    }

    private void recordAddedEntityGuids(AtlasEntity entity) {
        this.guids.add(entity.getGuid());
    }
}

