/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.impexp.ImportTransforms;
import org.apache.atlas.repository.impexp.ZipExportFileNames;
import org.apache.atlas.repository.store.graph.v2.EntityImportStream;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSourceWithBackingDirectory
implements EntityImportStream {
    private static final Logger LOG = LoggerFactory.getLogger(ZipSourceWithBackingDirectory.class);
    private static final String TEMPORARY_DIRECTORY_PREFIX = "atlas-import-temp-";
    private static final String EXT_JSON = ".json";
    private Path tempDirectory;
    private ImportTransforms importTransform;
    private List<BaseEntityHandler> entityHandlers;
    private ArrayList<String> creationOrder = new ArrayList();
    private int currentPosition;
    private int numberOfEntries;

    public ZipSourceWithBackingDirectory(InputStream inputStream) throws IOException, AtlasBaseException {
        this(inputStream, null);
    }

    public ZipSourceWithBackingDirectory(InputStream inputStream, String backingDirectory) throws IOException, AtlasBaseException {
        this.setupBackingStore(inputStream, backingDirectory);
        if (this.isZipFileEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.IMPORT_ATTEMPTING_EMPTY_ZIP, new String[]{"Attempting to import empty ZIP."});
        }
    }

    @Override
    public ImportTransforms getImportTransform() {
        return this.importTransform;
    }

    @Override
    public void setImportTransform(ImportTransforms importTransform) {
        this.importTransform = importTransform;
    }

    @Override
    public List<BaseEntityHandler> getEntityHandlers() {
        return this.entityHandlers;
    }

    @Override
    public void setEntityHandlers(List<BaseEntityHandler> entityHandlers) {
        this.entityHandlers = entityHandlers;
    }

    @Override
    public AtlasTypesDef getTypesDef() throws AtlasBaseException {
        return this.getJsonFromEntry(ZipExportFileNames.ATLAS_TYPESDEF_NAME.toString(), AtlasTypesDef.class);
    }

    @Override
    public AtlasExportResult getExportResult() throws AtlasBaseException {
        return this.getJsonFromEntry(ZipExportFileNames.ATLAS_EXPORT_INFO_NAME.toString(), AtlasExportResult.class);
    }

    @Override
    public List<String> getCreationOrder() {
        return this.creationOrder;
    }

    @Override
    public int getPosition() {
        return this.currentPosition;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo getEntityWithExtInfo(String guid) throws AtlasBaseException {
        File file = this.getFileFromTemporaryDirectory(guid + EXT_JSON);
        if (!file.exists()) {
            return null;
        }
        String json = this.getJsonStringForFile(file);
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.convertFromJson(AtlasEntity.AtlasEntityWithExtInfo.class, json);
        if (this.importTransform != null) {
            entityWithExtInfo = this.importTransform.apply(entityWithExtInfo);
        }
        if (this.entityHandlers != null) {
            this.applyTransformers(entityWithExtInfo);
        }
        return entityWithExtInfo;
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.numberOfEntries;
    }

    @Override
    public AtlasEntity next() {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.getNextEntityWithExtInfo();
        return entityWithExtInfo != null ? entityWithExtInfo.getEntity() : null;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo getNextEntityWithExtInfo() {
        try {
            return this.getEntityWithExtInfo(this.moveNext());
        }
        catch (AtlasBaseException e) {
            LOG.error("getNextEntityWithExtInfo", (Throwable)e);
            return null;
        }
    }

    @Override
    public void reset() {
        this.currentPosition = 0;
    }

    @Override
    public AtlasEntity getByGuid(String guid) {
        try {
            return this.getEntity(guid);
        }
        catch (AtlasBaseException e) {
            LOG.error("getByGuid: {} failed!", (Object)guid, (Object)e);
            return null;
        }
    }

    @Override
    public void onImportComplete(String guid) {
        this.getFileFromTemporaryDirectory(guid + EXT_JSON).delete();
    }

    @Override
    public void setPosition(int index) {
        this.reset();
        for (int i = 0; i < this.numberOfEntries && i <= index; ++i) {
            this.onImportComplete(this.moveNext());
        }
    }

    @Override
    public void setPositionUsingEntityGuid(String guid) {
        if (StringUtils.isEmpty((String)guid)) {
            return;
        }
        while (this.currentPosition < this.numberOfEntries) {
            String current = this.creationOrder.get(this.currentPosition);
            if (current.equals(guid)) {
                return;
            }
            this.moveNext();
        }
    }

    @Override
    public void close() {
        this.creationOrder.clear();
        try {
            LOG.error("Import: Removing temporary directory: {}", (Object)this.tempDirectory.toString());
            FileUtils.deleteDirectory((File)this.tempDirectory.toFile());
        }
        catch (IOException e) {
            LOG.error("Import: Error deleting: {}", (Object)this.tempDirectory.toString(), (Object)e);
        }
    }

    private boolean isZipFileEmpty() {
        return this.numberOfEntries == 0;
    }

    private <T> T getJsonFromEntry(String entryName, Class<T> clazz) throws AtlasBaseException {
        File file = this.getFileFromTemporaryDirectory(entryName + EXT_JSON);
        if (!file.exists()) {
            throw new AtlasBaseException(entryName + " not found!");
        }
        return this.convertFromJson(clazz, this.getJsonStringForFile(file));
    }

    private void setupBackingStore(InputStream inputStream, String backingDirectory) throws AtlasBaseException, IOException {
        this.initTempDirectory(backingDirectory);
        this.unzipToTempDirectory(inputStream);
        this.setupIterator();
    }

    private void initTempDirectory(String backingDirectory) throws AtlasBaseException {
        try {
            this.tempDirectory = Files.createDirectory(Paths.get(backingDirectory, this.getChildDirectoryForSession()), new FileAttribute[0]);
            if (!this.permissionChecks(this.tempDirectory.toFile())) {
                throw new AtlasBaseException(String.format("Import: Temporary directory: %s does not have permissions for operation!", this.tempDirectory.toString()));
            }
        }
        catch (Exception ex) {
            throw new AtlasBaseException(String.format("Error fetching temporary directory: %s", this.tempDirectory.toString()), (Throwable)ex);
        }
    }

    private String getChildDirectoryForSession() {
        return String.format("%s%s", TEMPORARY_DIRECTORY_PREFIX, UUID.randomUUID());
    }

    private boolean permissionChecks(File f) {
        return f.exists() && f.isDirectory() && f.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipToTempDirectory(InputStream inputStream) throws IOException {
        LOG.info("Import: Temporary directory: {}", (Object)this.tempDirectory.toString());
        ZipInputStream zis = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                this.writeJsonToFile(entryName, this.getJsonPayloadFromZipEntryStream(zis));
                ++this.numberOfEntries;
                zipEntry = zis.getNextEntry();
            }
            this.numberOfEntries -= ZipExportFileNames.values().length;
        }
        finally {
            zis.close();
            inputStream.close();
        }
    }

    private void writeJsonToFile(String entryName, byte[] jsonPayload) throws IOException {
        File f = this.getFileFromTemporaryDirectory(entryName);
        Files.write(f.toPath(), jsonPayload, new OpenOption[0]);
    }

    private File getFileFromTemporaryDirectory(String entryName) {
        return new File(this.tempDirectory.toFile(), entryName);
    }

    private void setupIterator() {
        try {
            this.creationOrder = this.getJsonFromEntry(ZipExportFileNames.ATLAS_EXPORT_ORDER_NAME.toString(), ArrayList.class);
        }
        catch (AtlasBaseException e) {
            LOG.error("Error fetching: {}. Error generating order.", (Object)ZipExportFileNames.ATLAS_EXPORT_ORDER_NAME.toString(), (Object)e);
        }
        this.reset();
    }

    private byte[] getJsonPayloadFromZipEntryStream(ZipInputStream zipInputStream) {
        try {
            byte[] buf = new byte[1024];
            int n = 0;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((n = zipInputStream.read(buf, 0, 1024)) > -1) {
                bos.write(buf, 0, n);
            }
            return bos.toByteArray();
        }
        catch (IOException ex) {
            LOG.error("Error fetching string from entry.", (Throwable)ex);
            return null;
        }
    }

    private String getJsonStringForFile(File file) {
        try {
            byte[] bytes = Files.readAllBytes(file.toPath());
            return new String(bytes);
        }
        catch (IOException e) {
            LOG.warn("Error fetching: {}", (Object)file.toString(), (Object)e);
            return null;
        }
    }

    private void applyTransformers(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        if (entityWithExtInfo == null) {
            return;
        }
        this.transform(entityWithExtInfo.getEntity());
        if (MapUtils.isNotEmpty((Map)entityWithExtInfo.getReferredEntities())) {
            for (AtlasEntity e : entityWithExtInfo.getReferredEntities().values()) {
                this.transform(e);
            }
        }
    }

    private void transform(AtlasEntity e) {
        for (BaseEntityHandler handler : this.entityHandlers) {
            handler.transform(e);
        }
    }

    private <T> T convertFromJson(Class<T> clazz, String jsonData) throws AtlasBaseException {
        try {
            return (T)AtlasType.fromJson((String)jsonData, clazz);
        }
        catch (Exception e) {
            throw new AtlasBaseException("Error converting file to JSON.", (Throwable)e);
        }
    }

    private AtlasEntity getEntity(String guid) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo extInfo = this.getEntityWithExtInfo(guid);
        return extInfo != null ? extInfo.getEntity() : null;
    }

    @Override
    public int size() {
        return this.numberOfEntries;
    }

    private String moveNext() {
        if (this.currentPosition < this.numberOfEntries) {
            return this.creationOrder.get(this.currentPosition++);
        }
        return null;
    }
}

