/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.pc.WorkItemManager;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.ConcurrentPatchProcessor;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddMandatoryAttributesPatch
extends AtlasPatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AddMandatoryAttributesPatch.class);
    private static final String PATCH_ID = "JAVA_PATCH_0000_008";
    private static final String PATCH_DESCRIPTION = "Add mandatory attributes for all existing entities for given typeName";
    private final PatchContext context;
    private final String typeName;
    private final List<AtlasStructDef.AtlasAttributeDef> attributesToAdd;

    public AddMandatoryAttributesPatch(PatchContext context, String typedefPatchId, String typeName, List<AtlasStructDef.AtlasAttributeDef> attributesToAdd) {
        super(context.getPatchRegistry(), "JAVA_PATCH_0000_008_" + typedefPatchId, PATCH_DESCRIPTION);
        this.context = context;
        this.typeName = typeName;
        this.attributesToAdd = attributesToAdd;
    }

    @Override
    public void apply() throws AtlasBaseException {
        LOG.info("==> MandatoryAttributePatch.apply(): patchId={}", (Object)this.getPatchId());
        AddMandatoryAttributesPatchProcessor patchProcessor = new AddMandatoryAttributesPatchProcessor(this.context, this.typeName, this.attributesToAdd);
        patchProcessor.apply();
        this.setStatus(AtlasPatch.PatchStatus.APPLIED);
        LOG.info("<== MandatoryAttributePatch.apply(): patchId={}, status={}", (Object)this.getPatchId(), (Object)this.getStatus());
    }

    public static class AddMandatoryAttributesPatchProcessor
    extends ConcurrentPatchProcessor {
        private final String typeName;
        private final Set<String> typeAndAllSubTypes;
        private final List<AtlasStructDef.AtlasAttributeDef> attributesToAdd;

        public AddMandatoryAttributesPatchProcessor(PatchContext context, String typeName, List<AtlasStructDef.AtlasAttributeDef> attributesToAdd) {
            super(context);
            AtlasEntityType entityType = this.getTypeRegistry().getEntityTypeByName(typeName);
            this.typeName = typeName;
            this.attributesToAdd = attributesToAdd;
            if (entityType != null) {
                this.typeAndAllSubTypes = entityType.getTypeAndAllSubTypes();
            } else {
                LOG.warn("AddMandatoryAttributesPatchProcessor(): failed to find entity-type {}", (Object)typeName);
                this.typeAndAllSubTypes = Collections.emptySet();
            }
        }

        @Override
        public void submitVerticesToUpdate(WorkItemManager manager) {
            if (CollectionUtils.isNotEmpty(this.typeAndAllSubTypes)) {
                LOG.info("Entity types to be updated with mandatory attributes: {}", (Object)this.typeAndAllSubTypes.size());
                for (String typeName : this.typeAndAllSubTypes) {
                    LOG.info("finding entities of type {}", (Object)typeName);
                    AtlasGraph graph = this.getGraph();
                    Iterable vertexIds = graph.query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typeName).vertexIds();
                    int count = 0;
                    for (Object vertexId : vertexIds) {
                        manager.checkProduce(vertexId);
                        ++count;
                    }
                    LOG.info("found {} entities of type {}", (Object)count, (Object)typeName);
                }
            }
        }

        @Override
        protected void processVertexItem(Long vertexId, AtlasVertex vertex, String typeName, AtlasEntityType entityType) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AddMandatoryAttributesPatchProcessor.processVertexItem(typeName={}, vertexId={})", (Object)typeName, (Object)vertexId);
            }
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.attributesToAdd) {
                Object existingValue;
                AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(attributeDef.getName());
                if (attribute == null || (existingValue = vertex.getProperty(attribute.getVertexPropertyName(), Object.class)) != null) continue;
                vertex.setProperty(attribute.getVertexPropertyName(), (Object)attributeDef.getDefaultValue());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AddMandatoryAttributesPatchProcessor.processVertexItem(typeName={}, vertexId={})", (Object)typeName, (Object)vertexId);
            }
        }

        @Override
        protected void prepareForExecution() {
        }
    }
}

