/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.atlas.RequestContext;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasPatchRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasPatchRegistry.class);
    private final Map<String, AtlasPatch.PatchStatus> patchNameStatusMap;
    private final AtlasGraph graph;

    public AtlasPatchRegistry(AtlasGraph graph) {
        LOG.info("AtlasPatchRegistry: initializing..");
        this.graph = graph;
        this.patchNameStatusMap = AtlasPatchRegistry.getPatchNameStatusForAllRegistered(graph);
        LOG.info("AtlasPatchRegistry: found {} patches", (Object)this.patchNameStatusMap.size());
        for (Map.Entry<String, AtlasPatch.PatchStatus> entry : this.patchNameStatusMap.entrySet()) {
            LOG.info("AtlasPatchRegistry: patchId={}, status={}", (Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    public boolean isApplicable(String incomingId, String patchFile, int index) {
        String patchId = AtlasPatchRegistry.getId(incomingId, patchFile, index);
        if (MapUtils.isEmpty(this.patchNameStatusMap) || !this.patchNameStatusMap.containsKey(patchId)) {
            return true;
        }
        AtlasPatch.PatchStatus status = this.patchNameStatusMap.get(patchId);
        return status == AtlasPatch.PatchStatus.FAILED || status == AtlasPatch.PatchStatus.UNKNOWN;
    }

    public AtlasPatch.PatchStatus getStatus(String id) {
        return this.patchNameStatusMap.get(id);
    }

    public void register(String patchId, String description, String patchType, String action, AtlasPatch.PatchStatus patchStatus) {
        this.createOrUpdatePatchVertex(this.graph, patchId, description, patchType, action, patchStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(String patchId, AtlasPatch.PatchStatus patchStatus) {
        try {
            AtlasVertex patchVertex = this.findByPatchId(patchId);
            if (patchVertex != null) {
                AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.PATCH_STATE_PROPERTY_KEY, patchStatus.toString());
                AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, RequestContext.get().getRequestTime());
                AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.MODIFIED_BY_KEY, AtlasTypeDefGraphStoreV2.getCurrentUser());
                AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.PATCH_STATE_PROPERTY_KEY, patchStatus.toString());
            }
        }
        finally {
            this.graph.commit();
            this.patchNameStatusMap.put(patchId, patchStatus);
        }
    }

    private static String getId(String incomingId, String patchFile, int index) {
        String patchId = incomingId;
        if (StringUtils.isEmpty((CharSequence)patchId)) {
            return String.format("%s_%s", patchFile, index);
        }
        return patchId;
    }

    public AtlasPatch.AtlasPatches getAllPatches() {
        return AtlasPatchRegistry.getAllPatches(this.graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrUpdatePatchVertex(AtlasGraph graph, String patchId, String description, String patchType, String action, AtlasPatch.PatchStatus patchStatus) {
        try {
            AtlasVertex patchVertex = this.findByPatchId(patchId);
            if (patchVertex == null) {
                patchVertex = graph.addVertex();
            }
            AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.PATCH_ID_PROPERTY_KEY, patchId);
            AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.PATCH_DESCRIPTION_PROPERTY_KEY, description);
            AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.PATCH_TYPE_PROPERTY_KEY, patchType);
            AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.PATCH_ACTION_PROPERTY_KEY, action);
            AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.PATCH_STATE_PROPERTY_KEY, patchStatus.toString());
            AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.TIMESTAMP_PROPERTY_KEY, RequestContext.get().getRequestTime());
            AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, RequestContext.get().getRequestTime());
            AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.CREATED_BY_KEY, AtlasTypeDefGraphStoreV2.getCurrentUser());
            AtlasGraphUtilsV2.setEncodedProperty(patchVertex, Constants.MODIFIED_BY_KEY, AtlasTypeDefGraphStoreV2.getCurrentUser());
        }
        finally {
            graph.commit();
            this.patchNameStatusMap.put(patchId, patchStatus);
        }
    }

    private static Map<String, AtlasPatch.PatchStatus> getPatchNameStatusForAllRegistered(AtlasGraph graph) {
        HashMap<String, AtlasPatch.PatchStatus> ret = new HashMap<String, AtlasPatch.PatchStatus>();
        AtlasPatch.AtlasPatches patches = AtlasPatchRegistry.getAllPatches(graph);
        for (AtlasPatch patch : patches.getPatches()) {
            String patchId = patch.getId();
            AtlasPatch.PatchStatus patchStatus = patch.getStatus();
            if (patchId == null || patchStatus == null) continue;
            ret.put(patchId, patchStatus);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AtlasPatch.AtlasPatches getAllPatches(AtlasGraph graph) {
        ArrayList<AtlasGraphQuery> orConditions = new ArrayList<AtlasGraphQuery>();
        ArrayList<AtlasPatch> ret = new ArrayList<AtlasPatch>();
        AtlasGraphQuery query = graph.query();
        orConditions.add(query.createChildQuery().has(Constants.PATCH_TYPE_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, (Object)"TYPEDEF_PATCH"));
        orConditions.add(query.createChildQuery().has(Constants.PATCH_TYPE_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, (Object)"JAVA_PATCH"));
        query.or(orConditions);
        try {
            Iterator results = query.vertices().iterator();
            while (results != null && results.hasNext()) {
                AtlasVertex patchVertex = (AtlasVertex)results.next();
                AtlasPatch patch = AtlasPatchRegistry.toAtlasPatch(patchVertex);
                ret.add(patch);
            }
            if (CollectionUtils.isNotEmpty(ret)) {
                Collections.sort(ret, Comparator.comparing(AtlasPatch::getId));
            }
        }
        catch (Throwable t) {
            LOG.warn("getAllPatches(): Returned empty result!");
        }
        finally {
            graph.commit();
        }
        return new AtlasPatch.AtlasPatches(ret);
    }

    private static AtlasPatch toAtlasPatch(AtlasVertex vertex) {
        AtlasPatch ret = new AtlasPatch();
        ret.setId(AtlasGraphUtilsV2.getEncodedProperty(vertex, Constants.PATCH_ID_PROPERTY_KEY, String.class));
        ret.setDescription(AtlasGraphUtilsV2.getEncodedProperty(vertex, Constants.PATCH_DESCRIPTION_PROPERTY_KEY, String.class));
        ret.setType(AtlasGraphUtilsV2.getEncodedProperty(vertex, Constants.PATCH_TYPE_PROPERTY_KEY, String.class));
        ret.setAction(AtlasGraphUtilsV2.getEncodedProperty(vertex, Constants.PATCH_ACTION_PROPERTY_KEY, String.class));
        ret.setCreatedBy(AtlasGraphUtilsV2.getEncodedProperty(vertex, Constants.CREATED_BY_KEY, String.class));
        ret.setUpdatedBy(AtlasGraphUtilsV2.getEncodedProperty(vertex, Constants.MODIFIED_BY_KEY, String.class));
        ret.setCreatedTime(AtlasGraphUtilsV2.getEncodedProperty(vertex, Constants.TIMESTAMP_PROPERTY_KEY, Long.class).longValue());
        ret.setUpdatedTime(AtlasGraphUtilsV2.getEncodedProperty(vertex, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, Long.class).longValue());
        ret.setStatus(AtlasPatchRegistry.getPatchStatus(vertex));
        return ret;
    }

    public AtlasVertex findByPatchId(String patchId) {
        AtlasGraphQuery query = this.graph.query().has(Constants.PATCH_ID_PROPERTY_KEY, (Object)patchId);
        Iterator results = query.vertices().iterator();
        return results.hasNext() ? (AtlasVertex)results.next() : null;
    }

    private static AtlasPatch.PatchStatus getPatchStatus(AtlasVertex vertex) {
        String patchStatus = AtlasGraphUtilsV2.getEncodedProperty(vertex, Constants.PATCH_STATE_PROPERTY_KEY, String.class);
        return patchStatus != null ? AtlasPatch.PatchStatus.valueOf((String)patchStatus) : AtlasPatch.PatchStatus.UNKNOWN;
    }
}

