/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import java.util.HashSet;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.pc.WorkItemManager;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.ConcurrentPatchProcessor;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationTextPatch
extends AtlasPatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationTextPatch.class);
    private static final String PATCH_ID = "JAVA_PATCH_0000_002";
    private static final String PATCH_DESCRIPTION = "Populates Classification Text attribute for entities from classifications applied on them.";
    private final PatchContext context;

    public ClassificationTextPatch(PatchContext context) {
        super(context.getPatchRegistry(), PATCH_ID, PATCH_DESCRIPTION);
        this.context = context;
    }

    @Override
    public void apply() throws AtlasBaseException {
        ClassificationTextPatchProcessor patchProcessor = new ClassificationTextPatchProcessor(this.context);
        patchProcessor.apply();
        this.setStatus(AtlasPatch.PatchStatus.APPLIED);
        LOG.info("ClassificationTextPatch.apply(): patchId={}, status={}", (Object)this.getPatchId(), (Object)this.getStatus());
    }

    public static class ClassificationTextPatchProcessor
    extends ConcurrentPatchProcessor {
        public ClassificationTextPatchProcessor(PatchContext context) {
            super(context);
        }

        @Override
        protected void prepareForExecution() {
        }

        @Override
        public void submitVerticesToUpdate(WorkItemManager manager) {
            AtlasTypeRegistry typeRegistry = this.getTypeRegistry();
            AtlasGraph graph = this.getGraph();
            HashSet<Long> vertexIds = new HashSet<Long>();
            for (AtlasClassificationType classificationType : typeRegistry.getAllClassificationTypes()) {
                LOG.info("finding classification of type {}", (Object)classificationType.getTypeName());
                Iterable iterable = graph.query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)classificationType.getTypeName()).vertices();
                int count = 0;
                for (AtlasVertex classificationVertex : iterable) {
                    Iterable edges = classificationVertex.getEdges(AtlasEdgeDirection.IN);
                    for (AtlasEdge edge : edges) {
                        AtlasVertex entityVertex = edge.getOutVertex();
                        Long vertexId = (Long)entityVertex.getId();
                        if (vertexIds.contains(vertexId)) continue;
                        vertexIds.add(vertexId);
                        manager.checkProduce((Object)vertexId);
                    }
                    ++count;
                }
                LOG.info("found {} classification of type {}", (Object)count, (Object)classificationType.getTypeName());
            }
            LOG.info("found {} entities with classifications", (Object)vertexIds.size());
        }

        @Override
        protected void processVertexItem(Long vertexId, AtlasVertex vertex, String typeName, AtlasEntityType entityType) throws AtlasBaseException {
            this.processItem(vertexId, vertex, typeName, entityType);
        }

        private void processItem(Long vertexId, AtlasVertex vertex, String typeName, AtlasEntityType entityType) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("processItem(typeName={}, vertexId={})", (Object)typeName, (Object)vertexId);
            }
            if (AtlasGraphUtilsV2.getState((AtlasElement)vertex) != AtlasEntity.Status.ACTIVE) {
                return;
            }
            this.getEntityGraphMapper().updateClassificationTextAndNames(vertex);
            if (LOG.isDebugEnabled()) {
                LOG.debug("processItem(typeName={}, vertexId={}): Done!", (Object)typeName, (Object)vertexId);
            }
        }
    }
}

