/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityGraphDiscoveryContext {
    private static final Logger LOG = LoggerFactory.getLogger(EntityGraphDiscoveryContext.class);
    private final AtlasTypeRegistry typeRegistry;
    private final EntityStream entityStream;
    private final List<String> referencedGuids = new ArrayList<String>();
    private final Set<AtlasObjectId> referencedByUniqAttribs = new HashSet<AtlasObjectId>();
    private final Map<String, AtlasVertex> resolvedGuids = new HashMap<String, AtlasVertex>();
    private final Map<AtlasObjectId, AtlasVertex> resolvedIdsByUniqAttribs = new HashMap<AtlasObjectId, AtlasVertex>();
    private final Set<String> localGuids = new HashSet<String>();

    public EntityGraphDiscoveryContext(AtlasTypeRegistry typeRegistry, EntityStream entityStream) {
        this.typeRegistry = typeRegistry;
        this.entityStream = entityStream;
    }

    public EntityStream getEntityStream() {
        return this.entityStream;
    }

    public List<String> getReferencedGuids() {
        return this.referencedGuids;
    }

    public Set<AtlasObjectId> getReferencedByUniqAttribs() {
        return this.referencedByUniqAttribs;
    }

    public Map<String, AtlasVertex> getResolvedGuids() {
        return this.resolvedGuids;
    }

    public Map<AtlasObjectId, AtlasVertex> getResolvedIdsByUniqAttribs() {
        return this.resolvedIdsByUniqAttribs;
    }

    public Set<String> getLocalGuids() {
        return this.localGuids;
    }

    public void addReferencedGuid(String guid) {
        if (!this.referencedGuids.contains(guid)) {
            this.referencedGuids.add(guid);
        }
    }

    public void addReferencedByUniqAttribs(AtlasObjectId objId) {
        this.referencedByUniqAttribs.add(objId);
    }

    public void addResolvedGuid(String guid, AtlasVertex vertex) {
        this.resolvedGuids.put(guid, vertex);
    }

    public void addResolvedIdByUniqAttribs(AtlasObjectId objId, AtlasVertex vertex) {
        this.resolvedIdsByUniqAttribs.put(objId, vertex);
    }

    public void addLocalGuidReference(String guid) {
        this.localGuids.add(guid);
    }

    public boolean isResolvedGuid(String guid) {
        return this.resolvedGuids.containsKey(guid);
    }

    public boolean isResolvedIdByUniqAttrib(AtlasObjectId objId) {
        return this.resolvedIdsByUniqAttribs.containsKey(objId);
    }

    public AtlasVertex getResolvedEntityVertex(String guid) throws AtlasBaseException {
        AtlasVertex ret = this.resolvedGuids.get(guid);
        return ret;
    }

    public AtlasVertex getResolvedEntityVertex(AtlasObjectId objId) {
        if (this.resolvedIdsByUniqAttribs.containsKey(objId)) {
            return this.getAtlasVertexFromResolvedIdsByAttribs(objId);
        }
        if (objId instanceof AtlasRelatedObjectId) {
            objId = new AtlasObjectId(objId.getGuid(), objId.getTypeName(), objId.getUniqueAttributes());
        }
        return this.getAtlasVertexFromResolvedIdsByAttribs(objId);
    }

    private AtlasVertex getAtlasVertexFromResolvedIdsByAttribs(AtlasObjectId objId) {
        AtlasVertex vertex = this.resolvedIdsByUniqAttribs.get(objId);
        if (vertex == null) {
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(objId.getTypeName());
            Set allSubTypes = entityType.getAllSubTypes();
            for (String subType : allSubTypes) {
                AtlasObjectId subTypeObjId = new AtlasObjectId(objId.getGuid(), subType, objId.getUniqueAttributes());
                vertex = this.resolvedIdsByUniqAttribs.get(subTypeObjId);
                if (vertex == null) continue;
                this.resolvedIdsByUniqAttribs.put(objId, vertex);
                break;
            }
        }
        return vertex;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("EntityGraphDiscoveryCtx{");
        sb.append("referencedGuids=").append(this.referencedGuids);
        sb.append(", referencedByUniqAttribs=").append(this.referencedByUniqAttribs);
        sb.append(", resolvedGuids='").append(this.resolvedGuids);
        sb.append(", resolvedIdsByUniqAttribs='").append(this.resolvedIdsByUniqAttribs);
        sb.append(", localGuids='").append(this.localGuids);
        sb.append('}');
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public void cleanUp() {
        this.referencedGuids.clear();
        this.referencedByUniqAttribs.clear();
        this.resolvedGuids.clear();
        this.resolvedIdsByUniqAttribs.clear();
        this.localGuids.clear();
    }
}

