/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasAbstractDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.AtlasStructDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AtlasClassificationDefStoreV2
extends AtlasAbstractDefStoreV2<AtlasClassificationDef> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasClassificationDefStoreV2.class);
    private static final String TRAIT_NAME_REGEX = "[a-zA-Z[^\\p{ASCII}]][a-zA-Z0-9[^\\p{ASCII}]_ .]*";
    private static final Pattern TRAIT_NAME_PATTERN = Pattern.compile("[a-zA-Z[^\\p{ASCII}]][a-zA-Z0-9[^\\p{ASCII}]_ .]*");

    public AtlasClassificationDefStoreV2(AtlasTypeDefGraphStoreV2 typeDefStore, AtlasTypeRegistry typeRegistry) {
        super(typeDefStore, typeRegistry);
    }

    @Override
    public AtlasVertex preCreate(AtlasClassificationDef classificationDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasClassificationDefStoreV1.preCreate({})", (Object)classificationDef);
        }
        this.validateType((AtlasBaseTypeDef)classificationDef);
        AtlasType type = this.typeRegistry.getType(classificationDef.getName());
        if (type.getTypeCategory() != TypeCategory.CLASSIFICATION) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{classificationDef.getName(), DataTypes.TypeCategory.TRAIT.name()});
        }
        this.verifyTypeReadAccess(classificationDef.getSuperTypes());
        this.verifyTypeReadAccess(classificationDef.getEntityTypes());
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_CREATE, (AtlasBaseTypeDef)classificationDef), (Object[])new Object[]{"create classification-def ", classificationDef.getName()});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByName(classificationDef.getName());
        if (ret != null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_ALREADY_EXISTS, new String[]{classificationDef.getName()});
        }
        ret = this.typeDefStore.createTypeVertex((AtlasBaseTypeDef)classificationDef);
        this.updateVertexPreCreate(classificationDef, (AtlasClassificationType)type, ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasClassificationDefStoreV1.preCreate({}): {}", (Object)classificationDef, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasClassificationDef create(AtlasClassificationDef classificationDef, AtlasVertex preCreateResult) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasClassificationDefStoreV1.create({}, {})", (Object)classificationDef, (Object)preCreateResult);
        }
        AtlasVertex vertex = preCreateResult == null ? this.preCreate(classificationDef) : preCreateResult;
        this.updateVertexAddReferences(classificationDef, vertex);
        AtlasClassificationDef ret = this.toClassificationDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasClassificationDefStoreV1.create({}, {}): {}", new Object[]{classificationDef, preCreateResult, ret});
        }
        return ret;
    }

    @Override
    public List<AtlasClassificationDef> getAll() throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasClassificationDefStoreV1.getAll()");
        }
        ArrayList<AtlasClassificationDef> ret = new ArrayList<AtlasClassificationDef>();
        Iterator<AtlasVertex> vertices = this.typeDefStore.findTypeVerticesByCategory(DataTypes.TypeCategory.TRAIT);
        while (vertices.hasNext()) {
            ret.add(this.toClassificationDef(vertices.next()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasClassificationDefStoreV1.getAll(): count={}", (Object)ret.size());
        }
        return ret;
    }

    @Override
    public AtlasClassificationDef getByName(String name) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasClassificationDefStoreV1.getByName({})", (Object)name);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.TRAIT)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        vertex.getProperty(Constants.TYPE_CATEGORY_PROPERTY_KEY, DataTypes.TypeCategory.class);
        AtlasClassificationDef ret = this.toClassificationDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasClassificationDefStoreV1.getByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasClassificationDef getByGuid(String guid) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasClassificationDefStoreV1.getByGuid({})", (Object)guid);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.TRAIT)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasClassificationDef ret = this.toClassificationDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasClassificationDefStoreV1.getByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasClassificationDef update(AtlasClassificationDef classifiDef) throws AtlasBaseException {
        AtlasClassificationDef ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasClassificationDefStoreV1.update({})", (Object)classifiDef);
        }
        this.verifyTypeReadAccess(classifiDef.getSuperTypes());
        this.verifyTypeReadAccess(classifiDef.getEntityTypes());
        this.validateType((AtlasBaseTypeDef)classifiDef);
        AtlasClassificationDef atlasClassificationDef = ret = StringUtils.isNotBlank((String)classifiDef.getGuid()) ? this.updateByGuid(classifiDef.getGuid(), classifiDef) : this.updateByName(classifiDef.getName(), classifiDef);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasClassificationDefStoreV1.update({}): {}", (Object)classifiDef, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasClassificationDef updateByName(String name, AtlasClassificationDef classificationDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasClassificationDefStoreV1.updateByName({}, {})", (Object)name, (Object)classificationDef);
        }
        AtlasClassificationDef existingDef = this.typeRegistry.getClassificationDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update classification-def ", name});
        this.validateType((AtlasBaseTypeDef)classificationDef);
        AtlasType type = this.typeRegistry.getType(classificationDef.getName());
        if (type.getTypeCategory() != TypeCategory.CLASSIFICATION) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{classificationDef.getName(), DataTypes.TypeCategory.TRAIT.name()});
        }
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.TRAIT);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        this.updateVertexPreUpdate(classificationDef, (AtlasClassificationType)type, vertex);
        this.updateVertexAddReferences(classificationDef, vertex);
        AtlasClassificationDef ret = this.toClassificationDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasClassificationDefStoreV1.updateByName({}, {}): {}", new Object[]{name, classificationDef, ret});
        }
        return ret;
    }

    @Override
    public AtlasClassificationDef updateByGuid(String guid, AtlasClassificationDef classificationDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasClassificationDefStoreV1.updateByGuid({})", (Object)guid);
        }
        AtlasClassificationDef existingDef = this.typeRegistry.getClassificationDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update classification-def ", existingDef != null ? existingDef.getName() : guid});
        this.validateType((AtlasBaseTypeDef)classificationDef);
        AtlasType type = this.typeRegistry.getTypeByGuid(guid);
        if (type.getTypeCategory() != TypeCategory.CLASSIFICATION) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{classificationDef.getName(), DataTypes.TypeCategory.TRAIT.name()});
        }
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.TRAIT);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        this.updateVertexPreUpdate(classificationDef, (AtlasClassificationType)type, vertex);
        this.updateVertexAddReferences(classificationDef, vertex);
        AtlasClassificationDef ret = this.toClassificationDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasClassificationDefStoreV1.updateByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByName(String name) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasClassificationDefStoreV1.preDeleteByName({})", (Object)name);
        }
        AtlasClassificationDef existingDef = this.typeRegistry.getClassificationDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete classification-def ", name});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.TRAIT);
        if (AtlasGraphUtilsV2.typeHasInstanceVertex(name)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[]{name});
        }
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        this.typeDefStore.deleteTypeVertexOutEdges(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasClassificationDefStoreV1.preDeleteByName({}): ret=", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByGuid(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasClassificationDefStoreV1.preDeleteByGuid({})", (Object)guid);
        }
        AtlasClassificationDef existingDef = this.typeRegistry.getClassificationDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete classification-def ", existingDef != null ? existingDef.getName() : guid});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.TRAIT);
        String typeName = AtlasGraphUtilsV2.getEncodedProperty(ret, Constants.TYPENAME_PROPERTY_KEY, String.class);
        if (AtlasGraphUtilsV2.typeHasInstanceVertex(typeName)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[]{typeName});
        }
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        this.typeDefStore.deleteTypeVertexOutEdges(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasClassificationDefStoreV1.preDeleteByGuid({}): ret=", (Object)guid, (Object)ret);
        }
        return ret;
    }

    private void updateVertexPreCreate(AtlasClassificationDef classificationDef, AtlasClassificationType classificationType, AtlasVertex vertex) throws AtlasBaseException {
        AtlasStructDefStoreV2.updateVertexPreCreate((AtlasStructDef)classificationDef, (AtlasStructType)classificationType, vertex, this.typeDefStore);
    }

    private void updateVertexPreUpdate(AtlasClassificationDef classificationDef, AtlasClassificationType classificationType, AtlasVertex vertex) throws AtlasBaseException {
        AtlasStructDefStoreV2.updateVertexPreUpdate((AtlasStructDef)classificationDef, (AtlasStructType)classificationType, vertex, this.typeDefStore);
    }

    private void updateVertexAddReferences(AtlasClassificationDef classificationDef, AtlasVertex vertex) throws AtlasBaseException {
        AtlasStructDefStoreV2.updateVertexAddReferences((AtlasStructDef)classificationDef, vertex, this.typeDefStore);
        this.typeDefStore.createSuperTypeEdges(vertex, classificationDef.getSuperTypes(), DataTypes.TypeCategory.TRAIT);
        this.typeDefStore.createEntityTypeEdges(vertex, classificationDef.getEntityTypes());
    }

    private AtlasClassificationDef toClassificationDef(AtlasVertex vertex) throws AtlasBaseException {
        AtlasClassificationDef ret = null;
        if (vertex != null && this.typeDefStore.isTypeVertex(vertex, DataTypes.TypeCategory.TRAIT)) {
            ret = new AtlasClassificationDef();
            AtlasStructDefStoreV2.toStructDef(vertex, (AtlasStructDef)ret, this.typeDefStore);
            ret.setSuperTypes(this.typeDefStore.getSuperTypeNames(vertex));
            ret.setEntityTypes(this.typeDefStore.getEntityTypeNames(vertex));
        }
        return ret;
    }

    @Override
    public boolean isValidName(String typeName) {
        Matcher m = TRAIT_NAME_PATTERN.matcher(typeName);
        return m.matches();
    }
}

