/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasAbstractDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.AtlasStructDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasEntityDefStoreV2
extends AtlasAbstractDefStoreV2<AtlasEntityDef> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityDefStoreV2.class);

    @Inject
    public AtlasEntityDefStoreV2(AtlasTypeDefGraphStoreV2 typeDefStore, AtlasTypeRegistry typeRegistry) {
        super(typeDefStore, typeRegistry);
    }

    @Override
    public AtlasVertex preCreate(AtlasEntityDef entityDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEntityDefStoreV1.preCreate({})", (Object)entityDef);
        }
        this.validateType((AtlasBaseTypeDef)entityDef);
        AtlasType type = this.typeRegistry.getType(entityDef.getName());
        if (type.getTypeCategory() != TypeCategory.ENTITY) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{entityDef.getName(), DataTypes.TypeCategory.CLASS.name()});
        }
        this.verifyAttributeTypeReadAccess((Collection)entityDef.getAttributeDefs());
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_CREATE, (AtlasBaseTypeDef)entityDef), (Object[])new Object[]{"create entity-def ", entityDef.getName()});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByName(entityDef.getName());
        if (ret != null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_ALREADY_EXISTS, new String[]{entityDef.getName()});
        }
        ret = this.typeDefStore.createTypeVertex((AtlasBaseTypeDef)entityDef);
        this.updateVertexPreCreate(entityDef, (AtlasEntityType)type, ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV1.preCreate({}): {}", (Object)entityDef, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntityDef create(AtlasEntityDef entityDef, AtlasVertex preCreateResult) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEntityDefStoreV1.create({}, {})", (Object)entityDef, (Object)preCreateResult);
        }
        AtlasVertex vertex = preCreateResult == null ? this.preCreate(entityDef) : preCreateResult;
        this.updateVertexAddReferences(entityDef, vertex);
        AtlasEntityDef ret = this.toEntityDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV1.create({}, {}): {}", new Object[]{entityDef, preCreateResult, ret});
        }
        return ret;
    }

    @Override
    public List<AtlasEntityDef> getAll() throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEntityDefStoreV1.getAll()");
        }
        ArrayList<AtlasEntityDef> ret = new ArrayList<AtlasEntityDef>();
        Iterator<AtlasVertex> vertices = this.typeDefStore.findTypeVerticesByCategory(DataTypes.TypeCategory.CLASS);
        while (vertices.hasNext()) {
            ret.add(this.toEntityDef(vertices.next()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV1.getAll(): count={}", (Object)ret.size());
        }
        return ret;
    }

    @Override
    public AtlasEntityDef getByName(String name) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEntityDefStoreV1.getByName({})", (Object)name);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.CLASS)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        vertex.getProperty(Constants.TYPE_CATEGORY_PROPERTY_KEY, DataTypes.TypeCategory.class);
        AtlasEntityDef ret = this.toEntityDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV1.getByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntityDef getByGuid(String guid) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEntityDefStoreV1.getByGuid({})", (Object)guid);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.CLASS)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasEntityDef ret = this.toEntityDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV1.getByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntityDef update(AtlasEntityDef entityDef) throws AtlasBaseException {
        AtlasEntityDef ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEntityDefStoreV1.update({})", (Object)entityDef);
        }
        this.verifyAttributeTypeReadAccess((Collection)entityDef.getAttributeDefs());
        this.validateType((AtlasBaseTypeDef)entityDef);
        AtlasEntityDef atlasEntityDef = ret = StringUtils.isNotBlank((String)entityDef.getGuid()) ? this.updateByGuid(entityDef.getGuid(), entityDef) : this.updateByName(entityDef.getName(), entityDef);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV1.update({}): {}", (Object)entityDef, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntityDef updateByName(String name, AtlasEntityDef entityDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEntityDefStoreV1.updateByName({}, {})", (Object)name, (Object)entityDef);
        }
        AtlasEntityDef existingDef = this.typeRegistry.getEntityDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update entity-def ", name});
        this.validateType((AtlasBaseTypeDef)entityDef);
        AtlasType type = this.typeRegistry.getType(entityDef.getName());
        if (type.getTypeCategory() != TypeCategory.ENTITY) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{entityDef.getName(), DataTypes.TypeCategory.CLASS.name()});
        }
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.CLASS);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        this.updateVertexPreUpdate(entityDef, (AtlasEntityType)type, vertex);
        this.updateVertexAddReferences(entityDef, vertex);
        AtlasEntityDef ret = this.toEntityDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV1.updateByName({}, {}): {}", new Object[]{name, entityDef, ret});
        }
        return ret;
    }

    @Override
    public AtlasEntityDef updateByGuid(String guid, AtlasEntityDef entityDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEntityDefStoreV1.updateByGuid({})", (Object)guid);
        }
        AtlasEntityDef existingDef = this.typeRegistry.getEntityDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update entity-def ", existingDef != null ? existingDef.getName() : guid});
        this.validateType((AtlasBaseTypeDef)entityDef);
        AtlasType type = this.typeRegistry.getTypeByGuid(guid);
        if (type.getTypeCategory() != TypeCategory.ENTITY) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{entityDef.getName(), DataTypes.TypeCategory.CLASS.name()});
        }
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.CLASS);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        this.updateVertexPreUpdate(entityDef, (AtlasEntityType)type, vertex);
        this.updateVertexAddReferences(entityDef, vertex);
        AtlasEntityDef ret = this.toEntityDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV1.updateByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByName(String name) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEntityDefStoreV1.preDeleteByName({})", (Object)name);
        }
        AtlasEntityDef existingDef = this.typeRegistry.getEntityDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete entity-def ", name});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.CLASS);
        if (AtlasGraphUtilsV2.typeHasInstanceVertex(name)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[]{name});
        }
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        if (this.typeDefStore.hasIncomingEdgesWithLabel(ret, "__type..relationshipType")) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_RELATIONSHIPS, new String[]{name});
        }
        this.typeDefStore.deleteTypeVertexOutEdges(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV1.preDeleteByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByGuid(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEntityDefStoreV1.preDeleteByGuid({})", (Object)guid);
        }
        AtlasEntityDef existingDef = this.typeRegistry.getEntityDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete entity-def ", existingDef != null ? existingDef.getName() : guid});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.CLASS);
        String typeName = AtlasGraphUtilsV2.getEncodedProperty(ret, Constants.TYPENAME_PROPERTY_KEY, String.class);
        if (AtlasGraphUtilsV2.typeHasInstanceVertex(typeName)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[]{typeName});
        }
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        if (this.typeDefStore.hasIncomingEdgesWithLabel(ret, "__type..relationshipType")) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_RELATIONSHIPS, new String[]{typeName});
        }
        this.typeDefStore.deleteTypeVertexOutEdges(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV1.preDeleteByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    private void updateVertexPreCreate(AtlasEntityDef entityDef, AtlasEntityType entityType, AtlasVertex vertex) throws AtlasBaseException {
        AtlasStructDefStoreV2.updateVertexPreCreate((AtlasStructDef)entityDef, (AtlasStructType)entityType, vertex, this.typeDefStore);
    }

    private void updateVertexPreUpdate(AtlasEntityDef entityDef, AtlasEntityType entityType, AtlasVertex vertex) throws AtlasBaseException {
        AtlasStructDefStoreV2.updateVertexPreUpdate((AtlasStructDef)entityDef, (AtlasStructType)entityType, vertex, this.typeDefStore);
    }

    private void updateVertexAddReferences(AtlasEntityDef entityDef, AtlasVertex vertex) throws AtlasBaseException {
        AtlasStructDefStoreV2.updateVertexAddReferences((AtlasStructDef)entityDef, vertex, this.typeDefStore);
        this.typeDefStore.createSuperTypeEdges(vertex, entityDef.getSuperTypes(), DataTypes.TypeCategory.CLASS);
    }

    private AtlasEntityDef toEntityDef(AtlasVertex vertex) throws AtlasBaseException {
        AtlasEntityDef ret = null;
        if (vertex != null && this.typeDefStore.isTypeVertex(vertex, DataTypes.TypeCategory.CLASS)) {
            ret = new AtlasEntityDef();
            AtlasStructDefStoreV2.toStructDef(vertex, (AtlasStructDef)ret, this.typeDefStore);
            ret.setSuperTypes(this.typeDefStore.getSuperTypeNames(vertex));
        }
        return ret;
    }
}

