/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.annotations.VisibleForTesting;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasAbstractDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.v1.model.typedef.AttributeDefinition;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasStructDefStoreV2
extends AtlasAbstractDefStoreV2<AtlasStructDef> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasStructDefStoreV2.class);

    public AtlasStructDefStoreV2(AtlasTypeDefGraphStoreV2 typeDefStore, AtlasTypeRegistry typeRegistry) {
        super(typeDefStore, typeRegistry);
    }

    @Override
    public AtlasVertex preCreate(AtlasStructDef structDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasStructDefStoreV1.preCreate({})", (Object)structDef);
        }
        this.validateType((AtlasBaseTypeDef)structDef);
        AtlasType type = this.typeRegistry.getType(structDef.getName());
        if (type.getTypeCategory() != TypeCategory.STRUCT) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{structDef.getName(), DataTypes.TypeCategory.STRUCT.name()});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_CREATE, (AtlasBaseTypeDef)structDef), (Object[])new Object[]{"create struct-def ", structDef.getName()});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByName(structDef.getName());
        if (ret != null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_ALREADY_EXISTS, new String[]{structDef.getName()});
        }
        ret = this.typeDefStore.createTypeVertex((AtlasBaseTypeDef)structDef);
        AtlasStructDefStoreV2.updateVertexPreCreate(structDef, (AtlasStructType)type, ret, this.typeDefStore);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasStructDefStoreV1.preCreate({}): {}", (Object)structDef, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasStructDef create(AtlasStructDef structDef, AtlasVertex preCreateResult) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasStructDefStoreV1.create({}, {})", (Object)structDef, (Object)preCreateResult);
        }
        this.verifyAttributeTypeReadAccess((Collection)structDef.getAttributeDefs());
        if (CollectionUtils.isEmpty((Collection)structDef.getAttributeDefs())) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Missing attributes for structdef"});
        }
        AtlasVertex vertex = preCreateResult == null ? this.preCreate(structDef) : preCreateResult;
        AtlasStructDefStoreV2.updateVertexAddReferences(structDef, vertex, this.typeDefStore);
        AtlasStructDef ret = this.toStructDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasStructDefStoreV1.create({}, {}): {}", new Object[]{structDef, preCreateResult, ret});
        }
        return ret;
    }

    @Override
    public List<AtlasStructDef> getAll() throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasStructDefStoreV1.getAll()");
        }
        ArrayList<AtlasStructDef> ret = new ArrayList<AtlasStructDef>();
        Iterator<AtlasVertex> vertices = this.typeDefStore.findTypeVerticesByCategory(DataTypes.TypeCategory.STRUCT);
        while (vertices.hasNext()) {
            ret.add(this.toStructDef(vertices.next()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasStructDefStoreV1.getAll(): count={}", (Object)ret.size());
        }
        return ret;
    }

    @Override
    public AtlasStructDef getByName(String name) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasStructDefStoreV1.getByName({})", (Object)name);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.STRUCT)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        vertex.getProperty(Constants.TYPE_CATEGORY_PROPERTY_KEY, String.class);
        AtlasStructDef ret = this.toStructDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasStructDefStoreV1.getByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasStructDef getByGuid(String guid) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasStructDefStoreV1.getByGuid({})", (Object)guid);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.STRUCT)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasStructDef ret = this.toStructDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasStructDefStoreV1.getByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasStructDef update(AtlasStructDef structDef) throws AtlasBaseException {
        AtlasStructDef ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasStructDefStoreV1.update({})", (Object)structDef);
        }
        this.verifyAttributeTypeReadAccess((Collection)structDef.getAttributeDefs());
        this.validateType((AtlasBaseTypeDef)structDef);
        AtlasStructDef atlasStructDef = ret = StringUtils.isNotBlank((String)structDef.getGuid()) ? this.updateByGuid(structDef.getGuid(), structDef) : this.updateByName(structDef.getName(), structDef);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasStructDefStoreV1.update({}): {}", (Object)structDef, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasStructDef updateByName(String name, AtlasStructDef structDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasStructDefStoreV1.updateByName({}, {})", (Object)name, (Object)structDef);
        }
        AtlasStructDef existingDef = this.typeRegistry.getStructDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update struct-def ", name});
        this.validateType((AtlasBaseTypeDef)structDef);
        AtlasType type = this.typeRegistry.getType(structDef.getName());
        if (type.getTypeCategory() != TypeCategory.STRUCT) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{structDef.getName(), DataTypes.TypeCategory.STRUCT.name()});
        }
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.STRUCT);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        AtlasStructDefStoreV2.updateVertexPreUpdate(structDef, (AtlasStructType)type, vertex, this.typeDefStore);
        AtlasStructDefStoreV2.updateVertexAddReferences(structDef, vertex, this.typeDefStore);
        AtlasStructDef ret = this.toStructDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasStructDefStoreV1.updateByName({}, {}): {}", new Object[]{name, structDef, ret});
        }
        return ret;
    }

    @Override
    public AtlasStructDef updateByGuid(String guid, AtlasStructDef structDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasStructDefStoreV1.updateByGuid({})", (Object)guid);
        }
        AtlasStructDef existingDef = this.typeRegistry.getStructDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update struct-def ", existingDef != null ? existingDef.getName() : guid});
        this.validateType((AtlasBaseTypeDef)structDef);
        AtlasType type = this.typeRegistry.getTypeByGuid(guid);
        if (type.getTypeCategory() != TypeCategory.STRUCT) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{structDef.getName(), DataTypes.TypeCategory.STRUCT.name()});
        }
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.STRUCT);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasStructDefStoreV2.updateVertexPreUpdate(structDef, (AtlasStructType)type, vertex, this.typeDefStore);
        AtlasStructDefStoreV2.updateVertexAddReferences(structDef, vertex, this.typeDefStore);
        AtlasStructDef ret = this.toStructDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasStructDefStoreV1.updateByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByName(String name) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasStructDefStoreV1.preDeleteByName({})", (Object)name);
        }
        AtlasStructDef existingDef = this.typeRegistry.getStructDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete struct-def ", name});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.STRUCT);
        if (AtlasGraphUtilsV2.typeHasInstanceVertex(name)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[]{name});
        }
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        this.typeDefStore.deleteTypeVertexOutEdges(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasStructDefStoreV1.preDeleteByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByGuid(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasStructDefStoreV1.preDeleteByGuid({})", (Object)guid);
        }
        AtlasStructDef existingDef = this.typeRegistry.getStructDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete struct-def ", existingDef != null ? existingDef.getName() : guid});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.STRUCT);
        String typeName = AtlasGraphUtilsV2.getEncodedProperty(ret, Constants.TYPENAME_PROPERTY_KEY, String.class);
        if (AtlasGraphUtilsV2.typeHasInstanceVertex(typeName)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[]{typeName});
        }
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        this.typeDefStore.deleteTypeVertexOutEdges(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasStructDefStoreV1.preDeleteByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    private AtlasStructDef toStructDef(AtlasVertex vertex) throws AtlasBaseException {
        AtlasStructDef ret = null;
        if (vertex != null && this.typeDefStore.isTypeVertex(vertex, DataTypes.TypeCategory.STRUCT)) {
            ret = AtlasStructDefStoreV2.toStructDef(vertex, new AtlasStructDef(), this.typeDefStore);
        }
        return ret;
    }

    public static void updateVertexPreCreate(AtlasStructDef structDef, AtlasStructType structType, AtlasVertex vertex, AtlasTypeDefGraphStoreV2 typeDefStore) throws AtlasBaseException {
        ArrayList<String> attrNames = new ArrayList<String>(structDef.getAttributeDefs().size());
        for (AtlasStructDef.AtlasAttributeDef attributeDef : structDef.getAttributeDefs()) {
            if (StringUtils.isEmpty((String)attributeDef.getName())) {
                throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ATTRIBUTE, new String[]{structDef.getName(), "name"});
            }
            if (StringUtils.isEmpty((String)attributeDef.getTypeName())) {
                throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ATTRIBUTE, new String[]{structDef.getName(), "typeName"});
            }
            String propertyKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)structDef, attributeDef.getName());
            String encodedPropertyKey = AtlasGraphUtilsV2.encodePropertyKey(propertyKey);
            vertex.setProperty(encodedPropertyKey, (Object)AtlasStructDefStoreV2.toJsonFromAttribute(structType.getAttribute(attributeDef.getName())));
            attrNames.add(attributeDef.getName());
        }
        String typeNamePropertyKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)structDef);
        String encodedtypeNamePropertyKey = AtlasGraphUtilsV2.encodePropertyKey(typeNamePropertyKey);
        vertex.setProperty(encodedtypeNamePropertyKey, attrNames);
    }

    public static void updateVertexPreUpdate(AtlasStructDef structDef, AtlasStructType structType, AtlasVertex vertex, AtlasTypeDefGraphStoreV2 typeDefStore) throws AtlasBaseException {
        String structDefPropertyKey;
        String encodedStructDefPropertyKey;
        List currAttrNames;
        ArrayList<String> attrNames = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)structDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : structDef.getAttributeDefs()) {
                attrNames.add(attributeDef.getName());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(currAttrNames = (List)vertex.getProperty(encodedStructDefPropertyKey = AtlasStructType.AtlasAttribute.encodePropertyKey((String)(structDefPropertyKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)structDef))), List.class)))) {
            ArrayList<String> removedAttributes = null;
            for (String currAttrName : currAttrNames) {
                if (attrNames.contains(currAttrName)) continue;
                if (RequestContext.get().isInTypePatching()) {
                    String propertyKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)structDef, currAttrName);
                    AtlasGraphUtilsV2.setProperty(vertex, propertyKey, null);
                    if (removedAttributes == null) {
                        removedAttributes = new ArrayList<String>();
                    }
                    removedAttributes.add(currAttrName);
                    LOG.warn("REMOVED ATTRIBUTE: {}.{}", (Object)structDef.getName(), (Object)currAttrName);
                    continue;
                }
                throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_DELETION_NOT_SUPPORTED, new String[]{structDef.getName(), currAttrName});
            }
            if (removedAttributes != null) {
                currAttrNames.removeAll(removedAttributes);
                vertex.setListProperty(encodedStructDefPropertyKey, currAttrNames);
            }
        }
        typeDefStore.updateTypeVertex((AtlasBaseTypeDef)structDef, vertex);
        AtlasStructDef currentStructDef = AtlasStructDefStoreV2.toStructDef(vertex, new AtlasStructDef(), typeDefStore);
        if (CollectionUtils.isNotEmpty((Collection)structDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : structDef.getAttributeDefs()) {
                if (CollectionUtils.isEmpty((Collection)currAttrNames) || !currAttrNames.contains(attributeDef.getName())) {
                    AtlasRelationshipType relationship = AtlasTypeUtil.findRelationshipWithLegacyRelationshipEnd((String)structDef.getName(), (String)attributeDef.getName(), (AtlasTypeRegistry)typeDefStore.getTypeRegistry());
                    if (relationship != null) {
                        attrNames.remove(attributeDef.getName());
                        LOG.warn("Ignoring attempt to add legacy attribute {}.{}, which is already present in relationship {}", new Object[]{structDef.getName(), attributeDef.getName(), relationship.getTypeName()});
                        continue;
                    }
                    if (!attributeDef.getIsOptional() && !AtlasStructDefStoreV2.isInAddMandatoryAttributePatch()) {
                        throw new AtlasBaseException(AtlasErrorCode.CANNOT_ADD_MANDATORY_ATTRIBUTE, new String[]{structDef.getName(), attributeDef.getName()});
                    }
                }
                if (StringUtils.isEmpty((String)attributeDef.getName())) {
                    throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ATTRIBUTE, new String[]{structDef.getName(), "name"});
                }
                if (StringUtils.isEmpty((String)attributeDef.getTypeName())) {
                    throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ATTRIBUTE, new String[]{structDef.getName(), "typeName"});
                }
                AtlasStructDef.AtlasAttributeDef existingAttribute = currentStructDef.getAttribute(attributeDef.getName());
                if (null != existingAttribute && !attributeDef.getTypeName().equals(existingAttribute.getTypeName())) {
                    throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Data type update for attribute is not supported"});
                }
                String propertyKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)structDef, attributeDef.getName());
                AtlasGraphUtilsV2.setProperty(vertex, propertyKey, AtlasStructDefStoreV2.toJsonFromAttribute(structType.getAttribute(attributeDef.getName())));
            }
        }
        AtlasGraphUtilsV2.setEncodedProperty(vertex, encodedStructDefPropertyKey, attrNames);
    }

    public static boolean isInAddMandatoryAttributePatch() {
        return RequestContext.get().isInTypePatching() && StringUtils.equals((String)"ADD_MANDATORY_ATTRIBUTE", (String)RequestContext.get().getCurrentTypePatchAction());
    }

    public static void updateVertexAddReferences(AtlasStructDef structDef, AtlasVertex vertex, AtlasTypeDefGraphStoreV2 typeDefStore) throws AtlasBaseException {
        for (AtlasStructDef.AtlasAttributeDef attributeDef : structDef.getAttributeDefs()) {
            AtlasStructDefStoreV2.addReferencesForAttribute(vertex, attributeDef, typeDefStore);
        }
    }

    public static AtlasStructDef toStructDef(AtlasVertex vertex, AtlasStructDef structDef, AtlasTypeDefGraphStoreV2 typeDefStore) throws AtlasBaseException {
        AtlasStructDef ret = structDef != null ? structDef : new AtlasStructDef();
        typeDefStore.vertexToTypeDef(vertex, (AtlasBaseTypeDef)ret);
        ArrayList<AtlasStructDef.AtlasAttributeDef> attributeDefs = new ArrayList<AtlasStructDef.AtlasAttributeDef>();
        String typePropertyKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)ret);
        String encodedTypePropertyKey = AtlasGraphUtilsV2.encodePropertyKey(typePropertyKey);
        List attrNames = (List)vertex.getProperty(encodedTypePropertyKey, List.class);
        if (CollectionUtils.isNotEmpty((Collection)attrNames)) {
            for (String attrName : attrNames) {
                String attrPropertyKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)ret, attrName);
                String encodedAttrPropertyKey = AtlasGraphUtilsV2.encodePropertyKey(attrPropertyKey);
                String attrJson = (String)vertex.getProperty(encodedAttrPropertyKey, String.class);
                if (StringUtils.isEmpty((String)attrJson)) {
                    LOG.warn("attribute not found {}.{}. Ignoring..", (Object)structDef.getName(), (Object)attrName);
                    continue;
                }
                attributeDefs.add(AtlasStructDefStoreV2.toAttributeDefFromJson(structDef, (Map)AtlasType.fromJson((String)attrJson, Map.class), typeDefStore));
            }
        }
        ret.setAttributeDefs(attributeDefs);
        return ret;
    }

    private static void addReferencesForAttribute(AtlasVertex vertex, AtlasStructDef.AtlasAttributeDef attributeDef, AtlasTypeDefGraphStoreV2 typeDefStore) throws AtlasBaseException {
        Set referencedTypeNames = AtlasTypeUtil.getReferencedTypeNames((String)attributeDef.getTypeName());
        String typeName = (String)vertex.getProperty(Constants.TYPENAME_PROPERTY_KEY, String.class);
        for (String referencedTypeName : referencedTypeNames) {
            if (AtlasTypeUtil.isBuiltInType((String)referencedTypeName)) continue;
            AtlasVertex referencedTypeVertex = typeDefStore.findTypeVertexByName(referencedTypeName);
            if (referencedTypeVertex == null) {
                throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPE, new String[]{referencedTypeName, typeName, attributeDef.getName()});
            }
            String label = AtlasGraphUtilsV2.getEdgeLabel(typeName, attributeDef.getName());
            typeDefStore.getOrCreateEdge(vertex, referencedTypeVertex, label);
        }
    }

    @VisibleForTesting
    public static String toJsonFromAttribute(AtlasStructType.AtlasAttribute attribute) {
        int upper;
        int lower;
        AtlasStructDef.AtlasAttributeDef attributeDef = attribute.getAttributeDef();
        HashMap<String, Object> attribInfo = new HashMap<String, Object>();
        attribInfo.put("name", attributeDef.getName());
        attribInfo.put("dataType", attributeDef.getTypeName());
        attribInfo.put("isUnique", attributeDef.getIsUnique());
        attribInfo.put("isIndexable", attributeDef.getIsIndexable());
        attribInfo.put("includeInNotification", attributeDef.getIncludeInNotification());
        attribInfo.put("isComposite", attribute.isOwnedRef());
        attribInfo.put("reverseAttributeName", attribute.getInverseRefAttributeName());
        attribInfo.put("defaultValue", attributeDef.getDefaultValue());
        attribInfo.put("description", attributeDef.getDescription());
        attribInfo.put("searchWeight", attributeDef.getSearchWeight());
        attribInfo.put("indexType", attributeDef.getIndexType());
        if (attributeDef.getOptions() != null) {
            attribInfo.put("options", AtlasType.toJson((Object)attributeDef.getOptions()));
        }
        attribInfo.put("displayName", attributeDef.getDisplayName());
        if (attributeDef.getCardinality() == AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE) {
            lower = attributeDef.getIsOptional() ? 0 : 1;
            upper = 1;
        } else {
            lower = attributeDef.getIsOptional() ? 0 : (attributeDef.getValuesMinCount() < 1 ? 1 : attributeDef.getValuesMinCount());
            upper = attributeDef.getValuesMaxCount() < 2 ? Integer.MAX_VALUE : attributeDef.getValuesMaxCount();
        }
        HashMap<String, Constable> multiplicity = new HashMap<String, Constable>();
        multiplicity.put("lower", Integer.valueOf(lower));
        multiplicity.put("upper", Integer.valueOf(upper));
        multiplicity.put("isUnique", Boolean.valueOf(AtlasStructDef.AtlasAttributeDef.Cardinality.SET.equals((Object)attributeDef.getCardinality())));
        attribInfo.put("multiplicity", AtlasType.toJson(multiplicity));
        return AtlasType.toJson(attribInfo);
    }

    @VisibleForTesting
    public static AtlasStructDef.AtlasAttributeDef toAttributeDefFromJson(AtlasStructDef structDef, Map attribInfo, AtlasTypeDefGraphStoreV2 typeDefStore) throws AtlasBaseException {
        String reverseAttributeName;
        AtlasStructDef.AtlasAttributeDef ret = new AtlasStructDef.AtlasAttributeDef();
        ret.setName((String)attribInfo.get("name"));
        ret.setTypeName((String)attribInfo.get("dataType"));
        ret.setIsUnique(((Boolean)attribInfo.get("isUnique")).booleanValue());
        ret.setIsIndexable(((Boolean)attribInfo.get("isIndexable")).booleanValue());
        ret.setIncludeInNotification((Boolean)attribInfo.get("includeInNotification"));
        ret.setDefaultValue((String)attribInfo.get("defaultValue"));
        ret.setDescription((String)attribInfo.get("description"));
        if (attribInfo.get("options") != null) {
            ret.setOptions((Map)AtlasType.fromJson((String)((String)attribInfo.get("options")), Map.class));
        }
        ret.setDisplayName((String)attribInfo.get("displayName"));
        if (((Boolean)attribInfo.get("isComposite")).booleanValue()) {
            ret.addConstraint(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
        }
        if (StringUtils.isNotBlank((String)(reverseAttributeName = (String)attribInfo.get("reverseAttributeName")))) {
            ret.addConstraint(new AtlasStructDef.AtlasConstraintDef("inverseRef", (Map)new HashMap<String, Object>(){
                {
                    this.put("attribute", reverseAttributeName);
                }
            }));
        }
        Map multiplicity = (Map)AtlasType.fromJson((String)((String)attribInfo.get("multiplicity")), Map.class);
        Number minCount = (Number)multiplicity.get("lower");
        Number maxCount = (Number)multiplicity.get("upper");
        Boolean isUnique = (Boolean)multiplicity.get("isUnique");
        if (minCount == null || minCount.intValue() == 0) {
            ret.setIsOptional(true);
            ret.setValuesMinCount(0);
        } else {
            ret.setIsOptional(false);
            ret.setValuesMinCount(minCount.intValue());
        }
        if (maxCount == null || maxCount.intValue() < 2) {
            ret.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
            ret.setValuesMaxCount(1);
        } else {
            if (isUnique == null || isUnique == Boolean.FALSE) {
                ret.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.LIST);
            } else {
                ret.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.SET);
            }
            ret.setValuesMaxCount(maxCount.intValue());
        }
        Number searchWeight = (Number)attribInfo.get("searchWeight");
        if (searchWeight != null) {
            ret.setSearchWeight(searchWeight.intValue());
        } else {
            ret.setSearchWeight(-1);
        }
        String indexType = (String)attribInfo.get("indexType");
        if (!StringUtils.isEmpty((String)indexType)) {
            ret.setIndexType(AtlasStructDef.AtlasAttributeDef.IndexType.valueOf((String)indexType));
        }
        return ret;
    }

    public static AttributeDefinition toAttributeDefinition(AtlasStructType.AtlasAttribute attribute) {
        AtlasStructDef.AtlasAttributeDef attrDef = attribute.getAttributeDef();
        AttributeDefinition ret = new AttributeDefinition();
        ret.setName(attrDef.getName());
        ret.setDataTypeName(attrDef.getTypeName());
        ret.setMultiplicity(AtlasTypeUtil.getMultiplicity((AtlasStructDef.AtlasAttributeDef)attrDef));
        ret.setIsComposite(attribute.isOwnedRef());
        ret.setIsUnique(attrDef.getIsUnique());
        ret.setIsIndexable(attrDef.getIsIndexable());
        ret.setReverseAttributeName(attribute.getInverseRefAttributeName());
        ret.setDescription(attrDef.getDescription());
        ret.setDefaultValue(attrDef.getDefaultValue());
        ret.setSearchWeight(attrDef.getSearchWeight());
        ret.setIndexType(attrDef.getIndexType());
        return ret;
    }
}

