/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.discovery.EntityDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.listener.TypeDefChangeListener;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasDefStore;
import org.apache.atlas.repository.store.graph.AtlasTypeDefGraphStore;
import org.apache.atlas.repository.store.graph.v2.AtlasBusinessMetadataDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasClassificationDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEnumDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasRelationshipDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasStructDefStoreV2;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class AtlasTypeDefGraphStoreV2
extends AtlasTypeDefGraphStore {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasTypeDefGraphStoreV2.class);
    protected final AtlasGraph atlasGraph;
    private EntityDiscoveryService entityDiscoveryService;

    @Inject
    public AtlasTypeDefGraphStoreV2(AtlasTypeRegistry typeRegistry, Set<TypeDefChangeListener> typeDefChangeListeners, AtlasGraph atlasGraph, EntityDiscoveryService entityDiscoveryService) {
        super(typeRegistry, typeDefChangeListeners);
        this.atlasGraph = atlasGraph;
        this.entityDiscoveryService = entityDiscoveryService;
        LOG.debug("<== AtlasTypeDefGraphStoreV1()");
    }

    @Override
    protected AtlasDefStore<AtlasEnumDef> getEnumDefStore(AtlasTypeRegistry typeRegistry) {
        return new AtlasEnumDefStoreV2(this, typeRegistry);
    }

    @Override
    protected AtlasDefStore<AtlasStructDef> getStructDefStore(AtlasTypeRegistry typeRegistry) {
        return new AtlasStructDefStoreV2(this, typeRegistry);
    }

    @Override
    protected AtlasDefStore<AtlasClassificationDef> getClassificationDefStore(AtlasTypeRegistry typeRegistry) {
        return new AtlasClassificationDefStoreV2(this, typeRegistry);
    }

    @Override
    protected AtlasDefStore<AtlasEntityDef> getEntityDefStore(AtlasTypeRegistry typeRegistry) {
        return new AtlasEntityDefStoreV2(this, typeRegistry);
    }

    @Override
    protected AtlasDefStore<AtlasRelationshipDef> getRelationshipDefStore(AtlasTypeRegistry typeRegistry) {
        return new AtlasRelationshipDefStoreV2(this, typeRegistry);
    }

    @Override
    protected AtlasDefStore<AtlasBusinessMetadataDef> getBusinessMetadataDefStore(AtlasTypeRegistry typeRegistry) {
        return new AtlasBusinessMetadataDefStoreV2(this, typeRegistry, this.entityDiscoveryService);
    }

    @Override
    @GraphTransaction
    public void init() throws AtlasBaseException {
        LOG.info("==> AtlasTypeDefGraphStoreV1.init()");
        super.init();
        LOG.info("<== AtlasTypeDefGraphStoreV1.init()");
    }

    AtlasGraph getAtlasGraph() {
        return this.atlasGraph;
    }

    @VisibleForTesting
    public AtlasVertex findTypeVertexByName(String typeName) {
        Iterator results = this.atlasGraph.query().has(Constants.VERTEX_TYPE_PROPERTY_KEY, (Object)"typeSystem").has(Constants.TYPENAME_PROPERTY_KEY, (Object)typeName).vertices().iterator();
        return results != null && results.hasNext() ? (AtlasVertex)results.next() : null;
    }

    AtlasVertex findTypeVertexByNameAndCategory(String typeName, DataTypes.TypeCategory category) {
        Iterator results = this.atlasGraph.query().has(Constants.VERTEX_TYPE_PROPERTY_KEY, (Object)"typeSystem").has(Constants.TYPENAME_PROPERTY_KEY, (Object)typeName).has(Constants.TYPE_CATEGORY_PROPERTY_KEY, (Object)category).vertices().iterator();
        return results != null && results.hasNext() ? (AtlasVertex)results.next() : null;
    }

    AtlasVertex findTypeVertexByGuid(String typeGuid) {
        Iterator vertices = this.atlasGraph.query().has(Constants.VERTEX_TYPE_PROPERTY_KEY, (Object)"typeSystem").has(Constants.GUID_PROPERTY_KEY, (Object)typeGuid).vertices().iterator();
        return vertices != null && vertices.hasNext() ? (AtlasVertex)vertices.next() : null;
    }

    AtlasVertex findTypeVertexByGuidAndCategory(String typeGuid, DataTypes.TypeCategory category) {
        Iterator vertices = this.atlasGraph.query().has(Constants.VERTEX_TYPE_PROPERTY_KEY, (Object)"typeSystem").has(Constants.GUID_PROPERTY_KEY, (Object)typeGuid).has(Constants.TYPE_CATEGORY_PROPERTY_KEY, (Object)category).vertices().iterator();
        return vertices != null && vertices.hasNext() ? (AtlasVertex)vertices.next() : null;
    }

    Iterator<AtlasVertex> findTypeVerticesByCategory(DataTypes.TypeCategory category) {
        return this.atlasGraph.query().has(Constants.VERTEX_TYPE_PROPERTY_KEY, (Object)"typeSystem").has(Constants.TYPE_CATEGORY_PROPERTY_KEY, (Object)category).vertices().iterator();
    }

    AtlasVertex createTypeVertex(AtlasBaseTypeDef typeDef) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)typeDef.getName()), (Object)"Type name can't be null/empty");
        AtlasVertex ret = this.atlasGraph.addVertex();
        if (StringUtils.isBlank((CharSequence)typeDef.getTypeVersion())) {
            typeDef.setTypeVersion("1.0");
        }
        if (typeDef.getVersion() == null) {
            typeDef.setVersion(Long.valueOf(1L));
        }
        if (StringUtils.isBlank((CharSequence)typeDef.getGuid())) {
            typeDef.setGuid(UUID.randomUUID().toString());
        }
        if (typeDef.getCreateTime() == null) {
            typeDef.setCreateTime(new Date());
        }
        if (typeDef.getUpdateTime() == null) {
            typeDef.setUpdateTime(new Date());
        }
        ret.setProperty(Constants.VERTEX_TYPE_PROPERTY_KEY, (Object)"typeSystem");
        ret.setProperty(Constants.TYPE_CATEGORY_PROPERTY_KEY, (Object)this.getTypeCategory(typeDef));
        ret.setProperty(Constants.TYPENAME_PROPERTY_KEY, (Object)typeDef.getName());
        ret.setProperty(Constants.TYPEDESCRIPTION_PROPERTY_KEY, (Object)(StringUtils.isNotBlank((CharSequence)typeDef.getDescription()) ? typeDef.getDescription() : typeDef.getName()));
        if (StringUtils.isNotEmpty((CharSequence)typeDef.getServiceType())) {
            ret.setProperty(Constants.TYPESERVICETYPE_PROPERTY_KEY, (Object)typeDef.getServiceType());
        }
        ret.setProperty(Constants.TYPEVERSION_PROPERTY_KEY, (Object)typeDef.getTypeVersion());
        ret.setProperty(Constants.GUID_PROPERTY_KEY, (Object)typeDef.getGuid());
        ret.setProperty(Constants.CREATED_BY_KEY, (Object)AtlasTypeDefGraphStoreV2.getCurrentUser());
        ret.setProperty(Constants.TIMESTAMP_PROPERTY_KEY, (Object)typeDef.getCreateTime().getTime());
        ret.setProperty(Constants.MODIFIED_BY_KEY, (Object)AtlasTypeDefGraphStoreV2.getCurrentUser());
        ret.setProperty(Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, (Object)typeDef.getUpdateTime().getTime());
        ret.setProperty(Constants.VERSION_PROPERTY_KEY, (Object)typeDef.getVersion());
        ret.setProperty(Constants.TYPEOPTIONS_PROPERTY_KEY, (Object)AtlasType.toJson((Object)typeDef.getOptions()));
        return ret;
    }

    void updateTypeVertex(AtlasBaseTypeDef typeDef, AtlasVertex vertex) {
        if (!this.isTypeVertex(vertex)) {
            LOG.warn("updateTypeVertex(): not a type-vertex - {}", (Object)vertex);
            return;
        }
        this.updateVertexProperty(vertex, Constants.GUID_PROPERTY_KEY, typeDef.getGuid());
        this.updateVertexProperty(vertex, Constants.TYPEDESCRIPTION_PROPERTY_KEY, typeDef.getDescription());
        this.updateVertexProperty(vertex, Constants.TYPEVERSION_PROPERTY_KEY, typeDef.getTypeVersion());
        this.updateVertexProperty(vertex, Constants.TYPEOPTIONS_PROPERTY_KEY, AtlasType.toJson((Object)typeDef.getOptions()));
        if (StringUtils.isNotEmpty((CharSequence)typeDef.getServiceType())) {
            this.updateVertexProperty(vertex, Constants.TYPESERVICETYPE_PROPERTY_KEY, typeDef.getServiceType());
        }
        this.markVertexUpdated(vertex);
    }

    void deleteTypeVertexOutEdges(AtlasVertex vertex) throws AtlasBaseException {
        Iterable edges = vertex.getEdges(AtlasEdgeDirection.OUT);
        for (AtlasEdge edge : edges) {
            this.atlasGraph.removeEdge(edge);
        }
    }

    boolean hasIncomingEdgesWithLabel(AtlasVertex vertex, String label) throws AtlasBaseException {
        boolean foundEdges = false;
        for (AtlasEdge edge : vertex.getEdges(AtlasEdgeDirection.IN)) {
            if (!label.equals(edge.getLabel())) continue;
            foundEdges = true;
            break;
        }
        return foundEdges;
    }

    void deleteTypeVertex(AtlasVertex vertex) throws AtlasBaseException {
        Iterator inEdges = vertex.getEdges(AtlasEdgeDirection.IN).iterator();
        if (inEdges.hasNext()) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[0]);
        }
        Iterable edges = vertex.getEdges(AtlasEdgeDirection.OUT);
        for (AtlasEdge edge : edges) {
            this.atlasGraph.removeEdge(edge);
        }
        this.atlasGraph.removeVertex(vertex);
    }

    void vertexToTypeDef(AtlasVertex vertex, AtlasBaseTypeDef typeDef) {
        String name = (String)vertex.getProperty(Constants.TYPENAME_PROPERTY_KEY, String.class);
        String description = (String)vertex.getProperty(Constants.TYPEDESCRIPTION_PROPERTY_KEY, String.class);
        String serviceType = (String)vertex.getProperty(Constants.TYPESERVICETYPE_PROPERTY_KEY, String.class);
        String typeVersion = (String)vertex.getProperty(Constants.TYPEVERSION_PROPERTY_KEY, String.class);
        String guid = (String)vertex.getProperty(Constants.GUID_PROPERTY_KEY, String.class);
        String createdBy = (String)vertex.getProperty(Constants.CREATED_BY_KEY, String.class);
        String updatedBy = (String)vertex.getProperty(Constants.MODIFIED_BY_KEY, String.class);
        Long createTime = (Long)vertex.getProperty(Constants.TIMESTAMP_PROPERTY_KEY, Long.class);
        Long updateTime = (Long)vertex.getProperty(Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, Long.class);
        Object versionObj = vertex.getProperty(Constants.VERSION_PROPERTY_KEY, Object.class);
        String options = (String)vertex.getProperty(Constants.TYPEOPTIONS_PROPERTY_KEY, String.class);
        Long version = null;
        version = versionObj instanceof Number ? Long.valueOf(((Number)versionObj).longValue()) : (versionObj != null ? Long.valueOf(versionObj.toString()) : Long.valueOf(0L));
        typeDef.setName(name);
        typeDef.setDescription(description);
        typeDef.setServiceType(serviceType);
        typeDef.setTypeVersion(typeVersion);
        typeDef.setGuid(guid);
        typeDef.setCreatedBy(createdBy);
        typeDef.setUpdatedBy(updatedBy);
        if (createTime != null) {
            typeDef.setCreateTime(new Date(createTime));
        }
        if (updateTime != null) {
            typeDef.setUpdateTime(new Date(updateTime));
        }
        if (version != null) {
            typeDef.setVersion(version);
        }
        if (options != null) {
            typeDef.setOptions((Map)AtlasType.fromJson((String)options, Map.class));
        }
    }

    boolean isTypeVertex(AtlasVertex vertex) {
        String vertexType = (String)vertex.getProperty(Constants.VERTEX_TYPE_PROPERTY_KEY, String.class);
        return "typeSystem".equals(vertexType);
    }

    @VisibleForTesting
    public boolean isTypeVertex(AtlasVertex vertex, DataTypes.TypeCategory category) {
        boolean ret = false;
        if (this.isTypeVertex(vertex)) {
            Object objTypeCategory = vertex.getProperty(Constants.TYPE_CATEGORY_PROPERTY_KEY, Object.class);
            DataTypes.TypeCategory vertexCategory = null;
            if (objTypeCategory instanceof DataTypes.TypeCategory) {
                vertexCategory = (DataTypes.TypeCategory)objTypeCategory;
            } else if (objTypeCategory != null) {
                vertexCategory = DataTypes.TypeCategory.valueOf((String)objTypeCategory.toString());
            }
            ret = category.equals((Object)vertexCategory);
        }
        return ret;
    }

    boolean isTypeVertex(AtlasVertex vertex, DataTypes.TypeCategory[] categories) {
        boolean ret = false;
        if (this.isTypeVertex(vertex)) {
            DataTypes.TypeCategory vertexCategory = (DataTypes.TypeCategory)vertex.getProperty(Constants.TYPE_CATEGORY_PROPERTY_KEY, DataTypes.TypeCategory.class);
            for (DataTypes.TypeCategory category : categories) {
                if (!category.equals((Object)vertexCategory)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    AtlasEdge getOrCreateEdge(AtlasVertex outVertex, AtlasVertex inVertex, String edgeLabel) {
        AtlasEdge ret = null;
        Iterable edges = outVertex.getEdges(AtlasEdgeDirection.OUT, edgeLabel);
        for (AtlasEdge edge : edges) {
            if (!edge.getInVertex().getId().equals(inVertex.getId())) continue;
            ret = edge;
            break;
        }
        if (ret == null) {
            ret = this.addEdge(outVertex, inVertex, edgeLabel);
        }
        return ret;
    }

    AtlasEdge addEdge(AtlasVertex outVertex, AtlasVertex inVertex, String edgeLabel) {
        return this.atlasGraph.addEdge(outVertex, inVertex, edgeLabel);
    }

    void removeEdge(AtlasVertex outVertex, AtlasVertex inVertex, String edgeLabel) {
        Iterable edges = outVertex.getEdges(AtlasEdgeDirection.OUT, edgeLabel);
        for (AtlasEdge edge : edges) {
            if (!edge.getInVertex().getId().equals(inVertex.getId())) continue;
            this.atlasGraph.removeEdge(edge);
        }
    }

    void createSuperTypeEdges(AtlasVertex vertex, Set<String> superTypes, DataTypes.TypeCategory typeCategory) throws AtlasBaseException {
        Set<String> currentSuperTypes = this.getSuperTypeNames(vertex);
        if (CollectionUtils.isNotEmpty(superTypes)) {
            if (!superTypes.containsAll(currentSuperTypes)) {
                throw new AtlasBaseException(AtlasErrorCode.SUPERTYPE_REMOVAL_NOT_SUPPORTED, new String[0]);
            }
            for (String superType : superTypes) {
                AtlasVertex superTypeVertex = this.findTypeVertexByNameAndCategory(superType, typeCategory);
                this.getOrCreateEdge(vertex, superTypeVertex, "__type..supertype");
            }
        } else if (CollectionUtils.isNotEmpty(currentSuperTypes)) {
            throw new AtlasBaseException(AtlasErrorCode.SUPERTYPE_REMOVAL_NOT_SUPPORTED, new String[0]);
        }
    }

    public void createEntityTypeEdges(AtlasVertex classificationVertex, Set<String> entityTypes) throws AtlasBaseException {
        block6: {
            String classificationTypeName;
            Set<String> currentEntityTypes;
            block5: {
                currentEntityTypes = this.getEntityTypeNames(classificationVertex);
                classificationTypeName = (String)classificationVertex.getProperty(Constants.TYPENAME_PROPERTY_KEY, String.class);
                if (!CollectionUtils.isNotEmpty(entityTypes)) break block5;
                if (!entityTypes.containsAll(currentEntityTypes)) {
                    throw new AtlasBaseException(AtlasErrorCode.ENTITYTYPE_REMOVAL_NOT_SUPPORTED, new String[]{classificationTypeName});
                }
                for (String entityType : entityTypes) {
                    AtlasVertex entityTypeVertex = this.findTypeVertexByNameAndCategory(entityType, DataTypes.TypeCategory.CLASS);
                    if (entityTypeVertex == null) {
                        throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATIONDEF_INVALID_ENTITYTYPES, new String[]{classificationTypeName, entityType});
                    }
                    this.getOrCreateEdge(classificationVertex, entityTypeVertex, "__type..entitytype");
                }
                break block6;
            }
            if (!CollectionUtils.isNotEmpty(currentEntityTypes)) break block6;
            for (String entityType : currentEntityTypes) {
                AtlasVertex entityTypeVertex = this.findTypeVertexByNameAndCategory(entityType, DataTypes.TypeCategory.CLASS);
                if (entityTypeVertex == null) {
                    throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATIONDEF_INVALID_ENTITYTYPES, new String[]{classificationTypeName, entityType});
                }
                this.removeEdge(classificationVertex, entityTypeVertex, "__type..entitytype");
            }
        }
    }

    Set<String> getSuperTypeNames(AtlasVertex vertex) {
        return this.getTypeNamesFromEdges(vertex, "__type..supertype");
    }

    Set<String> getEntityTypeNames(AtlasVertex vertex) {
        return this.getTypeNamesFromEdges(vertex, "__type..entitytype");
    }

    private Set<String> getTypeNamesFromEdges(AtlasVertex vertex, String edgeLabel) {
        HashSet<String> ret = new HashSet<String>();
        Iterable edges = vertex.getEdges(AtlasEdgeDirection.OUT, edgeLabel);
        for (AtlasEdge edge : edges) {
            ret.add((String)edge.getInVertex().getProperty(Constants.TYPENAME_PROPERTY_KEY, String.class));
        }
        return ret;
    }

    DataTypes.TypeCategory getTypeCategory(AtlasBaseTypeDef typeDef) {
        switch (typeDef.getCategory()) {
            case ENTITY: {
                return DataTypes.TypeCategory.CLASS;
            }
            case CLASSIFICATION: {
                return DataTypes.TypeCategory.TRAIT;
            }
            case STRUCT: {
                return DataTypes.TypeCategory.STRUCT;
            }
            case ENUM: {
                return DataTypes.TypeCategory.ENUM;
            }
            case RELATIONSHIP: {
                return DataTypes.TypeCategory.RELATIONSHIP;
            }
            case BUSINESS_METADATA: {
                return DataTypes.TypeCategory.BUSINESS_METADATA;
            }
        }
        return null;
    }

    private void updateVertexProperty(AtlasVertex vertex, String propertyName, String newValue) {
        String currValue;
        if (StringUtils.isNotBlank((CharSequence)newValue) && !StringUtils.equals((CharSequence)(currValue = (String)vertex.getProperty(propertyName, String.class)), (CharSequence)newValue)) {
            vertex.setProperty(propertyName, (Object)newValue);
        }
    }

    private void updateVertexProperty(AtlasVertex vertex, String propertyName, Date newValue) {
        Number currValue;
        if (!(newValue == null || (currValue = (Number)vertex.getProperty(propertyName, Number.class)) != null && currValue.equals(newValue.getTime()))) {
            vertex.setProperty(propertyName, (Object)newValue.getTime());
        }
    }

    private void markVertexUpdated(AtlasVertex vertex) {
        Number currVersion = (Number)vertex.getProperty(Constants.VERSION_PROPERTY_KEY, Number.class);
        long newVersion = currVersion == null ? 1L : currVersion.longValue() + 1L;
        vertex.setProperty(Constants.MODIFIED_BY_KEY, (Object)AtlasTypeDefGraphStoreV2.getCurrentUser());
        vertex.setProperty(Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, (Object)System.currentTimeMillis());
        vertex.setProperty(Constants.VERSION_PROPERTY_KEY, (Object)newVersion);
    }

    public static String getCurrentUser() {
        return RequestContext.getCurrentUser();
    }
}

