/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasEntityHeaders;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClassificationAssociator {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationAssociator.class);

    private static class ListOps<V extends AtlasClassification> {
        private ListOps() {
        }

        public List<V> intersect(List<V> lhs, List<V> rhs) {
            if (CollectionUtils.isEmpty(rhs)) {
                return null;
            }
            ArrayList<AtlasClassification> result = new ArrayList<AtlasClassification>();
            for (AtlasClassification c : rhs) {
                AtlasClassification found = this.findFrom(lhs, c);
                if (found == null) continue;
                result.add(found);
            }
            return result;
        }

        public List<V> subtract(List<V> lhs, List<V> rhs) {
            if (CollectionUtils.isEmpty(lhs)) {
                return null;
            }
            ArrayList<AtlasClassification> result = new ArrayList<AtlasClassification>();
            for (AtlasClassification c : lhs) {
                AtlasClassification found = this.findFrom(rhs, c);
                if (found != null) continue;
                result.add(c);
            }
            return result;
        }

        private V findFrom(List<V> reference, V check) {
            return (V)((AtlasClassification)CollectionUtils.find(reference, ox -> ((AtlasClassification)ox).getTypeName().equals(check.getTypeName())));
        }

        public List<V> filter(String guid, List<V> list) {
            if (CollectionUtils.isEmpty(list)) {
                return list;
            }
            return list.stream().filter(x -> x != null && (StringUtils.isEmpty((CharSequence)guid) || StringUtils.isEmpty((CharSequence)x.getEntityGuid())) || x.getEntityGuid().equals(guid)).collect(Collectors.toList());
        }
    }

    public static class Updater {
        static final String ATTR_NAME_QUALIFIED_NAME = "qualifiedName";
        static final String STATUS_DONE = "(Done)";
        static final String STATUS_SKIPPED = "(Skipped)";
        static final String STATUS_PARTIAL = "(Partial)";
        private static final String PROCESS_FORMAT = "%s:%s:%s:%s -> %s:%s";
        static final String PROCESS_ADD = "Add";
        static final String PROCESS_UPDATE = "Update";
        static final String PROCESS_DELETE = "Delete";
        static final String JSONIFY_STRING_FORMAT = "\"%s\",";
        private final AtlasGraph graph;
        private final AtlasTypeRegistry typeRegistry;
        private final AtlasEntityStore entitiesStore;
        private final EntityGraphRetriever entityRetriever;
        private final StringBuilder actionSummary = new StringBuilder();

        public Updater(AtlasGraph graph, AtlasTypeRegistry typeRegistry, AtlasEntityStore entitiesStore) {
            this.graph = graph;
            this.typeRegistry = typeRegistry;
            this.entitiesStore = entitiesStore;
            this.entityRetriever = new EntityGraphRetriever(graph, typeRegistry);
        }

        public Updater(AtlasTypeRegistry typeRegistry, AtlasEntityStore entitiesStore) {
            this(AtlasGraphProvider.getGraphInstance(), typeRegistry, entitiesStore);
        }

        public String setClassifications(Map<String, AtlasEntityHeader> map) {
            for (AtlasEntityHeader incomingEntityHeader : map.values()) {
                AtlasEntityHeader entityToBeChanged;
                String typeName = incomingEntityHeader.getTypeName();
                AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
                if (entityType == null) {
                    LOG.warn("Entity type: {}: Not found: {}!", (Object)typeName, (Object)STATUS_SKIPPED);
                    this.summarizeFormat("%s: %s", typeName, STATUS_SKIPPED);
                    continue;
                }
                String qualifiedName = this.getUniqueAttributeName(entityType, incomingEntityHeader);
                if (StringUtils.isEmpty((CharSequence)qualifiedName)) {
                    qualifiedName = "<no unique name>";
                }
                if ((entityToBeChanged = this.getByUniqueAttributes(entityType, qualifiedName, incomingEntityHeader.getAttributes())) == null) {
                    this.summarizeFormat("Entity:%s:%s:[Not found]:%s", entityType.getTypeName(), qualifiedName, STATUS_SKIPPED);
                    continue;
                }
                String guid = entityToBeChanged.getGuid();
                Map<String, List<AtlasClassification>> operationListMap = this.computeChanges(incomingEntityHeader, entityToBeChanged);
                this.commitChanges(guid, typeName, qualifiedName, operationListMap);
            }
            return this.getJsonArray(this.actionSummary);
        }

        private void commitChanges(String entityGuid, String typeName, String qualifiedName, Map<String, List<AtlasClassification>> operationListMap) {
            if (MapUtils.isEmpty(operationListMap)) {
                return;
            }
            this.deleteClassifications(entityGuid, typeName, qualifiedName, operationListMap.get(PROCESS_DELETE));
            this.updateClassifications(entityGuid, typeName, qualifiedName, operationListMap.get(PROCESS_UPDATE));
            this.addClassifications(entityGuid, typeName, qualifiedName, operationListMap.get(PROCESS_ADD));
            operationListMap.clear();
        }

        private Map<String, List<AtlasClassification>> computeChanges(AtlasEntityHeader incomingEntityHeader, AtlasEntityHeader entityToBeUpdated) {
            if (incomingEntityHeader == null || entityToBeUpdated == null) {
                return null;
            }
            ListOps listOps = new ListOps();
            List incomingClassifications = listOps.filter(incomingEntityHeader.getGuid(), incomingEntityHeader.getClassifications());
            List entityClassifications = listOps.filter(entityToBeUpdated.getGuid(), entityToBeUpdated.getClassifications());
            if (CollectionUtils.isEmpty(incomingClassifications) && CollectionUtils.isEmpty(entityClassifications)) {
                return null;
            }
            HashMap<String, List<AtlasClassification>> operationListMap = new HashMap<String, List<AtlasClassification>>();
            this.bucket(PROCESS_DELETE, operationListMap, listOps.subtract(entityClassifications, incomingClassifications));
            this.bucket(PROCESS_UPDATE, operationListMap, listOps.intersect(incomingClassifications, entityClassifications));
            this.bucket(PROCESS_ADD, operationListMap, listOps.subtract(incomingClassifications, entityClassifications));
            return operationListMap;
        }

        private void bucket(String op, Map<String, List<AtlasClassification>> operationListMap, List<AtlasClassification> results) {
            if (CollectionUtils.isEmpty(results)) {
                return;
            }
            operationListMap.put(op, results);
        }

        private void addClassifications(String entityGuid, String typeName, String qualifiedName, List<AtlasClassification> list) {
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            String status = STATUS_DONE;
            String classificationNames = this.getClassificationNames(list);
            try {
                this.entitiesStore.addClassifications(entityGuid, list);
            }
            catch (AtlasBaseException e) {
                status = STATUS_PARTIAL;
                LOG.warn("{}:{}:{} -> {}: {}.", new Object[]{PROCESS_UPDATE, typeName, qualifiedName, classificationNames, status});
            }
            this.summarize(PROCESS_ADD, entityGuid, typeName, qualifiedName, classificationNames, status);
        }

        private void updateClassifications(String entityGuid, String typeName, String qualifiedName, List<AtlasClassification> list) {
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            String status = STATUS_DONE;
            String classificationNames = this.getClassificationNames(list);
            try {
                this.entitiesStore.updateClassifications(entityGuid, list);
            }
            catch (AtlasBaseException e) {
                status = STATUS_PARTIAL;
                LOG.warn("{}:{}:{} -> {}: {}.", new Object[]{PROCESS_UPDATE, typeName, qualifiedName, classificationNames, status});
            }
            this.summarize(PROCESS_UPDATE, entityGuid, typeName, qualifiedName, classificationNames, status);
        }

        private void deleteClassifications(String entityGuid, String typeName, String qualifiedName, List<AtlasClassification> list) {
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            String status = STATUS_DONE;
            String classificationTypeName = this.getClassificationNames(list);
            for (AtlasClassification c : list) {
                try {
                    this.entitiesStore.deleteClassification(entityGuid, c.getTypeName());
                }
                catch (AtlasBaseException e) {
                    status = STATUS_PARTIAL;
                    LOG.warn("{}:{}:{} -> {}: Skipped!", new Object[]{entityGuid, typeName, qualifiedName, c.getTypeName()});
                }
            }
            this.summarize(PROCESS_DELETE, entityGuid, typeName, qualifiedName, classificationTypeName, status);
        }

        AtlasEntityHeader getByUniqueAttributes(AtlasEntityType entityType, String qualifiedName, Map<String, Object> attrValues) {
            try {
                AtlasVertex vertex = AtlasGraphUtilsV2.findByUniqueAttributes(this.graph, entityType, attrValues);
                if (vertex == null) {
                    return null;
                }
                return this.entityRetriever.toAtlasEntityHeaderWithClassifications(vertex);
            }
            catch (AtlasBaseException e) {
                LOG.warn("{}:{} could not be processed!", (Object)entityType, (Object)qualifiedName);
                return null;
            }
            catch (Exception ex) {
                LOG.error("{}:{} could not be processed!", new Object[]{entityType, qualifiedName, ex});
                return null;
            }
        }

        private String getClassificationNames(List<AtlasClassification> list) {
            return list.stream().map(AtlasStruct::getTypeName).collect(Collectors.joining(", "));
        }

        private String getUniqueAttributeName(AtlasEntityType entityType, AtlasEntityHeader entityHeader) {
            String uniqueAttrName = ATTR_NAME_QUALIFIED_NAME;
            if (!entityHeader.getAttributes().containsKey(uniqueAttrName)) {
                uniqueAttrName = this.getUniqueAttributeName(entityType);
            }
            return uniqueAttrName;
        }

        private String getUniqueAttributeName(AtlasEntityType entityType) {
            return (String)((Map.Entry)entityType.getUniqAttributes().entrySet().stream().findFirst().get()).getKey();
        }

        private void summarize(String ... s) {
            this.summarizeFormat(PROCESS_FORMAT, s);
        }

        private void summarizeFormat(String format, String ... s) {
            this.summarize(String.format(format, s));
        }

        private void summarize(String s) {
            this.actionSummary.append(String.format(JSONIFY_STRING_FORMAT, s));
        }

        private String getJsonArray(StringBuilder actionSummary) {
            return "[" + StringUtils.removeEnd((String)actionSummary.toString(), (String)",") + "]";
        }
    }

    public static class Retriever {
        private final EntityAuditRepository auditRepository;
        private final EntityGraphRetriever entityRetriever;

        public Retriever(AtlasGraph graph, AtlasTypeRegistry typeRegistry, EntityAuditRepository auditRepository) {
            this.entityRetriever = new EntityGraphRetriever(graph, typeRegistry);
            this.auditRepository = auditRepository;
        }

        public Retriever(AtlasTypeRegistry typeRegistry, EntityAuditRepository auditRepository) {
            this(AtlasGraphProvider.getGraphInstance(), typeRegistry, auditRepository);
        }

        Retriever(EntityGraphRetriever entityGraphRetriever, EntityAuditRepository auditRepository) {
            this.entityRetriever = entityGraphRetriever;
            this.auditRepository = auditRepository;
        }

        public AtlasEntityHeaders get(long fromTimestamp, long toTimestamp) throws AtlasBaseException {
            toTimestamp = this.incrementTimestamp(toTimestamp);
            Set<String> guids = this.auditRepository.getEntitiesWithTagChanges(fromTimestamp, toTimestamp);
            HashMap<String, AtlasEntityHeader> guidEntityHeaderMap = new HashMap<String, AtlasEntityHeader>();
            for (String guid : guids) {
                AtlasEntityHeader entityHeader = this.getEntityHeaderByGuid(guid);
                if (entityHeader == null) continue;
                guidEntityHeaderMap.put(guid, entityHeader);
            }
            guids.clear();
            return new AtlasEntityHeaders(guidEntityHeaderMap);
        }

        private AtlasEntityHeader getEntityHeaderByGuid(String guid) {
            try {
                return this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
            }
            catch (AtlasBaseException e) {
                LOG.error("Error fetching entity: {}", (Object)guid, (Object)e);
                return null;
            }
        }

        private long incrementTimestamp(long t) {
            return t + 1L;
        }
    }
}

