/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.EntityGraphDiscoveryContext;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.commons.lang.StringUtils;

public class EntityMutationContext {
    private final EntityGraphDiscoveryContext context;
    private final List<AtlasEntity> entitiesCreated = new ArrayList<AtlasEntity>();
    private final List<AtlasEntity> entitiesUpdated = new ArrayList<AtlasEntity>();
    private final Map<String, AtlasEntityType> entityVsType = new HashMap<String, AtlasEntityType>();
    private final Map<String, AtlasVertex> entityVsVertex = new HashMap<String, AtlasVertex>();
    private final Map<String, String> guidAssignments = new HashMap<String, String>();
    private List<AtlasVertex> entitiesToDelete = null;

    public EntityMutationContext(EntityGraphDiscoveryContext context) {
        this.context = context;
    }

    public EntityMutationContext() {
        this.context = null;
    }

    public void addCreated(String internalGuid, AtlasEntity entity, AtlasEntityType type, AtlasVertex atlasVertex) {
        this.entitiesCreated.add(entity);
        this.entityVsType.put(entity.getGuid(), type);
        this.entityVsVertex.put(entity.getGuid(), atlasVertex);
        if (!StringUtils.equals((String)internalGuid, (String)entity.getGuid())) {
            this.guidAssignments.put(internalGuid, entity.getGuid());
            this.entityVsVertex.put(internalGuid, atlasVertex);
        }
    }

    public void addUpdated(String internalGuid, AtlasEntity entity, AtlasEntityType type, AtlasVertex atlasVertex) {
        if (!this.entityVsVertex.containsKey(internalGuid)) {
            this.entitiesUpdated.add(entity);
            this.entityVsType.put(entity.getGuid(), type);
            this.entityVsVertex.put(entity.getGuid(), atlasVertex);
            if (!StringUtils.equals((String)internalGuid, (String)entity.getGuid())) {
                this.guidAssignments.put(internalGuid, entity.getGuid());
                this.entityVsVertex.put(internalGuid, atlasVertex);
            }
        }
    }

    public void addEntityToDelete(AtlasVertex vertex) {
        if (this.entitiesToDelete == null) {
            this.entitiesToDelete = new ArrayList<AtlasVertex>();
        }
        this.entitiesToDelete.add(vertex);
    }

    public void cacheEntity(String guid, AtlasVertex vertex, AtlasEntityType entityType) {
        this.entityVsType.put(guid, entityType);
        this.entityVsVertex.put(guid, vertex);
    }

    public EntityGraphDiscoveryContext getDiscoveryContext() {
        return this.context;
    }

    public Collection<AtlasEntity> getCreatedEntities() {
        return this.entitiesCreated;
    }

    public Collection<AtlasEntity> getUpdatedEntities() {
        return this.entitiesUpdated;
    }

    public Map<String, String> getGuidAssignments() {
        return this.guidAssignments;
    }

    public List<AtlasVertex> getEntitiesToDelete() {
        return this.entitiesToDelete;
    }

    public AtlasEntityType getType(String guid) {
        return this.entityVsType.get(guid);
    }

    public AtlasVertex getVertex(String guid) {
        return this.entityVsVertex.get(guid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityMutationContext that = (EntityMutationContext)o;
        return Objects.equals(this.context, that.context) && Objects.equals(this.entitiesCreated, that.entitiesCreated) && Objects.equals(this.entitiesUpdated, that.entitiesUpdated) && Objects.equals(this.entityVsType, that.entityVsType) && Objects.equals(this.entityVsVertex, that.entityVsVertex);
    }

    public int hashCode() {
        int result = this.context != null ? this.context.hashCode() : 0;
        result = 31 * result + this.entitiesCreated.hashCode();
        result = 31 * result + this.entitiesUpdated.hashCode();
        result = 31 * result + this.entityVsType.hashCode();
        result = 31 * result + this.entityVsVertex.hashCode();
        return result;
    }

    public String toString() {
        return "EntityMutationContext{context=" + this.context + ", entitiesCreated=" + this.entitiesCreated + ", entitiesUpdated=" + this.entitiesUpdated + ", entityVsType=" + this.entityVsType + ", entityVsVertex=" + this.entityVsVertex + '}';
    }

    public AtlasEntity getCreatedEntity(String parentGuid) {
        return this.getFromCollection(parentGuid, this.getCreatedEntities());
    }

    public AtlasEntity getUpdatedEntity(String parentGuid) {
        return this.getFromCollection(parentGuid, this.getUpdatedEntities());
    }

    public boolean isDeletedEntity(AtlasVertex vertex) {
        return this.entitiesToDelete != null && this.entitiesToDelete.contains(vertex);
    }

    private AtlasEntity getFromCollection(String parentGuid, Collection<AtlasEntity> coll) {
        for (AtlasEntity e : coll) {
            if (!e.getGuid().equalsIgnoreCase(parentGuid)) continue;
            return e;
        }
        return null;
    }

    public AtlasEntity getCreatedOrUpdatedEntity(String parentGuid) {
        AtlasEntity e = this.getCreatedEntity(parentGuid);
        if (e == null) {
            return this.getUpdatedEntity(parentGuid);
        }
        return e;
    }
}

