/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMetricJVMUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMetricJVMUtil.class);
    private static final RuntimeMXBean RUNTIME = ManagementFactory.getRuntimeMXBean();
    private static final OperatingSystemMXBean OS = ManagementFactory.getOperatingSystemMXBean();
    private static final MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();

    public static Map<String, Object> getRuntimeInfo() {
        LinkedHashMap<String, Object> vmDetails = new LinkedHashMap<String, Object>();
        vmDetails.put("name", RUNTIME.getVmName());
        vmDetails.put("version", RUNTIME.getSystemProperties().get("java.version"));
        return vmDetails;
    }

    public static Map<String, Object> getMemoryDetails() {
        LinkedHashMap<String, Object> memory = new LinkedHashMap<String, Object>();
        AtlasMetricJVMUtil.heapDetails(memory);
        AtlasMetricJVMUtil.pooldivision(memory);
        return memory;
    }

    public static Map<String, Object> getSystemInfo() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        CharSequence[] osInfo = new String[]{OS.getName(), OS.getArch(), OS.getVersion()};
        values.put("os.spec", String.join((CharSequence)", ", osInfo));
        values.put("os.vcpus", String.valueOf(OS.getAvailableProcessors()));
        return values;
    }

    private static void pooldivision(Map<String, Object> memory) {
        LinkedHashMap<String, MemoryUsage> poolDivisionValues = new LinkedHashMap<String, MemoryUsage>();
        for (MemoryPoolMXBean mpBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (mpBean.getType() != MemoryType.HEAP) continue;
            poolDivisionValues.put(mpBean.getName(), mpBean.getUsage());
        }
        memory.put("memory_pool_usages", poolDivisionValues);
    }

    private static void heapDetails(Map<String, Object> memory) {
        MemoryUsage memHeapUsage = memBean.getHeapMemoryUsage();
        MemoryUsage nonHeapUsage = memBean.getNonHeapMemoryUsage();
        memory.put("heapInit", String.valueOf(memHeapUsage.getInit()));
        memory.put("heapMax", String.valueOf(memHeapUsage.getMax()));
        memory.put("heapCommitted", String.valueOf(memHeapUsage.getCommitted()));
        memory.put("heapUsed", String.valueOf(memHeapUsage.getUsed()));
        memory.put("nonHeapInit", String.valueOf(nonHeapUsage.getInit()));
        memory.put("nonHeapMax", String.valueOf(nonHeapUsage.getMax()));
        memory.put("nonHeapCommitted", String.valueOf(nonHeapUsage.getCommitted()));
        memory.put("nonHeapUsed", String.valueOf(nonHeapUsage.getUsed()));
    }
}

