/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.util;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.Constants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FileUtils {
    public static final String PIPE_CHARACTER = "|";
    public static final String COLON_CHARACTER = ":";
    public static final String ESCAPE_CHARACTER = "\\";
    public static final int TYPENAME_COLUMN_INDEX = 0;
    public static final int UNIQUE_ATTR_VALUE_COLUMN_INDEX = 1;
    public static final int BM_ATTR_NAME_COLUMN_INDEX = 2;
    public static final int BM_ATTR_VALUE_COLUMN_INDEX = 3;
    public static final int UNIQUE_ATTR_NAME_COLUMN_INDEX = 4;

    public static List<String[]> readFileData(String fileName, InputStream inputStream) throws AtlasBaseException {
        List<String[]> ret;
        String extension = FilenameUtils.getExtension((String)fileName);
        if (extension.equalsIgnoreCase(Constants.SupportedFileExtensions.CSV.name())) {
            ret = FileUtils.readCSV(inputStream);
        } else if (extension.equalsIgnoreCase(Constants.SupportedFileExtensions.XLS.name()) || extension.equalsIgnoreCase(Constants.SupportedFileExtensions.XLSX.name())) {
            ret = FileUtils.readExcel(inputStream, extension);
        } else {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_FILE_TYPE, new String[]{fileName});
        }
        if (CollectionUtils.isEmpty(ret)) {
            throw new AtlasBaseException(AtlasErrorCode.NO_DATA_FOUND, new String[0]);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String[]> readCSV(InputStream inputStream) throws AtlasBaseException {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader(inputStream));){
            String[] data;
            String[] header = csvReader.readNext();
            if (header == null || header.length == 0) {
                ArrayList<String[]> arrayList = ret;
                return arrayList;
            }
            while ((data = csvReader.readNext()) != null) {
                if (data.length <= 1) continue;
                ret.add(data);
            }
            return ret;
        }
        catch (CsvValidationException | IOException e) {
            throw new AtlasBaseException(AtlasErrorCode.NOT_VALID_FILE, new String[]{Constants.SupportedFileExtensions.CSV.name()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String[]> readExcel(InputStream inputStream, String extension) throws AtlasBaseException {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        try (HSSFWorkbook excelBook = extension.equalsIgnoreCase(Constants.SupportedFileExtensions.XLS.name()) ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);){
            Sheet excelSheet = excelBook.getSheetAt(0);
            Iterator itr = excelSheet.rowIterator();
            Row headerRow = (Row)itr.next();
            if (FileUtils.isRowEmpty(headerRow)) {
                ArrayList<String[]> arrayList = ret;
                return arrayList;
            }
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                if (FileUtils.isRowEmpty(row)) continue;
                String[] data = new String[row.getLastCellNum()];
                for (int i = 0; i < row.getLastCellNum(); ++i) {
                    data[i] = row.getCell(i) != null ? row.getCell(i).getStringCellValue().trim() : null;
                }
                ret.add(data);
            }
            return ret;
        }
        catch (IOException e) {
            throw new AtlasBaseException(AtlasErrorCode.NOT_VALID_FILE, new String[]{Constants.SupportedFileExtensions.XLS.name()});
        }
    }

    private static boolean isRowEmpty(Row row) {
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    public static String getBusinessMetadataHeaders() {
        ArrayList<String> bMHeader = new ArrayList<String>();
        bMHeader.add("EntityType");
        bMHeader.add("EntityUniqueAttributeValue");
        bMHeader.add("BusinessAttributeName");
        bMHeader.add("BusinessAttributeValue");
        bMHeader.add("EntityUniqueAttributeName[optional]");
        return StringUtils.join(bMHeader, (String)",");
    }
}

