/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnIndex {
    public final List<IndexHelper.IndexInfo> columnsIndex;
    private static final ColumnIndex EMPTY = new ColumnIndex(Collections.emptyList());

    private ColumnIndex(List<IndexHelper.IndexInfo> columnsIndex) {
        assert (columnsIndex != null);
        this.columnsIndex = columnsIndex;
    }

    @VisibleForTesting
    public static ColumnIndex nothing() {
        return EMPTY;
    }

    public static class Builder {
        private final ColumnIndex result;
        private final long indexOffset;
        private long startPosition = -1L;
        private long endPosition = 0L;
        private long blockSize;
        private OnDiskAtom firstColumn;
        private OnDiskAtom lastColumn;
        private OnDiskAtom lastBlockClosing;
        private final DataOutputPlus output;
        private final RangeTombstone.Tracker tombstoneTracker;
        private int atomCount;
        private final ByteBuffer key;
        private final DeletionInfo deletionInfo;
        private final OnDiskAtom.Serializer atomSerializer;

        public Builder(ColumnFamily cf, ByteBuffer key, DataOutputPlus output) {
            assert (cf != null);
            assert (key != null);
            assert (output != null);
            this.key = key;
            this.deletionInfo = cf.deletionInfo();
            this.indexOffset = Builder.rowHeaderSize(key, this.deletionInfo);
            this.result = new ColumnIndex(new ArrayList());
            this.output = output;
            this.tombstoneTracker = new RangeTombstone.Tracker(cf.getComparator());
            this.atomSerializer = cf.getComparator().onDiskAtomSerializer();
        }

        private static long rowHeaderSize(ByteBuffer key, DeletionInfo delInfo) {
            TypeSizes typeSizes = TypeSizes.NATIVE;
            int keysize = key.remaining();
            return (long)(typeSizes.sizeof((short)keysize) + keysize) + DeletionTime.serializer.serializedSize(delInfo.getTopLevelDeletion(), typeSizes);
        }

        public RangeTombstone.Tracker tombstoneTracker() {
            return this.tombstoneTracker;
        }

        public int writtenAtomCount() {
            return this.atomCount + this.tombstoneTracker.writtenAtom();
        }

        public ColumnIndex build(ColumnFamily cf) throws IOException {
            CellNameType comparator = cf.getComparator();
            DeletionInfo.InOrderTester tester = cf.deletionInfo().inOrderTester();
            Iterator<RangeTombstone> rangeIter = cf.deletionInfo().rangeIterator();
            RangeTombstone tombstone = rangeIter.hasNext() ? rangeIter.next() : null;
            for (Cell c : cf) {
                while (tombstone != null && comparator.compare(c.name(), tombstone.min) >= 0) {
                    if (!cf.deletionInfo().getTopLevelDeletion().isDeleted(tombstone)) {
                        this.add(tombstone);
                    }
                    tombstone = rangeIter.hasNext() ? rangeIter.next() : null;
                }
                if (tester.isDeleted(c)) continue;
                this.add(c);
            }
            while (tombstone != null) {
                this.add(tombstone);
                tombstone = rangeIter.hasNext() ? rangeIter.next() : null;
            }
            ColumnIndex index = this.build();
            this.maybeWriteEmptyRowHeader();
            return index;
        }

        public ColumnIndex buildForCompaction(Iterator<OnDiskAtom> columns) throws IOException {
            while (columns.hasNext()) {
                OnDiskAtom c = columns.next();
                this.add(c);
            }
            return this.build();
        }

        public void add(OnDiskAtom column) throws IOException {
            ++this.atomCount;
            if (this.firstColumn == null) {
                this.firstColumn = column;
                this.startPosition = this.endPosition;
                this.endPosition += this.tombstoneTracker.writeOpenedMarker(this.firstColumn, this.output, this.atomSerializer);
                this.blockSize = 0L;
            }
            long size = this.atomSerializer.serializedSizeForSSTable(column);
            this.endPosition += size;
            this.blockSize += size;
            if (this.blockSize >= (long)DatabaseDescriptor.getColumnIndexSize()) {
                IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(this.firstColumn.name(), column.name(), this.indexOffset + this.startPosition, this.endPosition - this.startPosition);
                this.result.columnsIndex.add(cIndexInfo);
                this.firstColumn = null;
                this.lastBlockClosing = column;
            }
            this.maybeWriteRowHeader();
            this.atomSerializer.serializeForSSTable(column, this.output);
            this.tombstoneTracker.update(column, false);
            this.lastColumn = column;
        }

        private void maybeWriteRowHeader() throws IOException {
            if (this.lastColumn == null) {
                ByteBufferUtil.writeWithShortLength(this.key, this.output);
                DeletionTime.serializer.serialize(this.deletionInfo.getTopLevelDeletion(), this.output);
            }
        }

        public ColumnIndex build() {
            if (this.lastColumn == null) {
                return EMPTY;
            }
            if (this.result.columnsIndex.isEmpty() || this.lastBlockClosing != this.lastColumn) {
                IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(this.firstColumn.name(), this.lastColumn.name(), this.indexOffset + this.startPosition, this.endPosition - this.startPosition);
                this.result.columnsIndex.add(cIndexInfo);
            }
            assert (this.result.columnsIndex.size() > 0);
            return this.result;
        }

        public void maybeWriteEmptyRowHeader() throws IOException {
            if (!this.deletionInfo.isLive()) {
                this.maybeWriteRowHeader();
            }
        }
    }
}

