/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;

public class TruncateResponse {
    public static final TruncateResponseSerializer serializer = new TruncateResponseSerializer();
    public final String keyspace;
    public final String columnFamily;
    public final boolean success;

    public TruncateResponse(String keyspace, String columnFamily, boolean success) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.success = success;
    }

    public MessageOut<TruncateResponse> createMessage() {
        return new MessageOut<TruncateResponse>(MessagingService.Verb.REQUEST_RESPONSE, this, serializer);
    }

    public static class TruncateResponseSerializer
    implements IVersionedSerializer<TruncateResponse> {
        @Override
        public void serialize(TruncateResponse tr, DataOutputPlus out, int version) throws IOException {
            out.writeUTF(tr.keyspace);
            out.writeUTF(tr.columnFamily);
            out.writeBoolean(tr.success);
        }

        @Override
        public TruncateResponse deserialize(DataInput in, int version) throws IOException {
            String keyspace = in.readUTF();
            String columnFamily = in.readUTF();
            boolean success = in.readBoolean();
            return new TruncateResponse(keyspace, columnFamily, success);
        }

        @Override
        public long serializedSize(TruncateResponse tr, int version) {
            return TypeSizes.NATIVE.sizeof(tr.keyspace) + TypeSizes.NATIVE.sizeof(tr.columnFamily) + TypeSizes.NATIVE.sizeof(tr.success);
        }
    }
}

