/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;

public class BytesToken
extends Token {
    static final long serialVersionUID = -2630749093733680626L;
    final byte[] token;

    public BytesToken(ByteBuffer token) {
        this(ByteBufferUtil.getArray(token));
    }

    public BytesToken(byte[] token) {
        this.token = token;
    }

    public String toString() {
        return Hex.bytesToHex(this.token);
    }

    @Override
    public int compareTo(Token other) {
        BytesToken o = (BytesToken)other;
        return FBUtilities.compareUnsigned(this.token, o.token, 0, 0, this.token.length, o.token.length);
    }

    public int hashCode() {
        int prime = 31;
        return 31 + Arrays.hashCode(this.token);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BytesToken)) {
            return false;
        }
        BytesToken other = (BytesToken)obj;
        return Arrays.equals(this.token, other.token);
    }

    public byte[] getTokenValue() {
        return this.token;
    }
}

