/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.cassandra.repair.IRequestCoordinator;
import org.apache.cassandra.repair.IRequestProcessor;

public class SequentialRequestCoordinator<R>
implements IRequestCoordinator<R> {
    private final Queue<R> requests = new LinkedList<R>();
    private final IRequestProcessor<R> processor;

    public SequentialRequestCoordinator(IRequestProcessor<R> processor) {
        this.processor = processor;
    }

    @Override
    public void add(R request) {
        this.requests.add(request);
    }

    @Override
    public void start() {
        if (this.requests.isEmpty()) {
            return;
        }
        this.processor.process(this.requests.peek());
    }

    @Override
    public int completed(R request) {
        assert (request.equals(this.requests.peek()));
        this.requests.poll();
        int remaining = this.requests.size();
        if (remaining != 0) {
            this.processor.process(this.requests.peek());
        }
        return remaining;
    }
}

