/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataOutputPlus;

public class StreamingHistogram {
    public static final StreamingHistogramSerializer serializer = new StreamingHistogramSerializer();
    private final TreeMap<Double, Long> bin;
    private final int maxBinSize;

    public StreamingHistogram(int maxBinSize) {
        this.maxBinSize = maxBinSize;
        this.bin = new TreeMap();
    }

    private StreamingHistogram(int maxBinSize, Map<Double, Long> bin) {
        this.maxBinSize = maxBinSize;
        this.bin = new TreeMap<Double, Long>(bin);
    }

    public void update(double p) {
        this.update(p, 1L);
    }

    public void update(double p, long m) {
        Long mi = this.bin.get(p);
        if (mi != null) {
            this.bin.put(p, mi + m);
        } else {
            this.bin.put(p, m);
            while (this.bin.size() > this.maxBinSize) {
                Iterator<Double> keys = this.bin.keySet().iterator();
                double p1 = keys.next();
                double p2 = keys.next();
                double smallestDiff = p2 - p1;
                double q1 = p1;
                double q2 = p2;
                while (keys.hasNext()) {
                    p1 = p2;
                    p2 = keys.next();
                    double diff = p2 - p1;
                    if (!(diff < smallestDiff)) continue;
                    smallestDiff = diff;
                    q1 = p1;
                    q2 = p2;
                }
                long k1 = this.bin.remove(q1);
                long k2 = this.bin.remove(q2);
                this.bin.put((q1 * (double)k1 + q2 * (double)k2) / (double)(k1 + k2), k1 + k2);
            }
        }
    }

    public void merge(StreamingHistogram other) {
        if (other == null) {
            return;
        }
        for (Map.Entry<Double, Long> entry : other.getAsMap().entrySet()) {
            this.update(entry.getKey(), entry.getValue());
        }
    }

    public double sum(double b) {
        double sum = 0.0;
        Map.Entry<Double, Long> pnext = this.bin.higherEntry(b);
        if (pnext == null) {
            for (Long value : this.bin.values()) {
                sum += (double)value.longValue();
            }
        } else {
            Map.Entry<Double, Long> pi = this.bin.floorEntry(b);
            if (pi == null) {
                return 0.0;
            }
            double weight = (b - pi.getKey()) / (pnext.getKey() - pi.getKey());
            double mb = (double)pi.getValue().longValue() + (double)(pnext.getValue() - pi.getValue()) * weight;
            sum += ((double)pi.getValue().longValue() + mb) * weight / 2.0;
            sum += (double)pi.getValue().longValue() / 2.0;
            for (Long value : this.bin.headMap(pi.getKey(), false).values()) {
                sum += (double)value.longValue();
            }
        }
        return sum;
    }

    public Map<Double, Long> getAsMap() {
        return Collections.unmodifiableMap(this.bin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamingHistogram)) {
            return false;
        }
        StreamingHistogram that = (StreamingHistogram)o;
        return this.maxBinSize == that.maxBinSize && this.bin.equals(that.bin);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bin.hashCode(), this.maxBinSize});
    }

    public static class StreamingHistogramSerializer
    implements ISerializer<StreamingHistogram> {
        @Override
        public void serialize(StreamingHistogram histogram, DataOutputPlus out) throws IOException {
            out.writeInt(histogram.maxBinSize);
            Map<Double, Long> entries = histogram.getAsMap();
            out.writeInt(entries.size());
            for (Map.Entry<Double, Long> entry : entries.entrySet()) {
                out.writeDouble(entry.getKey());
                out.writeLong(entry.getValue());
            }
        }

        @Override
        public StreamingHistogram deserialize(DataInput in) throws IOException {
            int maxBinSize = in.readInt();
            int size = in.readInt();
            HashMap<Double, Long> tmp = new HashMap<Double, Long>(size);
            for (int i = 0; i < size; ++i) {
                tmp.put(in.readDouble(), in.readLong());
            }
            return new StreamingHistogram(maxBinSize, tmp);
        }

        @Override
        public long serializedSize(StreamingHistogram histogram, TypeSizes typeSizes) {
            long size = typeSizes.sizeof(histogram.maxBinSize);
            Map<Double, Long> entries = histogram.getAsMap();
            size += (long)typeSizes.sizeof(entries.size());
            return size += (long)(entries.size() * 16);
        }
    }
}

