/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.OptionsStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SackStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SideEffectStrategy;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.ConstantSupplier;

public interface TraversalSource
extends Cloneable,
AutoCloseable {
    public TraversalStrategies getStrategies();

    public Graph getGraph();

    public Bytecode getBytecode();

    default public TraversalSource with(String key) {
        return this.with(key, true);
    }

    default public TraversalSource with(String key, Object value) {
        OptionsStrategy.Builder builder = OptionsStrategy.build();
        this.getStrategies().getStrategy(OptionsStrategy.class).ifPresent(optionsStrategy -> optionsStrategy.getOptions().forEach(builder::with));
        builder.with(key, value);
        return this.withStrategies(builder.create());
    }

    default public TraversalSource withStrategies(TraversalStrategy ... traversalStrategies) {
        TraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(traversalStrategies);
        clone.getBytecode().addSource("withStrategies", traversalStrategies);
        for (TraversalStrategy traversalStrategy : traversalStrategies) {
            if (!(traversalStrategy instanceof VertexProgramStrategy)) continue;
            ((VertexProgramStrategy)traversalStrategy).addGraphComputerStrategies(clone);
        }
        return clone;
    }

    default public TraversalSource withoutStrategies(Class<? extends TraversalStrategy> ... traversalStrategyClasses) {
        TraversalSource clone = this.clone();
        clone.getStrategies().removeStrategies(traversalStrategyClasses);
        clone.getBytecode().addSource("withoutStrategies", traversalStrategyClasses);
        return clone;
    }

    default public TraversalSource withComputer(Computer computer) {
        return this.withStrategies(new VertexProgramStrategy(computer));
    }

    default public TraversalSource withComputer(Class<? extends GraphComputer> graphComputerClass) {
        return this.withStrategies(new VertexProgramStrategy(Computer.compute(graphComputerClass)));
    }

    default public TraversalSource withComputer() {
        return this.withStrategies(new VertexProgramStrategy(Computer.compute()));
    }

    default public <A> TraversalSource withSideEffect(String key, Supplier<A> initialValue, BinaryOperator<A> reducer) {
        TraversalSource clone = this.clone();
        SideEffectStrategy.addSideEffect(clone.getStrategies(), key, initialValue, reducer);
        clone.getBytecode().addSource("withSideEffect", key, initialValue, reducer);
        return clone;
    }

    default public <A> TraversalSource withSideEffect(String key, A initialValue, BinaryOperator<A> reducer) {
        TraversalSource clone = this.clone();
        SideEffectStrategy.addSideEffect(clone.getStrategies(), key, initialValue, reducer);
        clone.getBytecode().addSource("withSideEffect", key, initialValue, reducer);
        return clone;
    }

    default public <A> TraversalSource withSideEffect(String key, Supplier<A> initialValue) {
        TraversalSource clone = this.clone();
        SideEffectStrategy.addSideEffect(clone.getStrategies(), key, initialValue, null);
        clone.getBytecode().addSource("withSideEffect", key, initialValue);
        return clone;
    }

    default public <A> TraversalSource withSideEffect(String key, A initialValue) {
        TraversalSource clone = this.clone();
        SideEffectStrategy.addSideEffect(clone.getStrategies(), key, initialValue, null);
        clone.getBytecode().addSource("withSideEffect", key, initialValue);
        return clone;
    }

    default public <A> TraversalSource withSack(Supplier<A> initialValue, UnaryOperator<A> splitOperator, BinaryOperator<A> mergeOperator) {
        TraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(SackStrategy.build().initialValue(initialValue).splitOperator(splitOperator).mergeOperator(mergeOperator).create());
        clone.getBytecode().addSource("withSack", initialValue, splitOperator, mergeOperator);
        return clone;
    }

    default public <A> TraversalSource withSack(A initialValue, UnaryOperator<A> splitOperator, BinaryOperator<A> mergeOperator) {
        TraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(SackStrategy.build().initialValue(new ConstantSupplier<A>(initialValue)).splitOperator(splitOperator).mergeOperator(mergeOperator).create());
        clone.getBytecode().addSource("withSack", initialValue, splitOperator, mergeOperator);
        return clone;
    }

    default public <A> TraversalSource withSack(A initialValue) {
        TraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(SackStrategy.build().initialValue(new ConstantSupplier<A>(initialValue)).create());
        clone.getBytecode().addSource("withSack", initialValue);
        return clone;
    }

    default public <A> TraversalSource withSack(Supplier<A> initialValue) {
        TraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(SackStrategy.build().initialValue(initialValue).create());
        clone.getBytecode().addSource("withSack", initialValue);
        return clone;
    }

    default public <A> TraversalSource withSack(Supplier<A> initialValue, UnaryOperator<A> splitOperator) {
        TraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(SackStrategy.build().initialValue(initialValue).splitOperator(splitOperator).create());
        clone.getBytecode().addSource("withSack", initialValue, splitOperator);
        return clone;
    }

    default public <A> TraversalSource withSack(A initialValue, UnaryOperator<A> splitOperator) {
        TraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(SackStrategy.build().initialValue(new ConstantSupplier<A>(initialValue)).splitOperator(splitOperator).create());
        clone.getBytecode().addSource("withSack", initialValue, splitOperator);
        return clone;
    }

    default public <A> TraversalSource withSack(Supplier<A> initialValue, BinaryOperator<A> mergeOperator) {
        TraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(SackStrategy.build().initialValue(initialValue).mergeOperator(mergeOperator).create());
        clone.getBytecode().addSource("withSack", initialValue, mergeOperator);
        return clone;
    }

    default public <A> TraversalSource withSack(A initialValue, BinaryOperator<A> mergeOperator) {
        TraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(SackStrategy.build().initialValue(new ConstantSupplier<A>(initialValue)).mergeOperator(mergeOperator).create());
        clone.getBytecode().addSource("withSack", initialValue, mergeOperator);
        return clone;
    }

    @Deprecated
    default public TraversalSource withRemote(Configuration conf) {
        RemoteConnection remoteConnection;
        if (!conf.containsKey("gremlin.remote.remoteConnectionClass")) {
            throw new IllegalArgumentException("Configuration must contain the 'gremlin.remote.remoteConnectionClass' key");
        }
        try {
            Class<RemoteConnection> clazz = Class.forName(conf.getString("gremlin.remote.remoteConnectionClass")).asSubclass(RemoteConnection.class);
            Constructor<RemoteConnection> ctor = clazz.getConstructor(Configuration.class);
            remoteConnection = ctor.newInstance(conf);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return this.withRemote(remoteConnection);
    }

    @Deprecated
    default public TraversalSource withRemote(String configFile) throws Exception {
        return this.withRemote((Configuration)new PropertiesConfiguration(configFile));
    }

    @Deprecated
    public TraversalSource withRemote(RemoteConnection var1);

    default public Optional<Class> getAnonymousTraversalClass() {
        return Optional.empty();
    }

    public TraversalSource clone();

    @Override
    default public void close() throws Exception {
    }

    public static class Symbols {
        public static final String with = "with";
        public static final String withSack = "withSack";
        public static final String withStrategies = "withStrategies";
        public static final String withoutStrategies = "withoutStrategies";
        public static final String withComputer = "withComputer";
        public static final String withSideEffect = "withSideEffect";
        public static final String withRemote = "withRemote";

        private Symbols() {
        }
    }
}

