/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.HashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;

public final class HaltedTraverserStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final Class haltedTraverserFactory;
    private final boolean useReference;
    public static final String HALTED_TRAVERSER_FACTORY = "haltedTraverserFactory";

    private HaltedTraverserStrategy(Class haltedTraverserFactory) {
        if (!haltedTraverserFactory.equals(DetachedFactory.class) && !haltedTraverserFactory.equals(ReferenceFactory.class)) {
            throw new IllegalArgumentException("The provided traverser detachment factory is unknown: " + haltedTraverserFactory);
        }
        this.haltedTraverserFactory = haltedTraverserFactory;
        this.useReference = ReferenceFactory.class.equals((Object)this.haltedTraverserFactory);
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
    }

    public Class getHaltedTraverserFactory() {
        return this.haltedTraverserFactory;
    }

    public <R> Traverser.Admin<R> halt(Traverser.Admin<R> traverser) {
        if (this.useReference) {
            traverser.set(ReferenceFactory.detach(traverser.get()));
        } else {
            traverser.set(DetachedFactory.detach(traverser.get(), true));
        }
        return traverser;
    }

    public static HaltedTraverserStrategy create(Configuration configuration) {
        try {
            return new HaltedTraverserStrategy(Class.forName(configuration.getString(HALTED_TRAVERSER_FACTORY)));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Configuration getConfiguration() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("strategy", HaltedTraverserStrategy.class.getCanonicalName());
        map.put(HALTED_TRAVERSER_FACTORY, this.haltedTraverserFactory.getCanonicalName());
        return new MapConfiguration(map);
    }

    public static HaltedTraverserStrategy detached() {
        return new HaltedTraverserStrategy(DetachedFactory.class);
    }

    public static HaltedTraverserStrategy reference() {
        return new HaltedTraverserStrategy(ReferenceFactory.class);
    }
}

