/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.berkeleyje;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Put;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.WriteOptions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.berkeleyje.BerkeleyJEStoreManager;
import org.janusgraph.diskstorage.berkeleyje.BerkeleyJETx;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.KVQuery;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.KeySelector;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStore;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyJEKeyValueStore
implements OrderedKeyValueStore {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyJEKeyValueStore.class);
    private static final StaticBuffer.Factory<DatabaseEntry> ENTRY_FACTORY = (array, offset, limit) -> new DatabaseEntry(array, offset, limit - offset);
    @VisibleForTesting
    public static Function<Integer, Integer> ttlConverter = ttl -> (int)Math.max(1L, Duration.of(ttl.intValue(), ChronoUnit.SECONDS).toHours());
    private final Database db;
    private final String name;
    private final BerkeleyJEStoreManager manager;
    private boolean isOpen;

    public BerkeleyJEKeyValueStore(String n, Database data, BerkeleyJEStoreManager m) {
        this.db = data;
        this.name = n;
        this.manager = m;
        this.isOpen = true;
    }

    public DatabaseConfig getConfiguration() throws BackendException {
        try {
            return this.db.getConfig();
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    private static Transaction getTransaction(StoreTransaction txh) {
        Preconditions.checkArgument((txh != null ? 1 : 0) != 0);
        return ((BerkeleyJETx)txh).getTransaction();
    }

    private Cursor openCursor(StoreTransaction txh) throws BackendException {
        Preconditions.checkArgument((txh != null ? 1 : 0) != 0);
        return ((BerkeleyJETx)txh).openCursor(this.db);
    }

    private static void closeCursor(StoreTransaction txh, Cursor cursor) {
        Preconditions.checkArgument((txh != null ? 1 : 0) != 0);
        ((BerkeleyJETx)txh).closeCursor(cursor);
    }

    public synchronized void close() throws BackendException {
        try {
            if (this.isOpen) {
                this.db.close();
            }
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
        if (this.isOpen) {
            this.manager.removeDatabase(this);
        }
        this.isOpen = false;
    }

    public StaticBuffer get(StaticBuffer key, StoreTransaction txh) throws BackendException {
        Transaction tx = BerkeleyJEKeyValueStore.getTransaction(txh);
        try {
            DatabaseEntry databaseKey = (DatabaseEntry)key.as(ENTRY_FACTORY);
            DatabaseEntry data = new DatabaseEntry();
            log.trace("db={}, op=get, tx={}", (Object)this.name, (Object)txh);
            OperationStatus status = this.db.get(tx, databaseKey, data, BerkeleyJEKeyValueStore.getLockMode(txh));
            if (status == OperationStatus.SUCCESS) {
                return BerkeleyJEKeyValueStore.getBuffer(data);
            }
            return null;
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public boolean containsKey(StaticBuffer key, StoreTransaction txh) throws BackendException {
        return this.get(key, txh) != null;
    }

    public void acquireLock(StaticBuffer key, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        if (BerkeleyJEKeyValueStore.getTransaction(txh) == null) {
            log.warn("Attempt to acquire lock with transactions disabled");
        }
    }

    public RecordIterator<KeyValueEntry> getSlice(KVQuery query, final StoreTransaction txh) throws BackendException {
        log.trace("beginning db={}, op=getSlice, tx={}", (Object)this.name, (Object)txh);
        StaticBuffer keyStart = query.getStart();
        final StaticBuffer keyEnd = query.getEnd();
        final KeySelector selector = query.getKeySelector();
        final DatabaseEntry foundKey = (DatabaseEntry)keyStart.as(ENTRY_FACTORY);
        final DatabaseEntry foundData = new DatabaseEntry();
        final Cursor cursor = this.openCursor(txh);
        return new RecordIterator<KeyValueEntry>(){
            private OperationStatus status;
            private KeyValueEntry current;

            public boolean hasNext() {
                if (this.current == null) {
                    this.current = this.getNextEntry();
                }
                return this.current != null;
            }

            public KeyValueEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                KeyValueEntry next = this.current;
                this.current = null;
                return next;
            }

            private KeyValueEntry getNextEntry() {
                if (this.status != null && this.status != OperationStatus.SUCCESS) {
                    return null;
                }
                while (!selector.reachedLimit()) {
                    this.status = this.status == null ? cursor.getSearchKeyRange(foundKey, foundData, BerkeleyJEKeyValueStore.getLockMode(txh)) : cursor.getNext(foundKey, foundData, BerkeleyJEKeyValueStore.getLockMode(txh));
                    if (this.status != OperationStatus.SUCCESS) break;
                    StaticBuffer key = BerkeleyJEKeyValueStore.getBuffer(foundKey);
                    if (key.compareTo((Object)keyEnd) >= 0) {
                        this.status = OperationStatus.NOTFOUND;
                        break;
                    }
                    if (!selector.include(key)) continue;
                    return new KeyValueEntry(key, BerkeleyJEKeyValueStore.getBuffer(foundData));
                }
                return null;
            }

            public void close() {
                BerkeleyJEKeyValueStore.closeCursor(txh, cursor);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Map<KVQuery, RecordIterator<KeyValueEntry>> getSlices(List<KVQuery> queries, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public void insert(StaticBuffer key, StaticBuffer value, StoreTransaction txh, Integer ttl) throws BackendException {
        this.insert(key, value, txh, true, ttl);
    }

    public void insert(StaticBuffer key, StaticBuffer value, StoreTransaction txh, boolean allowOverwrite, Integer ttl) throws BackendException {
        OperationStatus status;
        Transaction tx = BerkeleyJEKeyValueStore.getTransaction(txh);
        log.trace("db={}, op=insert, tx={}", (Object)this.name, (Object)txh);
        WriteOptions writeOptions = null;
        if (ttl != null && ttl > 0) {
            int convertedTtl = ttlConverter.apply(ttl);
            writeOptions = new WriteOptions().setTTL(convertedTtl, TimeUnit.HOURS);
        }
        if (allowOverwrite) {
            OperationResult result = this.db.put(tx, (DatabaseEntry)key.as(ENTRY_FACTORY), (DatabaseEntry)value.as(ENTRY_FACTORY), Put.OVERWRITE, writeOptions);
            EnvironmentFailureException.assertState((result != null ? 1 : 0) != 0);
            status = OperationStatus.SUCCESS;
        } else {
            OperationResult result = this.db.put(tx, (DatabaseEntry)key.as(ENTRY_FACTORY), (DatabaseEntry)value.as(ENTRY_FACTORY), Put.NO_OVERWRITE, writeOptions);
            OperationStatus operationStatus = status = result == null ? OperationStatus.KEYEXIST : OperationStatus.SUCCESS;
        }
        if (status != OperationStatus.SUCCESS) {
            throw new PermanentBackendException("Key already exists on no-overwrite.");
        }
    }

    public void delete(StaticBuffer key, StoreTransaction txh) throws BackendException {
        log.trace("Deletion");
        Transaction tx = BerkeleyJEKeyValueStore.getTransaction(txh);
        try {
            log.trace("db={}, op=delete, tx={}", (Object)this.name, (Object)txh);
            OperationStatus status = this.db.delete(tx, (DatabaseEntry)key.as(ENTRY_FACTORY));
            if (status != OperationStatus.SUCCESS && status != OperationStatus.NOTFOUND) {
                throw new PermanentBackendException("Could not remove: " + status);
            }
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private static StaticBuffer getBuffer(DatabaseEntry entry) {
        return new StaticArrayBuffer(entry.getData(), entry.getOffset(), entry.getOffset() + entry.getSize());
    }

    private static LockMode getLockMode(StoreTransaction txh) {
        return ((BerkeleyJETx)txh).getLockMode();
    }
}

