/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.IsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public class AdjacentVertexFilterOptimizerStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final AdjacentVertexFilterOptimizerStrategy INSTANCE = new AdjacentVertexFilterOptimizerStrategy();

    private AdjacentVertexFilterOptimizerStrategy() {
    }

    public static AdjacentVertexFilterOptimizerStrategy instance() {
        return INSTANCE;
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfClass(TraversalFilterStep.class, traversal).forEach(originalStep -> {
            Traversal.Admin filterTraversal = (Traversal.Admin)originalStep.getLocalChildren().get(0);
            List subSteps = filterTraversal.getSteps();
            OptimizableQueryType type = this.analyzeSubSteps(subSteps);
            if (type != OptimizableQueryType.NONE) {
                this.replaceStep(traversal, type, (TraversalFilterStep)originalStep, subSteps);
            }
        });
    }

    private void replaceStep(Traversal.Admin<?, ?> traversal, OptimizableQueryType type, TraversalFilterStep originalStep, List<Step> steps) {
        Direction direction = this.parseDirection(steps);
        P predicate = this.parsePredicate(type, steps);
        if (direction != null && this.isValidPredicate(type, predicate) && this.isPreviousStepValid(originalStep, direction)) {
            HasContainer hc = new HasContainer(ImplicitKey.ADJACENT_ID.name(), P.eq((Object)predicate.getValue()));
            TraversalHelper.replaceStep((Step)originalStep, (Step)new HasStep(traversal, new HasContainer[]{hc}), traversal);
        }
    }

    private OptimizableQueryType analyzeSubSteps(List<Step> steps) {
        if (steps.size() != 2) {
            return OptimizableQueryType.NONE;
        }
        boolean validFirstStep = steps.get(0) instanceof EdgeVertexStep;
        boolean bl = validFirstStep = validFirstStep || steps.get(0) instanceof EdgeOtherVertexStep;
        if (!validFirstStep) {
            return OptimizableQueryType.NONE;
        }
        if (steps.get(1) instanceof IsStep) {
            return OptimizableQueryType.IS;
        }
        if (steps.get(1) instanceof HasStep) {
            HasStep hasStep = (HasStep)steps.get(1);
            if (hasStep.getHasContainers().size() != 1) {
                return OptimizableQueryType.NONE;
            }
            HasContainer has = (HasContainer)hasStep.getHasContainers().get(0);
            if (has.getKey().equals(T.id.getAccessor())) {
                return OptimizableQueryType.HASID;
            }
            return OptimizableQueryType.NONE;
        }
        return OptimizableQueryType.NONE;
    }

    private boolean isPreviousStepValid(TraversalFilterStep originalStep, Direction direction) {
        VertexStep vertexStep;
        Step previousStep;
        for (previousStep = originalStep.getPreviousStep(); previousStep != EmptyStep.instance() && (previousStep instanceof HasStep || previousStep instanceof IdentityStep); previousStep = previousStep.getPreviousStep()) {
        }
        return previousStep instanceof VertexStep && (vertexStep = (VertexStep)previousStep).returnsEdge() && (direction == Direction.BOTH || direction.equals((Object)vertexStep.getDirection().opposite()));
    }

    private Direction parseDirection(List<Step> steps) {
        if (steps.get(0) instanceof EdgeVertexStep) {
            EdgeVertexStep evs = (EdgeVertexStep)steps.get(0);
            if (evs.getDirection() != Direction.BOTH) {
                return evs.getDirection();
            }
            return null;
        }
        assert (steps.get(0) instanceof EdgeOtherVertexStep);
        return Direction.BOTH;
    }

    private P parsePredicate(OptimizableQueryType type, List<Step> steps) {
        switch (type) {
            case IS: {
                IsStep isStep = (IsStep)steps.get(1);
                return isStep.getPredicate();
            }
            case HASID: {
                HasStep hasStep = (HasStep)steps.get(1);
                HasContainer hasContainer = (HasContainer)hasStep.getHasContainers().get(0);
                return hasContainer.getPredicate();
            }
        }
        return null;
    }

    private boolean isValidPredicate(OptimizableQueryType type, P predicate) {
        if (predicate.getBiPredicate() != Compare.eq) {
            return false;
        }
        switch (type) {
            case IS: {
                return predicate.getValue() instanceof Vertex;
            }
            case HASID: {
                boolean vertexPredicate = predicate.getValue() instanceof Vertex;
                boolean idPredicate = predicate.getValue() instanceof Long;
                return vertexPredicate || idPredicate;
            }
        }
        return false;
    }

    private static enum OptimizableQueryType {
        NONE,
        IS,
        HASID;

    }
}

