/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class JanusGraphMultiQueryStep
extends AbstractStep<Vertex, Vertex> {
    private final Set<Traverser.Admin<Vertex>> cachedStarts = new HashSet<Traverser.Admin<Vertex>>();
    private final String forStep;
    private boolean cachedStartsAccessed = false;

    public JanusGraphMultiQueryStep(Step<Vertex, ?> originalStep) {
        super(originalStep.getTraversal());
        this.forStep = originalStep.getClass().getSimpleName();
    }

    protected Traverser.Admin<Vertex> processNextStart() throws NoSuchElementException {
        Traverser.Admin start = this.starts.next();
        if (!this.cachedStarts.contains(start)) {
            if (this.cachedStartsAccessed) {
                this.cachedStarts.clear();
                this.cachedStartsAccessed = false;
            }
            ArrayList newStarters = new ArrayList();
            this.starts.forEachRemaining(s -> {
                newStarters.add(s);
                this.cachedStarts.add((Traverser.Admin<Vertex>)s);
            });
            this.starts.add(newStarters.iterator());
            this.cachedStarts.add((Traverser.Admin<Vertex>)start);
        }
        return start;
    }

    public List<Traverser.Admin<Vertex>> getCachedStarts() {
        this.cachedStartsAccessed = true;
        return Lists.newArrayList(this.cachedStarts);
    }

    public String toString() {
        return StringFactory.stepString((Step)this, (Object[])new Object[]{this.forStep});
    }

    public void reset() {
        super.reset();
        this.cachedStarts.clear();
    }
}

