/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.encoding;

public final class NumericUtils {
    private NumericUtils() {
    }

    public static long doubleToSortableLong(double val) {
        return NumericUtils.sortableDoubleBits(Double.doubleToLongBits(val));
    }

    public static double sortableLongToDouble(long val) {
        return Double.longBitsToDouble(NumericUtils.sortableDoubleBits(val));
    }

    public static int floatToSortableInt(float val) {
        return NumericUtils.sortableFloatBits(Float.floatToIntBits(val));
    }

    public static float sortableIntToFloat(int val) {
        return Float.intBitsToFloat(NumericUtils.sortableFloatBits(val));
    }

    public static long sortableDoubleBits(long bits) {
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    public static int sortableFloatBits(int bits) {
        return bits ^ bits >> 31 & Integer.MAX_VALUE;
    }
}

