/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaType$AlterLogDirsReplication$;
import kafka.server.QuotaType$Fetch$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.QuotaType$LeaderReplication$;
import kafka.server.QuotaType$Produce$;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class QuotaFactory$
implements Logging {
    public static final QuotaFactory$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new QuotaFactory$();
    }

    private Logger logger$lzycompute() {
        QuotaFactory$ quotaFactory$ = this;
        synchronized (quotaFactory$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public QuotaFactory.QuotaManagers instantiate(KafkaConfig cfg, Metrics metrics, Time time, String threadNamePrefix) {
        Option clientQuotaCallback = Option$.MODULE$.apply(cfg.getConfiguredInstance(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), ClientQuotaCallback.class));
        return new QuotaFactory.QuotaManagers(new ClientQuotaManager(this.clientFetchConfig(cfg), metrics, QuotaType$Fetch$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback), new ClientQuotaManager(this.clientProduceConfig(cfg), metrics, QuotaType$Produce$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback), new ClientRequestQuotaManager(this.clientRequestConfig(cfg), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback), new ReplicationQuotaManager(this.replicationConfig(cfg), metrics, QuotaType$LeaderReplication$.MODULE$, time), new ReplicationQuotaManager(this.replicationConfig(cfg), metrics, QuotaType$FollowerReplication$.MODULE$, time), new ReplicationQuotaManager(this.alterLogDirsReplicationConfig(cfg), metrics, QuotaType$AlterLogDirsReplication$.MODULE$, time), (Option<ClientQuotaCallback>)clientQuotaCallback);
    }

    public ClientQuotaManagerConfig clientProduceConfig(KafkaConfig cfg) {
        if (!BoxesRunTime.equalsNumObject((Number)cfg.producerQuotaBytesPerSecondDefault(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE))) {
            this.warn((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " has been deprecated in 0.11.0.0 and will be removed in a future release. Use dynamic quota defaults instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp()}));
                }
            });
        }
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.producerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()));
    }

    public ClientQuotaManagerConfig clientFetchConfig(KafkaConfig cfg) {
        if (!BoxesRunTime.equalsNumObject((Number)cfg.consumerQuotaBytesPerSecondDefault(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE))) {
            this.warn((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " has been deprecated in 0.11.0.0 and will be removed in a future release. Use dynamic quota defaults instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp()}));
                }
            });
        }
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.consumerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()));
    }

    public ClientQuotaManagerConfig clientRequestConfig(KafkaConfig cfg) {
        int x$2 = Predef$.MODULE$.Integer2int(cfg.numQuotaSamples());
        int x$3 = Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds());
        long x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ClientQuotaManagerConfig(x$4, x$2, x$3);
    }

    public ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg) {
        int x$5 = Predef$.MODULE$.Integer2int(cfg.numReplicationQuotaSamples());
        int x$6 = Predef$.MODULE$.Integer2int(cfg.replicationQuotaWindowSizeSeconds());
        long x$7 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ReplicationQuotaManagerConfig(x$7, x$5, x$6);
    }

    public ReplicationQuotaManagerConfig alterLogDirsReplicationConfig(KafkaConfig cfg) {
        int x$8 = Predef$.MODULE$.Integer2int(cfg.numAlterLogDirsReplicationQuotaSamples());
        int x$9 = Predef$.MODULE$.Integer2int(cfg.alterLogDirsReplicationQuotaWindowSizeSeconds());
        long x$10 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ReplicationQuotaManagerConfig(x$10, x$8, x$9);
    }

    private QuotaFactory$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

