/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.stats.CollectionStats;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.search.stats.StatsSource;
import org.apache.solr.search.stats.StatsUtil;
import org.apache.solr.search.stats.TermStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExactStatsCache
extends StatsCache {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CURRENT_GLOBAL_COL_STATS = "solr.stats.globalCol";
    private static final String CURRENT_GLOBAL_TERM_STATS = "solr.stats.globalTerm";
    private static final String PER_SHARD_TERM_STATS = "solr.stats.shardTerm";
    private static final String PER_SHARD_COL_STATS = "solr.stats.shardCol";

    @Override
    protected StatsSource doGet(SolrQueryRequest req) {
        Map<String, CollectionStats> currentGlobalColStats = req.getContext().getOrDefault(CURRENT_GLOBAL_COL_STATS, Collections.emptyMap());
        Map<String, TermStats> currentGlobalTermStats = req.getContext().getOrDefault(CURRENT_GLOBAL_TERM_STATS, Collections.emptyMap());
        if (log.isDebugEnabled()) {
            log.debug("Returning StatsSource. Collection stats={}, Term stats size= {}", currentGlobalColStats, (Object)currentGlobalTermStats.size());
        }
        return new ExactStatsSource(this.statsCacheMetrics, currentGlobalTermStats, currentGlobalColStats);
    }

    @Override
    protected ShardRequest doRetrieveStatsRequest(ResponseBuilder rb) {
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 32768;
        sreq.params = new ModifiableSolrParams(rb.req.getParams());
        sreq.params.remove("shards");
        return sreq;
    }

    @Override
    protected void doMergeToGlobalStats(SolrQueryRequest req, List<ShardResponse> responses) {
        HashSet<Term> allTerms = new HashSet<Term>();
        for (ShardResponse r : responses) {
            NamedList nl;
            String termStatsString;
            if ("true".equalsIgnoreCase(req.getParams().get("shards.tolerant")) && r.getException() != null) {
                log.debug("Exception shard response={}", (Object)r);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("Merging to global stats, shard={}, response={}", (Object)r.getShard(), (Object)r.getSolrResponse().getResponse());
            }
            String shard = r.getShard();
            SolrResponse res = r.getSolrResponse();
            if (res.getException() != null) {
                log.debug("Exception response={}", (Object)res);
                continue;
            }
            if (res.getResponse().get("shard.name") != null) {
                shard = (String)res.getResponse().get("shard.name");
            }
            if ((termStatsString = (String)(nl = res.getResponse()).get("solr.stats.term")) != null) {
                this.addToPerShardTermStats(req, shard, termStatsString);
            }
            Set<Term> terms = StatsUtil.termsFromEncodedString((String)nl.get("solr.stats.terms"));
            allTerms.addAll(terms);
            String colStatsString = (String)nl.get("solr.stats.col");
            Map<String, CollectionStats> colStats = StatsUtil.colStatsMapFromString(colStatsString);
            if (colStats == null) continue;
            this.addToPerShardColStats(req, shard, colStats);
        }
        if (allTerms.size() > 0) {
            req.getContext().put("solr.stats.terms", StatsUtil.termsToEncodedString(allTerms));
        }
        if (log.isDebugEnabled()) {
            this.printStats(req);
        }
    }

    protected void addToPerShardColStats(SolrQueryRequest req, String shard, Map<String, CollectionStats> colStats) {
        Map perShardColStats = (Map)req.getContext().computeIfAbsent(PER_SHARD_COL_STATS, Utils.NEW_HASHMAP_FUN);
        perShardColStats.put(shard, colStats);
    }

    protected void printStats(SolrQueryRequest req) {
        Map perShardTermStats = req.getContext().getOrDefault(PER_SHARD_TERM_STATS, Collections.emptyMap());
        Map perShardColStats = req.getContext().getOrDefault(PER_SHARD_COL_STATS, Collections.emptyMap());
        log.debug("perShardColStats={}, perShardTermStats={}", perShardColStats, perShardTermStats);
    }

    protected void addToPerShardTermStats(SolrQueryRequest req, String shard, String termStatsString) {
        Map<String, TermStats> termStats = StatsUtil.termStatsMapFromString(termStatsString);
        if (termStats != null) {
            Map perShardTermStats = (Map)req.getContext().computeIfAbsent(PER_SHARD_TERM_STATS, Utils.NEW_HASHMAP_FUN);
            perShardTermStats.put(shard, termStats);
        }
    }

    @Override
    protected void doReturnLocalStats(ResponseBuilder rb, SolrIndexSearcher searcher) {
        Query q = rb.getQuery();
        try {
            Set<Term> additionalTerms = StatsUtil.termsFromEncodedString(rb.req.getParams().get("solr.stats.terms"));
            Set<String> additionalFields = StatsUtil.fieldsFromString(rb.req.getParams().get("solr.stats.fields"));
            final HashSet terms = new HashSet();
            final HashMap<String, TermStats> statsMap = new HashMap<String, TermStats>();
            final HashMap<String, CollectionStats> colMap = new HashMap<String, CollectionStats>();
            IndexSearcher statsCollectingSearcher = new IndexSearcher((IndexReader)searcher.getIndexReader()){

                public CollectionStatistics collectionStatistics(String field) throws IOException {
                    CollectionStatistics cs = super.collectionStatistics(field);
                    if (cs != null) {
                        colMap.put(field, new CollectionStats(cs));
                    }
                    return cs;
                }

                public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
                    TermStatistics ts = super.termStatistics(term, docFreq, totalTermFreq);
                    terms.add(term);
                    statsMap.put(term.toString(), new TermStats(term.field(), ts));
                    return ts;
                }
            };
            statsCollectingSearcher.createWeight(searcher.rewrite(q), ScoreMode.COMPLETE, 1.0f);
            for (String field : additionalFields) {
                if (colMap.containsKey(field)) continue;
                statsCollectingSearcher.collectionStatistics(field);
            }
            for (Term term : additionalTerms) {
                statsCollectingSearcher.createWeight(searcher.rewrite((Query)new TermQuery(term)), ScoreMode.COMPLETE, 1.0f);
            }
            CloudDescriptor cloudDescriptor = searcher.getCore().getCoreDescriptor().getCloudDescriptor();
            if (cloudDescriptor != null) {
                rb.rsp.add("shard.name", cloudDescriptor.getShardId());
            }
            if (!terms.isEmpty()) {
                rb.rsp.add("solr.stats.terms", StatsUtil.termsToEncodedString(terms));
            }
            if (!statsMap.isEmpty()) {
                String termStatsString = StatsUtil.termStatsMapToString(statsMap);
                rb.rsp.add("solr.stats.term", termStatsString);
                if (log.isDebugEnabled()) {
                    log.debug("termStats={}, terms={}, numDocs={}", new Object[]{termStatsString, terms, searcher.maxDoc()});
                }
            }
            if (!colMap.isEmpty()) {
                String colStatsString = StatsUtil.colStatsMapToString(colMap);
                rb.rsp.add("solr.stats.col", colStatsString);
                if (log.isDebugEnabled()) {
                    log.debug("collectionStats={}, terms={}, numDocs={}", new Object[]{colStatsString, terms, searcher.maxDoc()});
                }
            }
        }
        catch (IOException e) {
            log.error("Error collecting local stats, query='{}'", (Object)q, (Object)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error collecting local stats.", (Throwable)e);
        }
    }

    @Override
    protected void doSendGlobalStats(ResponseBuilder rb, ShardRequest outgoing) {
        ModifiableSolrParams params = outgoing.params;
        Set<Term> terms = StatsUtil.termsFromEncodedString((String)rb.req.getContext().get("solr.stats.terms"));
        if (!terms.isEmpty()) {
            Set fields = terms.stream().map(t -> t.field()).collect(Collectors.toSet());
            HashMap<String, TermStats> globalTermStats = new HashMap<String, TermStats>();
            HashMap<String, CollectionStats> globalColStats = new HashMap<String, CollectionStats>();
            String collectionName = rb.req.getCore().getCoreDescriptor().getCollectionName();
            if (collectionName == null) {
                collectionName = rb.req.getCore().getCoreDescriptor().getName();
            }
            ArrayList<String> shards = new ArrayList<String>();
            for (String shardUrl : rb.shards) {
                String shard = StatsUtil.shardUrlToShard(collectionName, shardUrl);
                if (shard == null) {
                    log.warn("Can't determine shard from collectionName={} and shardUrl={}, skipping...", (Object)collectionName, (Object)shardUrl);
                    continue;
                }
                shards.add(shard);
            }
            for (String shard : shards) {
                Map<String, CollectionStats> s = this.getPerShardColStats(rb, shard);
                if (s == null) continue;
                for (Map.Entry<String, CollectionStats> e : s.entrySet()) {
                    if (!fields.contains(e.getKey())) continue;
                    CollectionStats g = (CollectionStats)globalColStats.get(e.getKey());
                    if (g == null) {
                        g = new CollectionStats(e.getKey());
                        globalColStats.put(e.getKey(), g);
                    }
                    g.add(e.getValue());
                }
            }
            params.add("solr.stats.col", new String[]{StatsUtil.colStatsMapToString(globalColStats)});
            params.add("solr.stats.terms", new String[]{StatsUtil.termsToEncodedString(terms)});
            for (Term t2 : terms) {
                String term = t2.toString();
                for (String shard : shards) {
                    TermStats termStats = this.getPerShardTermStats(rb.req, term, shard);
                    if (termStats == null || termStats.docFreq == 0L) continue;
                    TermStats g = (TermStats)globalTermStats.get(term);
                    if (g == null) {
                        g = new TermStats(term);
                        globalTermStats.put(term, g);
                    }
                    g.add(termStats);
                }
            }
            log.debug("terms={}, termStats={}", terms, globalTermStats);
            params.add("solr.stats.term", new String[]{StatsUtil.termStatsMapToString(globalTermStats)});
        }
    }

    protected Map<String, CollectionStats> getPerShardColStats(ResponseBuilder rb, String shard) {
        Map perShardColStats = rb.req.getContext().getOrDefault(PER_SHARD_COL_STATS, Collections.emptyMap());
        return (Map)perShardColStats.get(shard);
    }

    protected TermStats getPerShardTermStats(SolrQueryRequest req, String t, String shard) {
        Map perShardTermStats = req.getContext().getOrDefault(PER_SHARD_TERM_STATS, Collections.emptyMap());
        Map cache = (Map)perShardTermStats.get(shard);
        return cache != null ? (TermStats)cache.get(t) : null;
    }

    @Override
    protected void doReceiveGlobalStats(SolrQueryRequest req) {
        Map<String, CollectionStats> colStats;
        String globalTermStats = req.getParams().get("solr.stats.term");
        String globalColStats = req.getParams().get("solr.stats.col");
        if (globalColStats != null && (colStats = StatsUtil.colStatsMapFromString(globalColStats)) != null) {
            for (Map.Entry<String, CollectionStats> entry : colStats.entrySet()) {
                this.addToGlobalColStats(req, entry);
            }
        }
        log.debug("Global collection stats={}", (Object)globalColStats);
        if (globalTermStats == null) {
            return;
        }
        Map<String, TermStats> termStats = StatsUtil.termStatsMapFromString(globalTermStats);
        if (termStats != null) {
            for (Map.Entry<String, Object> entry : termStats.entrySet()) {
                this.addToGlobalTermStats(req, entry);
            }
        }
    }

    protected void addToGlobalColStats(SolrQueryRequest req, Map.Entry<String, CollectionStats> e) {
        Map currentGlobalColStats = (Map)req.getContext().computeIfAbsent(CURRENT_GLOBAL_COL_STATS, Utils.NEW_HASHMAP_FUN);
        currentGlobalColStats.put(e.getKey(), e.getValue());
    }

    protected void addToGlobalTermStats(SolrQueryRequest req, Map.Entry<String, TermStats> e) {
        Map currentGlobalTermStats = (Map)req.getContext().computeIfAbsent(CURRENT_GLOBAL_TERM_STATS, Utils.NEW_HASHMAP_FUN);
        currentGlobalTermStats.put(e.getKey(), e.getValue());
    }

    protected static class ExactStatsSource
    extends StatsSource {
        private final Map<String, TermStats> termStatsCache;
        private final Map<String, CollectionStats> colStatsCache;
        private final StatsCache.StatsCacheMetrics metrics;

        public ExactStatsSource(StatsCache.StatsCacheMetrics metrics, Map<String, TermStats> termStatsCache, Map<String, CollectionStats> colStatsCache) {
            this.metrics = metrics;
            this.termStatsCache = termStatsCache;
            this.colStatsCache = colStatsCache;
        }

        @Override
        public TermStatistics termStatistics(SolrIndexSearcher localSearcher, Term term, int docFreq, long totalTermFreq) throws IOException {
            TermStats termStats = this.termStatsCache.get(term.toString());
            if (termStats == null) {
                log.debug("Missing global termStats info for term={}, using local stats", (Object)term);
                this.metrics.missingGlobalTermStats.increment();
                return localSearcher != null ? localSearcher.localTermStatistics(term, docFreq, totalTermFreq) : null;
            }
            return termStats.toTermStatistics();
        }

        @Override
        public CollectionStatistics collectionStatistics(SolrIndexSearcher localSearcher, String field) throws IOException {
            CollectionStats colStats = this.colStatsCache.get(field);
            if (colStats == null) {
                log.debug("Missing global colStats info for field={}, using local", (Object)field);
                this.metrics.missingGlobalFieldStats.increment();
                return localSearcher != null ? localSearcher.localCollectionStatistics(field) : null;
            }
            return colStats.toCollectionStatistics();
        }
    }
}

