/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import java.util.HashSet;
import java.util.Set;
import org.apache.atlas.repository.graphdb.AtlasGraphIndex;
import org.apache.atlas.repository.graphdb.AtlasPropertyKey;
import org.apache.atlas.repository.graphdb.janus.GraphDbObjectFactory;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphIndex;

public class AtlasJanusGraphIndex
implements AtlasGraphIndex {
    private JanusGraphIndex wrapped;

    public AtlasJanusGraphIndex(JanusGraphIndex toWrap) {
        this.wrapped = toWrap;
    }

    public boolean isEdgeIndex() {
        return Edge.class.isAssignableFrom(this.wrapped.getIndexedElement());
    }

    public boolean isVertexIndex() {
        return Vertex.class.isAssignableFrom(this.wrapped.getIndexedElement());
    }

    public boolean isUnique() {
        return this.wrapped.isUnique();
    }

    public Set<AtlasPropertyKey> getFieldKeys() {
        PropertyKey[] keys = this.wrapped.getFieldKeys();
        HashSet<AtlasPropertyKey> result = new HashSet<AtlasPropertyKey>();
        for (PropertyKey key : keys) {
            result.add(GraphDbObjectFactory.createPropertyKey(key));
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.wrapped.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AtlasJanusGraphIndex)) {
            return false;
        }
        AtlasJanusGraphIndex otherKey = (AtlasJanusGraphIndex)other;
        return otherKey.wrapped.equals(this.wrapped);
    }

    public boolean isMixedIndex() {
        return this.wrapped.isMixedIndex();
    }

    public boolean isCompositeIndex() {
        return this.wrapped.isCompositeIndex();
    }
}

