/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.hbase2;

import org.apache.hadoop.hbase.util.VersionInfo;
import org.janusgraph.diskstorage.hbase2.HBaseCompat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseCompatLoader {
    private static final Logger log = LoggerFactory.getLogger(HBaseCompatLoader.class);
    private static final String DEFAULT_HBASE_COMPAT_VERSION = "1.2";
    private static final String HBASE_VERSION_2_STRING = "2.";
    private static final String DEFAULT_HBASE_COMPAT_CLASS_NAME = "org.janusgraph.diskstorage.hbase2.HBaseCompat2_0";
    private static final String[] HBASE_SUPPORTED_VERSIONS = new String[]{"0.98", "1.0", "1.1", "1.2", "1.3", "2.0"};
    private static HBaseCompat cachedCompat;

    public static synchronized HBaseCompat getCompat(String classOverride) {
        HBaseCompat compat;
        if (null != cachedCompat) {
            log.debug("Returning cached HBase compatibility layer: {}", (Object)cachedCompat);
            return cachedCompat;
        }
        String className = null;
        String classNameSource = null;
        if (null != classOverride) {
            className = classOverride;
            classNameSource = "from explicit configuration";
        } else {
            String hbaseVersion = VersionInfo.getVersion();
            for (String supportedVersion : HBASE_SUPPORTED_VERSIONS) {
                if (!hbaseVersion.startsWith(supportedVersion + ".")) continue;
                className = hbaseVersion.startsWith(HBASE_VERSION_2_STRING) ? DEFAULT_HBASE_COMPAT_CLASS_NAME : "org.janusgraph.diskstorage.hbase2.HBaseCompat" + supportedVersion.replaceAll("\\.", "_");
                classNameSource = "supporting runtime HBase version " + hbaseVersion;
                break;
            }
            if (null == className) {
                log.info("The HBase version {} is not explicitly supported by JanusGraph.  Loading JanusGraph's compatibility layer for its most recent supported HBase version ({})", (Object)hbaseVersion, (Object)DEFAULT_HBASE_COMPAT_VERSION);
                className = DEFAULT_HBASE_COMPAT_CLASS_NAME;
                classNameSource = " by default";
            }
        }
        String errTemplate = " when instantiating HBase compatibility class " + className;
        try {
            compat = (HBaseCompat)Class.forName(className).newInstance();
            log.info("Instantiated HBase compatibility layer {}: {}", (Object)classNameSource, (Object)compat.getClass().getCanonicalName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + errTemplate, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + errTemplate, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + errTemplate, e);
        }
        cachedCompat = compat;
        return cachedCompat;
    }
}

