/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hook;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.atlas.utils.KafkaUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasTopicCreator {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasTopicCreator.class);
    public static final String ATLAS_NOTIFICATION_CREATE_TOPICS_KEY = "atlas.notification.create.topics";

    public void createAtlasTopic(Configuration atlasProperties, String ... topicNames) {
        if (atlasProperties.getBoolean(ATLAS_NOTIFICATION_CREATE_TOPICS_KEY, true)) {
            if (!this.handleSecurity(atlasProperties)) {
                return;
            }
            try (KafkaUtils kafkaUtils = this.getKafkaUtils(atlasProperties);){
                int numPartitions = atlasProperties.getInt("atlas.notification.partitions", 1);
                int numReplicas = atlasProperties.getInt("atlas.notification.replicas", 1);
                kafkaUtils.createTopics(Arrays.asList(topicNames), numPartitions, numReplicas);
            }
            catch (Exception e) {
                LOG.error("Error while creating topics e :" + e.getMessage(), (Throwable)e);
            }
        } else {
            LOG.info("Not creating topics {} as {} is false", (Object)StringUtils.join((Object[])topicNames, (String)","), (Object)ATLAS_NOTIFICATION_CREATE_TOPICS_KEY);
        }
    }

    @VisibleForTesting
    protected boolean handleSecurity(Configuration atlasProperties) {
        if (AuthenticationUtil.isKerberosAuthenticationEnabled((Configuration)atlasProperties)) {
            String kafkaPrincipal = atlasProperties.getString("atlas.notification.kafka.service.principal");
            String kafkaKeyTab = atlasProperties.getString("atlas.notification.kafka.keytab.location");
            org.apache.hadoop.conf.Configuration hadoopConf = new org.apache.hadoop.conf.Configuration();
            SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (org.apache.hadoop.conf.Configuration)hadoopConf);
            try {
                String serverPrincipal = SecurityUtil.getServerPrincipal((String)kafkaPrincipal, (String)null);
                UserGroupInformation.setConfiguration((org.apache.hadoop.conf.Configuration)hadoopConf);
                UserGroupInformation.loginUserFromKeytab((String)serverPrincipal, (String)kafkaKeyTab);
            }
            catch (IOException e) {
                LOG.warn("Could not login as {} from keytab file {}", new Object[]{kafkaPrincipal, kafkaKeyTab, e});
                return false;
            }
        }
        return true;
    }

    KafkaUtils getKafkaUtils(Configuration configuration) {
        return new KafkaUtils(configuration);
    }

    public static void main(String[] args) throws AtlasException {
        Configuration configuration = ApplicationProperties.get();
        AtlasTopicCreator atlasTopicCreator = new AtlasTopicCreator();
        atlasTopicCreator.createAtlasTopic(configuration, args);
    }
}

